/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsCheckVO;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsFile;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsFileInfo;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsFileVO;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsMethodVO;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsParam;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsPathVO;
import com.jxdinfo.hussar.formdesign.extend.model.RegisterJsMethodVO;
import com.jxdinfo.hussar.formdesign.extend.model.RegisterJsScriptFileVO;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ParsingUtil {
    private static final Pattern AUTHOR_PATTERN = Pattern.compile("(@author)(.*?)(\\*)");
    private static final Pattern METHOD_NAME_PARAM_PATTERN = Pattern.compile("(function)(\\s*)(\\S+)(\\((.*?)\\))");
    private static final Pattern PARAM_NAME_PATTERN = Pattern.compile("(?<=\\()(.*?)(?=\\))");
    private static final Pattern NAME_NOTE_SPATTERN = Pattern.compile("(@name)(.*?)(function)(\\s*)(\\S+)(\\((.*?)\\))");
    private static final Pattern NAME_PATTERN = Pattern.compile("(@name)(.*?)(\\*)");
    private static final Pattern CHINESE_NAME_PATTERN = Pattern.compile("(function)(.*?)(\\()");
    private static final Pattern DESCRIPTION_NOTE_SPATTERN = Pattern.compile("(@description)(.*?)(function)(\\s*)(\\S+)(\\((.*?)\\))");
    private static final Pattern PARAM_NOTE_SPATTERN = Pattern.compile("(\\@param)(.*?)(function)(\\s*)(\\S+)(\\((.*?)\\))");
    private static final Pattern PARAM_PATTERN = Pattern.compile("(@param)(.*?)(\\*\\/)");
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("(@description)(.*?)(\\*)");
    private static final Pattern multiline_comment_PATTERN = Pattern.compile("/\\*{1}[\\s\\S]*?\\*/");
    private static final Pattern SINGLELINE_COMMENT_PATTERN = Pattern.compile("//[\\s\\S]*?\\n");

    public static ExtendJsFileVO getJsFileInformation(String filePath) throws LcdpException {
        ExtendJsFileVO extendJsFileVO = new ExtendJsFileVO();
        try {
            Matcher authorMatcher = AUTHOR_PATTERN.matcher(ParsingUtil.getJsContent(filePath));
            while (authorMatcher.find()) {
                extendJsFileVO.setAuthor(authorMatcher.group().replaceAll("@author", "").replaceAll("\\*", "").trim());
            }
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(new File(filePath).lastModified());
            extendJsFileVO.setUpdateTime(cal.getTime().toLocaleString());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, filePath);
        }
        return extendJsFileVO;
    }

    public static RegisterJsScriptFileVO getJsFileDetail(String absolutePath, String relativePath) throws LcdpException {
        RegisterJsScriptFileVO extendJsFileVO = new RegisterJsScriptFileVO();
        extendJsFileVO.setFilePath(relativePath);
        extendJsFileVO.setFileName(relativePath.substring(relativePath.lastIndexOf("/") + 1));
        extendJsFileVO.setExists(true);
        ArrayList<RegisterJsMethodVO> methodList = new ArrayList<RegisterJsMethodVO>();
        try {
            String jsContent = FileUtils.readFileToString((File)new File(absolutePath), (String)"UTF-8");
            jsContent = ParsingUtil.removeAnnotation(jsContent);
            Matcher methodNameMatcher = METHOD_NAME_PARAM_PATTERN.matcher(jsContent);
            StringBuilder methodGroup = new StringBuilder();
            while (methodNameMatcher.find()) {
                methodGroup.append(methodNameMatcher.group());
            }
            if (StringUtil.isEmpty((Object)methodGroup.toString())) {
                extendJsFileVO.setMethods(methodList);
                return extendJsFileVO;
            }
            String[] methodName = methodGroup.toString().replaceAll("(function\\s)", "").replaceAll("\\((.*?)\\)", "&&,&&,&&").replaceAll(" ", "").split("&&,&&,&&");
            List<String> methodNameList = Arrays.asList(methodName);
            Matcher paramNameMatcher = PARAM_NAME_PATTERN.matcher(methodGroup.toString());
            ArrayList<String> paramNameList = new ArrayList<String>();
            while (paramNameMatcher.find()) {
                paramNameList.add(paramNameMatcher.group());
            }
            Matcher nameNotesMatcher = NAME_NOTE_SPATTERN.matcher(jsContent);
            StringBuffer nameNotesGroup = new StringBuffer();
            while (nameNotesMatcher.find()) {
                nameNotesGroup.append(nameNotesMatcher.group());
            }
            String[] chineseNames = null;
            String[] chineseNameMethodName = null;
            if (!ToolUtil.isEmpty((Object)nameNotesGroup)) {
                Matcher nameMatcher = NAME_PATTERN.matcher(nameNotesGroup.toString());
                StringBuilder chineseNameGroup = new StringBuilder();
                while (nameMatcher.find()) {
                    chineseNameGroup.append(nameMatcher.group());
                }
                chineseNames = chineseNameGroup.toString().replaceAll("\\*", "&&,&&,&&").replaceAll("@name", "").split("&&,&&,&&");
                Matcher chineseNameMatcher = CHINESE_NAME_PATTERN.matcher(nameNotesGroup.toString());
                StringBuilder chineseGroup = new StringBuilder();
                while (chineseNameMatcher.find()) {
                    chineseGroup.append(chineseNameMatcher.group());
                }
                chineseNameMethodName = chineseGroup.toString().replaceAll("function", "").replaceAll("\\(", "&&,&&,&&").replaceAll(" ", "").split("&&,&&,&&");
            }
            Matcher descriptionNotesMatcher = DESCRIPTION_NOTE_SPATTERN.matcher(jsContent);
            StringBuffer descriptionNotesGroup = new StringBuffer();
            while (descriptionNotesMatcher.find()) {
                descriptionNotesGroup.append(descriptionNotesMatcher.group());
            }
            String[] descriptions = null;
            String[] descriptionMethodName = null;
            if (!ToolUtil.isEmpty((Object)descriptionNotesGroup)) {
                Matcher descriptionMatcher = DESCRIPTION_PATTERN.matcher(descriptionNotesGroup.toString());
                StringBuilder descriptionGroup = new StringBuilder();
                while (descriptionMatcher.find()) {
                    descriptionGroup.append(descriptionMatcher.group());
                }
                descriptions = descriptionGroup.toString().replaceAll("\\*", "&&,&&,&&").replaceAll("@description", "").split("&&,&&,&&");
                Matcher functionDescriptionMatcher = CHINESE_NAME_PATTERN.matcher(descriptionNotesGroup.toString());
                StringBuilder functionDescriptionGroup = new StringBuilder();
                while (functionDescriptionMatcher.find()) {
                    functionDescriptionGroup.append(functionDescriptionMatcher.group());
                }
                descriptionMethodName = functionDescriptionGroup.toString().replaceAll("function", "").replaceAll("\\(", "&&,&&,&&").replaceAll(" ", "").split("&&,&&,&&");
            }
            Matcher paramNotesMatcher = PARAM_NOTE_SPATTERN.matcher(jsContent);
            StringBuffer paramNotesGroup = new StringBuffer();
            while (paramNotesMatcher.find()) {
                paramNotesGroup.append(paramNotesMatcher.group());
            }
            Matcher paramMatcher = PARAM_PATTERN.matcher(paramNotesGroup.toString());
            StringBuilder paramGroup = new StringBuilder();
            while (paramMatcher.find()) {
                paramGroup.append(paramMatcher.group());
            }
            String[] paramDescription = paramGroup.toString().replaceAll("@param ", "").replaceAll("\\*\\/", "&&;&&").replaceAll("\\*", "&&,&&,&&").replaceAll("\\@", "").split("&&;&&");
            Matcher paramFunctionNameMatcher = CHINESE_NAME_PATTERN.matcher(paramNotesGroup);
            StringBuilder containParamFunction = new StringBuilder();
            while (paramFunctionNameMatcher.find()) {
                containParamFunction.append(paramFunctionNameMatcher.group());
            }
            String[] paramMethodName = containParamFunction.toString().replaceAll("function", "").replaceAll("\\(", "&&,&&,&&").replaceAll(" ", "").split("&&,&&,&&");
            for (int i = 0; i < methodNameList.size(); ++i) {
                int j;
                ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
                ArrayList<ExtendJsParam> paramList = new ArrayList<ExtendJsParam>();
                RegisterJsMethodVO extendJsMethodVO = new RegisterJsMethodVO();
                if (StringUtil.isNotBlank((CharSequence)((CharSequence)paramNameList.get(i)))) {
                    String[] oneMethodParam;
                    for (String s : oneMethodParam = ((String)paramNameList.get(i)).split(",")) {
                        ExtendJsParam extendJsParam = new ExtendJsParam();
                        extendJsParam.setName(s.trim());
                        paramList.add(extendJsParam);
                    }
                }
                for (j = 0; j < paramMethodName.length; ++j) {
                    String[] methodParamNotes;
                    if (!paramMethodName[j].equals(methodNameList.get(i))) continue;
                    for (String methodParamNote : methodParamNotes = paramDescription[j].split("&&,&&,&&")) {
                        String[] oneMethodParamNotes = methodParamNote.trim().replaceAll("\\s{1,}", " ").split(" ");
                        for (ExtendJsParam extendJsParam : paramList) {
                            if (!extendJsParam.getName().equals(oneMethodParamNotes[0]) || oneMethodParamNotes.length < 2) continue;
                            String content = oneMethodParamNotes[1];
                            for (int k = 2; k < oneMethodParamNotes.length; ++k) {
                                content = content + " " + oneMethodParamNotes[k];
                            }
                            extendJsParam.setDescription(content);
                            result.put(oneMethodParamNotes[0], content);
                        }
                    }
                }
                if (descriptionMethodName != null) {
                    for (j = 0; j < descriptionMethodName.length; ++j) {
                        if (!descriptionMethodName[j].equals(methodNameList.get(i))) continue;
                        extendJsMethodVO.setAnnotation(descriptions[j].trim());
                    }
                }
                if (chineseNameMethodName != null) {
                    for (j = 0; j < chineseNameMethodName.length; ++j) {
                        if (!chineseNameMethodName[j].equals(methodNameList.get(i))) continue;
                        extendJsMethodVO.setDescription(chineseNames[j].trim());
                    }
                }
                extendJsMethodVO.setName(methodNameList.get(i));
                extendJsMethodVO.setParams(paramList);
                methodList.add(extendJsMethodVO);
            }
            extendJsFileVO.setMethods(methodList);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, relativePath);
        }
        return extendJsFileVO;
    }

    public static ExtendJsCheckVO checkMethod(String filePath) throws LcdpException {
        ExtendJsCheckVO extendJsCheckVO = new ExtendJsCheckVO();
        StringBuilder methodGroup = new StringBuilder();
        int error = 0;
        try {
            String jsContent = FileUtils.readFileToString((File)new File(filePath), (String)"UTF-8");
            jsContent = ParsingUtil.removeAnnotation(jsContent);
            Matcher methodMatcher = CHINESE_NAME_PATTERN.matcher(jsContent);
            while (methodMatcher.find()) {
                methodGroup.append(methodMatcher.group());
            }
            String[] methods = methodGroup.toString().replaceAll("function", "").replaceAll(" ", "").replaceAll("\\(", "&&,&&,&&").split("&&,&&,&&");
            ArrayList<ExtendJsMethodVO> methodList = new ArrayList<ExtendJsMethodVO>();
            HashMap functionMap = new HashMap();
            HashMap repeatMap = new HashMap();
            for (String method : methods) {
                if (StringUtil.isEmpty((Object)method)) continue;
                ExtendJsMethodVO extendJsMethodVO = new ExtendJsMethodVO();
                extendJsMethodVO.setName(method);
                if (functionMap.containsKey(method)) {
                    repeatMap.put(method, null);
                } else {
                    extendJsMethodVO.setCheckState(0);
                    functionMap.put(method, null);
                }
                methodList.add(extendJsMethodVO);
            }
            HashMap addMap = new HashMap();
            ArrayList<ExtendJsMethodVO> reMethodList = new ArrayList<ExtendJsMethodVO>();
            for (ExtendJsMethodVO methodVO : methodList) {
                if (!repeatMap.containsKey(methodVO.getName())) continue;
                if (addMap.containsKey(methodVO.getName())) {
                    reMethodList.add(methodVO);
                    continue;
                }
                addMap.put(methodVO.getName(), null);
                methodVO.setCheckState(1);
                ++error;
            }
            methodList.removeAll(reMethodList);
            extendJsCheckVO.setMethods(methodList);
            extendJsCheckVO.setTotal(methodList.size());
            extendJsCheckVO.setError(error);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, filePath);
        }
        return extendJsCheckVO;
    }

    public static List<String> getFilePath(String filepath, String type) throws IOException, LcdpException {
        return FileUtils.getFilePath((String)filepath, (String)type);
    }

    public static Map<String, List<ExtendJsFile>> groupByFile(List<String> filePath, String sourcePath) {
        ArrayList<ExtendJsFile> fileList = new ArrayList<ExtendJsFile>();
        for (String path : filePath) {
            ExtendJsFile jsFile = new ExtendJsFile();
            File file2 = new File(path);
            if (!FileUtils.exists((File)file2) || !FileUtils.isFile((File)file2)) continue;
            jsFile.setFileName(file2.getName());
            jsFile.setSize(ParsingUtil.calculateSize(file2.length()));
            jsFile.setFilePath(path.replace(sourcePath, ""));
            String subPath = path.replace(sourcePath, "").replace(File.separator + file2.getName(), "");
            if (!StringUtil.isEmpty((Object)subPath) && !File.separator.equals(subPath)) {
                String currentPath = subPath.substring(subPath.lastIndexOf(File.separator) + 1);
                jsFile.setPath(subPath);
                jsFile.setLabel(currentPath);
                if (currentPath.equals(subPath.replace(File.separator, ""))) {
                    jsFile.setParentPath("#");
                } else {
                    jsFile.setParentPath(subPath.substring(0, subPath.lastIndexOf(File.separator)));
                }
            } else {
                jsFile.setLabel("#");
                jsFile.setPath("#");
                jsFile.setParentPath("0");
            }
            fileList.add(jsFile);
        }
        return fileList.stream().collect(Collectors.groupingBy(file -> file.getLabel() + "," + file.getPath() + "," + file.getParentPath()));
    }

    private static String calculateSize(long size) {
        String sizeStr = size == 0L ? "0 KB" : (size < 1024L ? "1 KB" : (size < 0x100000L ? size / 1024L + 1L + " KB" : size / 0x100000L + 1L + " M"));
        return sizeStr;
    }

    public static Map<String, String> getJsdPath(List<String> metaPath) throws LcdpException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            for (String path : metaPath) {
                String content = FileUtils.readFileToString((File)new File(path), (String)"UTF-8");
                ExtendJsFileInfo fileInfo = (ExtendJsFileInfo)((Object)JSON.parseObject((String)content, ExtendJsFileInfo.class));
                map.put(fileInfo.getFilePath().replaceAll("\\\\", "").replaceAll("/", ""), null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, metaPath.toString());
        }
        return map;
    }

    public static boolean fileExistsByPath(String filePath) {
        return FileUtils.exists((File)new File(filePath));
    }

    public static RegisterJsScriptFileVO compareFile(RegisterJsScriptFileVO sourceFile, RegisterJsScriptFileVO registeredFile) {
        Object paramMap;
        if (sourceFile == null || registeredFile == null) {
            return null;
        }
        registeredFile.setFilePath(sourceFile.getFilePath());
        registeredFile.setFileName(sourceFile.getFileName());
        HashMap<String, Iterator<RegisterJsMethodVO>> functionMap = new HashMap<String, Iterator<RegisterJsMethodVO>>();
        HashMap functionMapList = new HashMap();
        for (RegisterJsMethodVO methodVO : sourceFile.getMethods()) {
            if (functionMap.containsKey(methodVO.getName())) continue;
            ArrayList<String> funList = new ArrayList<String>();
            paramMap = new HashMap();
            for (ExtendJsParam param : methodVO.getParams()) {
                if (!paramMap.containsKey(param.getName())) {
                    paramMap.put(param.getName(), param.getDescription());
                }
                funList.add(param.getName());
            }
            functionMapList.put(methodVO.getName(), funList);
            functionMap.put(methodVO.getName(), (Iterator<RegisterJsMethodVO>)paramMap);
        }
        HashMap registeredMap = new HashMap();
        for (RegisterJsMethodVO methodVO : registeredFile.getMethods()) {
            if (functionMap.containsKey(methodVO.getName())) {
                if (StringUtil.isEmpty((Object)methodVO.getDescription())) {
                    for (RegisterJsMethodVO sourceMethod : sourceFile.getMethods()) {
                        if (!sourceMethod.getName().equals(methodVO.getName()) || !StringUtil.isNotBlank((CharSequence)sourceMethod.getDescription())) continue;
                        methodVO.setDescription(sourceMethod.getDescription());
                        break;
                    }
                }
                if (StringUtil.isEmpty((Object)methodVO.getAnnotation())) {
                    for (RegisterJsMethodVO sourceMethod : sourceFile.getMethods()) {
                        if (!sourceMethod.getName().equals(methodVO.getName()) || !StringUtil.isNotBlank((CharSequence)sourceMethod.getAnnotation())) continue;
                        methodVO.setAnnotation(sourceMethod.getAnnotation());
                        break;
                    }
                }
                paramMap = (Map)functionMap.get(methodVO.getName());
                HashMap registeredParamMap = new HashMap();
                HashMap<String, ExtendJsParam> normalParam = new HashMap<String, ExtendJsParam>();
                HashMap<String, ExtendJsParam> deleteParam = new HashMap<String, ExtendJsParam>();
                int funtionFlag = -1;
                for (ExtendJsParam extendJsParam : methodVO.getParams()) {
                    if (paramMap.containsKey(extendJsParam.getName())) {
                        extendJsParam.setCheckState(-1);
                        if (StringUtil.isEmpty((Object)extendJsParam.getDescription()) && StringUtil.isNotBlank((CharSequence)((CharSequence)paramMap.get(extendJsParam.getName())))) {
                            extendJsParam.setDescription((String)paramMap.get(extendJsParam.getName()));
                        }
                        normalParam.put(extendJsParam.getName(), extendJsParam);
                    } else {
                        extendJsParam.setCheckState(2);
                        funtionFlag = 1;
                        deleteParam.put(extendJsParam.getName(), extendJsParam);
                    }
                    registeredParamMap.put(extendJsParam.getName(), null);
                }
                for (Map.Entry entry : paramMap.entrySet()) {
                    if (registeredParamMap.containsKey(entry.getKey())) continue;
                    ExtendJsParam extendJsParam = new ExtendJsParam();
                    extendJsParam.setCheckState(0);
                    funtionFlag = 1;
                    extendJsParam.setName((String)entry.getKey());
                    extendJsParam.setDescription((String)entry.getValue());
                    normalParam.put((String)entry.getKey(), extendJsParam);
                }
                ArrayList<ExtendJsParam> newParamList = new ArrayList<ExtendJsParam>();
                for (String string : (List)functionMapList.get(methodVO.getName())) {
                    newParamList.add((ExtendJsParam)normalParam.get(string));
                }
                for (Map.Entry entry : deleteParam.entrySet()) {
                    newParamList.add((ExtendJsParam)entry.getValue());
                }
                methodVO.setParams(newParamList);
                methodVO.setCheckState(funtionFlag);
            } else {
                methodVO.setCheckState(2);
            }
            registeredMap.put(methodVO.getName(), null);
        }
        for (RegisterJsMethodVO methodVO : sourceFile.getMethods()) {
            if (registeredMap.containsKey(methodVO.getName())) continue;
            methodVO.setCheckState(0);
            registeredFile.getMethods().add(methodVO);
        }
        registeredFile.setExists(true);
        return registeredFile;
    }

    public static List<ExtendJsPathVO> recursiveFilePath(String id, List<ExtendJsPathVO> pathList) {
        ArrayList<ExtendJsPathVO> childList = new ArrayList<ExtendJsPathVO>();
        for (ExtendJsPathVO nav : pathList) {
            if (!nav.getParentPath().equals(id)) continue;
            childList.add(nav);
        }
        for (ExtendJsPathVO nav : childList) {
            nav.setChildren(ParsingUtil.recursiveFilePath(nav.getPath(), pathList));
        }
        if (childList.size() == 0) {
            return new ArrayList<ExtendJsPathVO>();
        }
        return childList;
    }

    public static void createBlankDirectory(List<ExtendJsPathVO> pathList) {
        for (int i = 0; i < pathList.size(); ++i) {
            ExtendJsPathVO pathVO = pathList.get(i);
            if ("0".equals(pathVO.getParentPath()) || "#".equals(pathVO.getParentPath())) continue;
            boolean flag = false;
            for (ExtendJsPathVO pathVOTwo : pathList) {
                if (!pathVO.getParentPath().equals(pathVOTwo.getPath())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            ExtendJsPathVO BlankVO = new ExtendJsPathVO();
            BlankVO.setPath(pathVO.getParentPath());
            BlankVO.setLabel(pathVO.getParentPath().substring(pathVO.getParentPath().lastIndexOf(File.separator) + 1));
            if (pathVO.getParentPath().lastIndexOf(File.separator) < 1) {
                BlankVO.setParentPath("#");
            } else {
                BlankVO.setParentPath(pathVO.getParentPath().substring(0, pathVO.getParentPath().lastIndexOf(File.separator)));
            }
            BlankVO.setListFile(new ArrayList<ExtendJsFileVO>());
            pathList.add(BlankVO);
            ParsingUtil.createBlankDirectory(pathList);
        }
    }

    public static String getJsContent(String filePath) throws IOException {
        return FileUtils.getJsContent((String)filePath);
    }

    public static String removeAnnotation(String content) {
        if (StringUtil.isEmpty((Object)content)) {
            return "";
        }
        Matcher foundMultiLineComment = multiline_comment_PATTERN.matcher(content);
        while (foundMultiLineComment.find()) {
            String replaceStr = foundMultiLineComment.group();
            if (!replaceStr.contains("/*") || replaceStr.contains("function")) {
                content = content.replace(replaceStr, "");
                continue;
            }
            if (!replaceStr.contains("/*") || !ParsingUtil.remove(replaceStr, content)) continue;
            content = content.replace(replaceStr, "");
        }
        Matcher foundSingleLineComment = SINGLELINE_COMMENT_PATTERN.matcher(content);
        while (foundSingleLineComment.find()) {
            content = content.replace(foundSingleLineComment.group(), "");
        }
        return content.replaceAll("[\r\n]", "").replaceAll("\\u00A0", "");
    }

    public static boolean remove(String replaceStr, String content) {
        Pattern pattern;
        String pattStr;
        Pattern patternTwo;
        String str = replaceStr.replaceAll("[\r\n]", "");
        String newContent = content.replaceAll("[\r\n]", "");
        Matcher newMatcher = null;
        if (replaceStr.contains("@name")) {
            patternTwo = Pattern.compile("@name[\\s\\S]*");
            newMatcher = patternTwo.matcher(str);
            pattStr = "@name";
            while (newMatcher.find()) {
                pattStr = newMatcher.group();
            }
            pattStr = pattStr.substring(0, pattStr.indexOf("*")).replace("{", "\\{").replace("}", "\\}").replace("[", "\\[").replace("]", "\\]");
            pattern = Pattern.compile('(' + pattStr + ")(.*?)(function)(\\s*)(\\S+)(\\((.*?)\\))");
        } else if (replaceStr.contains("@description")) {
            patternTwo = Pattern.compile("@description[\\s\\S]*");
            newMatcher = patternTwo.matcher(str);
            pattStr = "@description";
            while (newMatcher.find()) {
                pattStr = newMatcher.group();
            }
            pattStr = pattStr.substring(0, pattStr.indexOf("*")).replace("{", "\\{").replace("}", "\\}").replace("[", "\\[").replace("]", "\\]");
            pattern = Pattern.compile('(' + pattStr + ")(.*?)(function)(\\s*)(\\S+)(\\((.*?)\\))");
        } else if (replaceStr.contains("@param")) {
            patternTwo = Pattern.compile("@param[\\s\\S]*");
            newMatcher = patternTwo.matcher(str);
            pattStr = "@param";
            while (newMatcher.find()) {
                pattStr = newMatcher.group();
            }
            pattStr = pattStr.substring(0, pattStr.indexOf("*")).replace("{", "\\{").replace("}", "\\}").replace("[", "\\[").replace("]", "\\]");
            pattern = Pattern.compile('(' + pattStr + ")(.*?)(function)(\\s*)(\\S+)(\\((.*?)\\))");
        } else {
            return false;
        }
        Matcher matcher = pattern.matcher(newContent);
        while (matcher.find()) {
            if (!matcher.group().contains("//") && !matcher.group().contains("/*")) continue;
            return true;
        }
        return false;
    }

    public static void addBlankRootDirectory(List<ExtendJsPathVO> pathVOList) {
        if (pathVOList.size() > 0) {
            boolean blankFile = true;
            for (ExtendJsPathVO pathVO : pathVOList) {
                if (!"0".equals(pathVO.getParentPath())) continue;
                blankFile = false;
                break;
            }
            if (blankFile) {
                ExtendJsPathVO pathVO = new ExtendJsPathVO();
                pathVO.setParentPath("0");
                pathVO.setListFile(new ArrayList<ExtendJsFileVO>());
                pathVO.setLabel("#");
                pathVO.setPath("#");
                pathVO.setChildren(new ArrayList<ExtendJsPathVO>());
                pathVOList.add(pathVO);
            }
        }
    }
}

