/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.service.impl;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaDefinedVO;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaType;
import com.jxdinfo.hussar.formdesign.extend.service.ExtendFormulaService;
import com.jxdinfo.hussar.formdesign.extend.util.FormulaExcelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.IOException;
import java.util.List;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="extendFormulaServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class})
public class ExtendFormulaServiceImpl
implements ExtendFormulaService {
    private static final String cache = "extendFormulaDefinedCache";
    private static final String TYPE_CACHE = "formulaPathTypeCache";

    @Override
    public List<ExtendFormulaDefinedVO> getFormulaDefinedList() {
        List<ExtendFormulaDefinedVO> list;
        try {
            new FormulaExcelUtil().readTypePath();
            list = (List<ExtendFormulaDefinedVO>)DefaultCacheUtil.get((Object)cache);
            if (ToolUtil.isEmpty((Object)list)) {
                list = new FormulaExcelUtil().readExcel();
                DefaultCacheUtil.put((Object)cache, list);
            }
        }
        catch (IOException e) {
            throw new HussarException("\u83b7\u53d6\u5217\u8868\u5931\u8d25");
        }
        return list;
    }

    @Override
    public String getPath(String methods, String pageType) {
        List<ExtendFormulaType> types = (List<ExtendFormulaType>)DefaultCacheUtil.get((Object)TYPE_CACHE);
        if (HussarUtils.isEmpty((Object)types)) {
            try {
                types = new FormulaExcelUtil().readTypePath();
                DefaultCacheUtil.put((Object)TYPE_CACHE, types);
            }
            catch (IOException e) {
                throw new HussarException("\u83b7\u53d6\u591a\u7aef\u4e0d\u540c\u8def\u5f84\u5217\u8868\u5931\u8d25");
            }
        }
        return types.stream().filter(type -> type.getPageType().equals(pageType) && type.getMethods().equals(methods)).findFirst().orElse(new ExtendFormulaType()).getPath();
    }
}

