/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.component.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.component.constant.ComponentType;
import com.jxdinfo.hussar.formdesign.component.model.CompatibleVersions;
import com.jxdinfo.hussar.formdesign.component.model.ComponentCategoryInfo;
import com.jxdinfo.hussar.formdesign.component.model.ComponentDependence;
import com.jxdinfo.hussar.formdesign.component.model.ComponentGroupInfo;
import com.jxdinfo.hussar.formdesign.component.model.ComponentInfo;
import com.jxdinfo.hussar.formdesign.component.model.CustomComponentInfo;
import com.jxdinfo.hussar.formdesign.component.service.ComponentCategoryService;
import com.jxdinfo.hussar.formdesign.component.service.ComponentService;
import com.jxdinfo.hussar.formdesign.component.service.CustomComponentService;
import com.jxdinfo.hussar.formdesign.external.require.engine.utils.LrEngineUtil;
import com.jxdinfo.hussar.formdesign.properties.LcdpVersionProperties;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CustomComponentServiceImpl
implements CustomComponentService {
    @Autowired
    private FormDesignProperties formDesignProperties;
    @Autowired
    private LcdpVersionProperties lcdpVersionProperties;
    @Autowired
    private ComponentCategoryService componentCategoryService;
    @Autowired
    private ComponentService componentService;
    @Autowired
    private PathStrategyService pathStrategy;
    private static final Logger logger = LoggerFactory.getLogger(CustomComponentInfo.class);

    @Override
    public void addCustomComponent(String customComponentInfoStr, MultipartFile file) throws IOException, LcdpException {
        CustomComponentInfo customComponentInfo = (CustomComponentInfo)JSONObject.parseObject((String)URLDecoder.decode(customComponentInfoStr, "UTF-8"), CustomComponentInfo.class);
        ComponentInfo componentInfo = this.writeCustomComponent(customComponentInfo);
        if (HussarUtils.isNotEmpty((Object)customComponentInfo.getCover())) {
            this.upload(file, componentInfo.getId(), componentInfo.getPageType());
        }
    }

    @Override
    public synchronized ApiResponse<Boolean> editCustomComponent(CustomComponentInfo customComponentInfo) throws IOException {
        List<ComponentInfo> componentInfos = this.componentService.getComponentInfos(ComponentType.CUSTOM.getValue());
        int count = -1;
        for (int i = 0; i < componentInfos.size(); ++i) {
            if (!componentInfos.get(i).getId().equals(customComponentInfo.getName())) continue;
            count = i;
        }
        if (count == -1) {
            return ApiResponse.fail((String)"\u8be5\u7ec4\u4ef6\u4e0d\u5b58\u5728");
        }
        ComponentInfo componentInfo = this.createComponent(customComponentInfo);
        componentInfos.set(count, componentInfo);
        this.componentService.writeComponentInfos(componentInfos, ComponentType.CUSTOM.getValue());
        String rootPath = componentInfo.getComponentIOPath(this.pathStrategy.resourcePathService().getComponentIOPath());
        File toFile = new File(FileUtil.systemPath((String[])new String[]{rootPath, componentInfo.getCustomFileName()}));
        org.apache.commons.io.FileUtils.writeStringToFile((File)toFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)customComponentInfo), (String)"UTF-8", (boolean)false);
        return ApiResponse.success((Object)true);
    }

    @Override
    public ComponentInfo writeCustomComponent(CustomComponentInfo customComponentInfo) throws IOException {
        ComponentInfo componentInfo = this.createComponent(customComponentInfo);
        this.componentService.addComponent(componentInfo);
        if (HussarUtils.isEmpty((Object)customComponentInfo.getReferences())) {
            customComponentInfo.setReferences(new JSONObject());
        }
        String rootPath = componentInfo.getComponentIOPath(this.pathStrategy.resourcePathService().getComponentIOPath());
        File toFile = new File(FileUtil.systemPath((String[])new String[]{rootPath, componentInfo.getCustomFileName()}));
        org.apache.commons.io.FileUtils.writeStringToFile((File)toFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)customComponentInfo), (String)"UTF-8", (boolean)false);
        File componentInfoJson = new File(FileUtil.systemPath((String[])new String[]{rootPath, "componentInfo.json"}));
        org.apache.commons.io.FileUtils.writeStringToFile((File)componentInfoJson, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)componentInfo), (String)"UTF-8", (boolean)false);
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u7ec4\u4ef6\u4e2d\u95f4\u6587\u4ef6\uff1a%s,%s", toFile.getName(), componentInfoJson.getName()), Arrays.asList(toFile.getAbsolutePath(), componentInfoJson.getAbsolutePath()));
        return componentInfo;
    }

    @Override
    public List<CustomComponentInfo> getAllCustomComponentInfo() throws IOException {
        ArrayList<CustomComponentInfo> customComponents = new ArrayList<CustomComponentInfo>();
        List<ComponentInfo> componentInfos = this.componentService.getComponentInfos(ComponentType.CUSTOM.getValue());
        for (ComponentInfo componentInfo : componentInfos) {
            CustomComponentInfo customComponentInfo = this.getCustomJson(componentInfo);
            customComponents.add(customComponentInfo);
        }
        return customComponents;
    }

    @Override
    public CustomComponentInfo getCustomJson(ComponentInfo componentInfo) throws IOException {
        String path = componentInfo.getComponentIOPath(this.pathStrategy.resourcePathService().getComponentIOPath());
        String customJsonPath = FileUtil.systemPath((String[])new String[]{path, componentInfo.getCustomFileName()});
        String jsonStr = null;
        try {
            jsonStr = org.apache.commons.io.FileUtils.readFileToString((File)new File(customJsonPath), (String)"UTF-8");
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u81ea\u5b9a\u4e49\u7ec4\u4ef6json\u5931\u8d25", (Throwable)e);
        }
        if (HussarUtils.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        return (CustomComponentInfo)JSONObject.parseObject((String)jsonStr, CustomComponentInfo.class);
    }

    @Override
    public boolean delCustomComponent(String id) throws IOException {
        ComponentInfo componentInfo = this.componentService.getComponentById(id);
        if (HussarUtils.isEmpty((Object)componentInfo)) {
            return false;
        }
        this.componentService.delComponetFile(componentInfo);
        this.delComponentInfo(id);
        return true;
    }

    public void upload(MultipartFile file, String id, String page) throws LcdpException {
        String fileSavePath = FileUtil.systemPath((String[])new String[]{this.pathStrategy.resourcePathService().getComponentIOPath(), page, id});
        FileUtils.upload((MultipartFile)file, (String)fileSavePath);
        VfgModeTool.pushToRemote((String)String.format("\u63d0\u4ea4\u7ec4\u4ef6\u5c01\u9762\u56fe\u7247\uff1a%s", file.getOriginalFilename()), Collections.singletonList(fileSavePath));
    }

    @Override
    public ResponseEntity<byte[]> getFile(String fileName, String page, String id) throws IOException {
        String fileSavePath = FileUtil.systemPath((String[])new String[]{this.pathStrategy.resourcePathService().getComponentIOPath(), page, id});
        File file = new File(fileSavePath + File.separator + fileName);
        String ext = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (HussarUtils.isBlank((CharSequence)ext)) {
            return null;
        }
        MediaType mime = ext.equalsIgnoreCase("jpg") ? MediaType.IMAGE_JPEG : (ext.equalsIgnoreCase("png") ? MediaType.IMAGE_PNG : MediaType.IMAGE_JPEG);
        if (FileUtils.exists((File)file) && !FileUtils.isDirectory((File)file)) {
            byte[] bytes = FileUtils.readFileToByteArray((File)file);
            return ResponseEntity.ok().contentType(mime).body((Object)bytes);
        }
        return null;
    }

    public ComponentInfo createComponent(CustomComponentInfo customComponentInfo) throws IOException {
        ComponentInfo componentInfo = new ComponentInfo();
        componentInfo.setId(customComponentInfo.getName());
        componentInfo.setName(customComponentInfo.getLabel());
        componentInfo.setType(ComponentType.CUSTOM.getValue());
        componentInfo.setCoverFileName(customComponentInfo.getCover());
        componentInfo.setCustomFileName(customComponentInfo.getName() + ".json");
        componentInfo.setCompPanelCategory(customComponentInfo.getCompPanelCategory());
        componentInfo.setCategory(customComponentInfo.getCategory());
        componentInfo.setPageType(customComponentInfo.getPageType());
        if (HussarUtils.isNotEmpty((Object)customComponentInfo.getCover())) {
            componentInfo.setCoverFileName(customComponentInfo.getCover());
        }
        CompatibleVersions lcdpVersions = new CompatibleVersions();
        lcdpVersions.setRules("scope");
        ArrayList<String> version = new ArrayList<String>();
        version.add(this.lcdpVersionProperties.getLcdpVersion());
        lcdpVersions.setVersions(version);
        componentInfo.setLcdpVersions(lcdpVersions);
        ArrayList<ComponentDependence> dependences = new ArrayList<ComponentDependence>();
        block0: for (JSONObject object : customComponentInfo.getDatas()) {
            String code = (String)object.get((Object)"name");
            List<ComponentInfo> componentInfos = this.componentService.getComponentInfos(ComponentType.EXTENSION.getValue());
            for (ComponentInfo component : componentInfos) {
                if (!code.equals(component.getCode())) continue;
                ComponentDependence dependence = new ComponentDependence();
                dependence.setCode(code);
                dependence.setName(component.getName());
                dependence.setVersion(component.getVersion());
                dependence.setCompatibleVersions(component.getCompatibleVersions());
                dependences.add(dependence);
                continue block0;
            }
        }
        if (HussarUtils.isNotEmpty(dependences)) {
            componentInfo.setDependencies(dependences);
        }
        return componentInfo;
    }

    public void delComponentInfo(String id) throws IOException {
        List<ComponentInfo> componentInfos = this.componentService.getComponentInfos(ComponentType.CUSTOM.getValue());
        Iterator<ComponentInfo> iterator = componentInfos.iterator();
        while (iterator.hasNext()) {
            ComponentInfo componentInfo = iterator.next();
            if (!id.equals(componentInfo.getId())) continue;
            iterator.remove();
            break;
        }
        this.componentService.writeComponentInfos(componentInfos, ComponentType.CUSTOM.getValue());
    }

    @Override
    public void init() {
        try {
            this.initByPage("WebPage");
        }
        catch (LcdpException | IOException e) {
            e.printStackTrace();
        }
        try {
            this.initByPage("MobilePage");
        }
        catch (LcdpException | IOException e) {
            e.printStackTrace();
        }
        File thisFile = new File(this.pathStrategy.resourcePathService().getProjectAndCustomComponentsPath());
        FileUtils.deleteQuietly((File)thisFile);
    }

    public ComponentCategoryInfo checkAndCreatMyCategory(List<ComponentCategoryInfo> componentCategoryInfos, String page) {
        ComponentCategoryInfo componentCategoryInfo = null;
        for (ComponentCategoryInfo categoryInfo : componentCategoryInfos) {
            if (!"custom".equals(categoryInfo.getName())) continue;
            componentCategoryInfo = categoryInfo;
        }
        if (HussarUtils.isEmpty(componentCategoryInfo)) {
            componentCategoryInfo = new ComponentCategoryInfo();
            componentCategoryInfo.setName("custom");
            componentCategoryInfo.setLabel("\u6211\u7684");
            componentCategoryInfo.setIconClass("axe-component-custom");
            ArrayList<ComponentGroupInfo> componentGroupInfos = new ArrayList<ComponentGroupInfo>();
            componentCategoryInfo.setChildren(componentGroupInfos);
            componentCategoryInfo.setLibName(page);
            componentCategoryInfos.add(0, componentCategoryInfo);
        }
        return componentCategoryInfo;
    }

    public void initByPage(String page) throws IOException, LcdpException {
        List<ComponentCategoryInfo> componentCategoryInfos = this.componentCategoryService.getAllComponentCategoryInfo(page);
        ComponentCategoryInfo componentCategoryInfo = this.checkAndCreatMyCategory(componentCategoryInfos, page);
        List<ComponentGroupInfo> componentGroupInfos = componentCategoryInfo.getChildren();
        HashMap<String, String> groupMap = new HashMap<String, String>();
        for (ComponentGroupInfo componentGroupInfo : componentGroupInfos) {
            groupMap.put(componentGroupInfo.getName(), componentGroupInfo.getLabel());
        }
        Map<String, List<JSONObject>> fileMap = this.getFileTree(page);
        List<JSONObject> components = fileMap.get("components");
        List<JSONObject> categorys = fileMap.get("categorys");
        for (JSONObject jsonObject : components) {
            CustomComponentInfo customComponentInfo = (CustomComponentInfo)JSONObject.toJavaObject((JSON)jsonObject, CustomComponentInfo.class);
            customComponentInfo.setName(LrEngineUtil.nextId() + "");
            customComponentInfo.setPageType(page);
            customComponentInfo.setCompPanelCategory(componentCategoryInfo.getName());
            ComponentInfo componentInfo = this.writeCustomComponent(customComponentInfo);
            if (!HussarUtils.isNotEmpty((Object)customComponentInfo.getCover())) continue;
            String fileSavePath = this.pathStrategy.resourcePathService().getProjectAndCustomComponentCoverPath();
            File file = new File(fileSavePath + File.separator + customComponentInfo.getCover());
            String toPath = FileUtil.systemPath((String[])new String[]{componentInfo.getComponentIOPath(this.pathStrategy.resourcePathService().getComponentIOPath()), customComponentInfo.getCover()});
            File toFile = new File(toPath);
            file.renameTo(toFile);
        }
        for (JSONObject jsonObject : categorys) {
            ComponentGroupInfo componentGroupInfo = (ComponentGroupInfo)JSONObject.toJavaObject((JSON)jsonObject, ComponentGroupInfo.class);
            if (!HussarUtils.isNotEmpty(groupMap.get(componentGroupInfo.getName()))) continue;
            componentGroupInfo.setCompPanelCategory(componentCategoryInfo.getName());
            componentGroupInfos.add(componentGroupInfo);
        }
        if (componentGroupInfos.size() > 0) {
            this.componentCategoryService.addCategory(componentCategoryInfo);
        }
    }

    public Map<String, List<JSONObject>> getFileTree(String libName) throws IOException {
        File file = new File(ToolUtil.pathFomatterByOS((String)(this.pathStrategy.resourcePathService().getProjectAndCustomComponentsPath() + File.separator + libName)));
        HashMap<String, List<JSONObject>> fileMap = new HashMap<String, List<JSONObject>>();
        ArrayList components = new ArrayList();
        ArrayList categorys = new ArrayList();
        fileMap.put("components", components);
        fileMap.put("categorys", categorys);
        if (!FileUtils.exists((File)file)) {
            return fileMap;
        }
        this.iterator(fileMap, file);
        return fileMap;
    }

    private void iterator(Map<String, List<JSONObject>> fileMap, File file) throws IOException {
        if (!FileUtils.isDirectory((File)file)) {
            return;
        }
        Object[] files = FileUtils.listFiles((File)file);
        if (HussarUtils.isEmpty((Object[])files)) {
            return;
        }
        for (Object childFile : files) {
            if (FileUtils.isDirectory((File)childFile)) {
                this.iterator(fileMap, (File)childFile);
                continue;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)childFile, (String)"UTF-8"));
            if (jsonObject == null) continue;
            String type = jsonObject.getString("fileType");
            if (ToolUtil.isNotEmpty((Object)type) && "component".equals(type)) {
                fileMap.get("components").add(jsonObject);
                continue;
            }
            if (!ToolUtil.isNotEmpty((Object)type) || !"category".equals(type)) continue;
            fileMap.get("categorys").add(jsonObject);
        }
    }
}

