/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.component.controller;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.component.model.CustomComponentInfo;
import com.jxdinfo.hussar.formdesign.component.service.CustomComponentService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"importComponent/customComponent"})
public class CustomComponentController {
    @Autowired
    private CustomComponentService customComponentService;

    @PostMapping(value={"/add"})
    public ApiResponse<Boolean> addCustomComponent(@RequestParam(value="customComponentInfo") String customComponentInfo, @RequestPart(required=false, value="file") MultipartFile file) throws IOException, LcdpException {
        this.customComponentService.addCustomComponent(customComponentInfo, file);
        return ApiResponse.success((Object)true);
    }

    @PostMapping(value={"/edit"})
    public ApiResponse<Boolean> editCustomComponent(@RequestBody CustomComponentInfo customComponentInfo) throws IOException {
        return this.customComponentService.editCustomComponent(customComponentInfo);
    }

    @RequestMapping(value={"/getAll"})
    public ApiResponse<List<CustomComponentInfo>> getAllCustomComponentInfo() throws IOException {
        List<CustomComponentInfo> customComponentInfos = this.customComponentService.getAllCustomComponentInfo();
        return ApiResponse.success(customComponentInfos);
    }

    @GetMapping(value={"/del"})
    public ApiResponse<Boolean> delCustomComponent(String id) throws IOException {
        return this.customComponentService.delCustomComponent(id) ? ApiResponse.success((Object)true) : ApiResponse.fail((String)"");
    }

    @PostMapping(value={"/getCover"})
    public ResponseEntity<byte[]> getFile(@RequestBody CustomComponentInfo customComponentInfo) throws IOException, LcdpException {
        return this.customComponentService.getFile(customComponentInfo.getCover(), customComponentInfo.getPageType(), customComponentInfo.getName());
    }

    @GetMapping(value={"/init"})
    public ApiResponse<Void> init() throws IOException, LcdpException {
        this.customComponentService.init();
        return ApiResponse.success();
    }
}

