/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.no.code.constant.DMSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.GAUSSSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.HIGHGOSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.KingBaseSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OSCARSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OracleTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.PGSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.mysql.cj.MysqlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component(value="JXDNImage")
public class JXDNImage
extends JXDNWidgetDefault {
    private Widget widget;
    private FormSchema form;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.TEXT.name());
            this.put("ORACLE", OracleTypeEnum.VARCHAR2.getTypeName());
            this.put("HIGHGO", HIGHGOSqlTypeEnum.TEXT.getTypeName());
            this.put("DM", DMSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.KINGBASE.name(), KingBaseSqlTypeEnum.CLOB.getTypeName());
            this.put(DbType.OSCAR.name(), OSCARSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.POSTGRE_SQL.name(), PGSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.GAUSS.name(), GAUSSSqlTypeEnum.TEXT.getTypeName());
        }
    };
    private Map<String, String> labelDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.TEXT.name());
            this.put("ORACLE", OracleTypeEnum.VARCHAR2.getTypeName());
            this.put("HIGHGO", HIGHGOSqlTypeEnum.TEXT.getTypeName());
            this.put("DM", DMSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.KINGBASE.name(), KingBaseSqlTypeEnum.CLOB.getTypeName());
            this.put(DbType.OSCAR.name(), OSCARSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.POSTGRE_SQL.name(), PGSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.GAUSS.name(), GAUSSSqlTypeEnum.TEXT.getTypeName());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        DataModelFieldBase.Builder field = new DataModelFieldBase.Builder().withId(name).withName(name).withComment(title).withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.labelDbType.get(dbType));
        if (HussarUtils.equals((Object)this.labelDbType.get(dbType), (Object)OracleTypeEnum.VARCHAR2.getTypeName())) {
            field.withDataLength(2000);
        }
        fields.add(field.build());
        fields.add(this.getLabelField(dbType, widget));
        return fields;
    }

    @Override
    public List<ModelFieldDto> withEngineField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<ModelFieldDto> fields = new ArrayList<ModelFieldDto>();
        ModelFieldDto fieldDto = new ModelFieldDto();
        fieldDto.setFieldName(name);
        fieldDto.setFieldComment(title);
        fieldDto.setDefaultValue(null);
        fieldDto.setDataType(this.labelDbType.get(dbType));
        if (HussarUtils.equals((Object)this.labelDbType.get(dbType), (Object)OracleTypeEnum.VARCHAR2.getTypeName())) {
            fieldDto.setDataLength(Long.valueOf(2000L));
        }
        Optional engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)ComponentData.DataTypeEnum.STRING.getValue());
        fieldDto.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDto.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDto.setNeedChangeIsRequired(false);
        fieldDto.setPurpose(widget.getUsage());
        fieldDto.setRequired("0");
        fields.add(fieldDto);
        ModelFieldDto fieldDtoLabel = new ModelFieldDto();
        fieldDtoLabel.setFieldName(name + "_label");
        fieldDtoLabel.setFieldComment(title + "-\u663e\u793a\u503c");
        fieldDtoLabel.setDefaultValue(null);
        fieldDtoLabel.setDataType(this.labelDbType.get(dbType));
        if (HussarUtils.equals((Object)this.labelDbType.get(dbType), (Object)OracleTypeEnum.VARCHAR2.getTypeName())) {
            fieldDtoLabel.setDataLength(Long.valueOf(2000L));
        }
        fieldDtoLabel.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDtoLabel.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDtoLabel.setNeedChangeIsRequired(false);
        fieldDtoLabel.setPurpose(widget.getUsage());
        fieldDtoLabel.setRequired("0");
        fields.add(fieldDtoLabel);
        return fields;
    }

    @Override
    public DataModelFieldBase getLabelField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = widget.getTitle();
        DataModelFieldBase.Builder fieldLabel = new DataModelFieldBase.Builder().withId(name + "_label").withName(name + "_label").withComment(title + "-\u663e\u793a\u503c").withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.labelDbType.get(dbType));
        if (HussarUtils.equals((Object)this.labelDbType.get(dbType), (Object)OracleTypeEnum.VARCHAR2.getTypeName())) {
            fieldLabel.withDataLength(2000);
        }
        return fieldLabel.build();
    }

    public String parseFileId(String fieldName, Object data) {
        if (HussarUtils.isEmpty((Object)data)) {
            return "";
        }
        ArrayList<String> matchStr = new ArrayList<String>();
        JSONArray formData = JSONObject.parseArray((String)JSONObject.toJSONString((Object)data));
        for (Object formDatum : formData) {
            JSONObject form = JSONObject.parseObject((String)JSONObject.toJSONString(formDatum));
            Object val = form.get((Object)fieldName);
            if (HussarUtils.isEmpty((Object)val)) continue;
            matchStr.add(String.valueOf(val));
        }
        return String.join((CharSequence)",", matchStr);
    }
}

