/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.model.canvas;

import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseForm;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.event.NoCodeEvent;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.factory.PageBuilderFactory;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(value="FormCanvasSchema")
public class FormCanvasSchema
extends BaseForm {
    private int version;
    private String isDetails;
    private String namespace;
    private Map<String, Object> props;
    private List<Widget> widgets;
    private List<Map<String, Object>> references;
    private List<NoCodeEvent> events;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getIsDetails() {
        List<Widget> widgetList = this.getWidgets();
        this.isDetails = this.judgeChild(widgetList) ? "1" : "0";
        return this.isDetails;
    }

    public boolean judgeChild(List<Widget> widgetList) {
        boolean hasChild = false;
        if (HussarUtils.isNotEmpty(widgetList)) {
            for (Widget widget : widgetList) {
                List<Widget> children;
                if (WidgetTool.isChildTableType(widget.getType())) {
                    return true;
                }
                if (!WidgetType.GROUP.getType().equals(widget.getType()) && !WidgetType.JXDNTabs.getType().equals(widget.getType()) && !WidgetType.JXDNTab.getType().equals(widget.getType()) && !WidgetType.JXDNContainer.getType().equals(widget.getType()) || !(hasChild = this.judgeChild(children = widget.getChildren()))) continue;
                break;
            }
        }
        return hasChild;
    }

    public void setIsDetails(String isDetails) {
        this.isDetails = isDetails;
    }

    public Map<String, Object> getProps() {
        return this.props;
    }

    public void setProps(Map<String, Object> props) {
        this.props = props;
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public void setWidgets(List<Widget> widgets) {
        this.widgets = widgets;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public List<Map<String, Object>> getReferences() {
        return this.references;
    }

    public void setReferences(List<Map<String, Object>> references) {
        this.references = references;
    }

    public List<NoCodeEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<NoCodeEvent> events) {
        this.events = events;
    }

    public List<Widget> widgetsWithSys() {
        List<Widget> flatWidgets = this.widgets();
        flatWidgets.addAll(this.systemWidgets());
        return flatWidgets;
    }

    public List<Widget> widgetsWithChildren() {
        ArrayList<Widget> flatWidgets = new ArrayList<Widget>();
        List<Widget> widgetList = this.getWidgets();
        if (HussarUtils.isEmpty(widgetList)) {
            return new ArrayList<Widget>();
        }
        this.flatWithChildren(flatWidgets, widgetList);
        return flatWidgets;
    }

    public List<Widget> widgetsContainChildren() {
        ArrayList<Widget> flatWidgets = new ArrayList<Widget>();
        List<Widget> widgetList = this.getWidgets();
        if (HussarUtils.isEmpty(widgetList)) {
            return new ArrayList<Widget>();
        }
        this.flatContainChildren(flatWidgets, widgetList);
        return flatWidgets;
    }

    public List<Widget> childTables() {
        ArrayList<Widget> children = new ArrayList<Widget>();
        List<Widget> widgetList = this.getWidgets();
        if (HussarUtils.isEmpty(widgetList)) {
            return children;
        }
        this.flatButChildren(children, widgetList);
        return children;
    }

    public List<Widget> widgets() {
        ArrayList<Widget> flatWidgets = new ArrayList<Widget>();
        List<Widget> widgetList = this.getWidgets();
        if (HussarUtils.isEmpty(widgetList)) {
            return new ArrayList<Widget>();
        }
        this.flatButNotChildren(flatWidgets, widgetList);
        return flatWidgets;
    }

    public List<Widget> systemWidgets() {
        return PageBuilderFactory.getSystemWidgets();
    }

    private void flatButNotChildren(List<Widget> flatWidgets, List<Widget> widgets) {
        for (Widget widget : widgets) {
            if ("1".equals(this.getIsDetails()) && (WidgetType.CHILDREN_TABLE.getType().equals(widget.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType()))) continue;
            if (widget.getIsContainer() && HussarUtils.isNotEmpty(widget.getChildren())) {
                this.flatButNotChildren(flatWidgets, widget.getChildren());
            }
            if (widget.getIsContainer() || !widget.getIsRealField()) continue;
            flatWidgets.add(widget);
        }
    }

    private void flatWithChildren(List<Widget> flatWidgets, List<Widget> widgets) {
        for (Widget widget : widgets) {
            if ((WidgetType.GROUP.getType().equals(widget.getType()) || WidgetType.JXDNTabs.getType().equals(widget.getType()) || WidgetType.JXDNTab.getType().equals(widget.getType()) || WidgetType.JXDNContainer.getType().equals(widget.getType())) && HussarUtils.isNotEmpty(widget.getChildren())) {
                this.flatButNotChildren(flatWidgets, widget.getChildren());
            }
            if (!HussarUtils.isNotEmpty((Object)widget.getDataType())) continue;
            flatWidgets.add(widget);
        }
    }

    private void flatContainChildren(List<Widget> flatWidgets, List<Widget> widgets) {
        for (Widget widget : widgets) {
            if ((WidgetType.GROUP.getType().equals(widget.getType()) || WidgetType.JXDNTabs.getType().equals(widget.getType()) || WidgetType.JXDNTab.getType().equals(widget.getType()) || WidgetType.JXDNContainer.getType().equals(widget.getType())) && HussarUtils.isNotEmpty(widget.getChildren())) {
                this.flatContainChildren(flatWidgets, widget.getChildren());
            }
            if (!HussarUtils.isNotEmpty((Object)widget.getDataType())) continue;
            flatWidgets.add(widget);
        }
    }

    private void flatButChildren(List<Widget> children, List<Widget> widgets) {
        for (Widget widget : widgets) {
            if (WidgetType.GROUP.getType().equals(widget.getType()) || WidgetType.JXDNTabs.getType().equals(widget.getType()) || WidgetType.JXDNTab.getType().equals(widget.getType()) || WidgetType.JXDNContainer.getType().equals(widget.getType())) {
                this.flatButChildren(children, widget.getChildren());
            }
            if (!WidgetType.CHILDREN_TABLE.getType().equals(widget.getType()) && !WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType())) continue;
            List<Widget> realWidgets = WidgetTool.flatButNotChildren(new ArrayList<Widget>(), widget.getChildren());
            ArrayList<Widget> sysWidgets = new ArrayList<Widget>();
            for (Widget widget1 : this.systemWidgets()) {
                widget1.setParentKey(widget.getName());
                widget1.setIsInChild(true);
                sysWidgets.add(widget1);
            }
            realWidgets.addAll(sysWidgets);
            ArrayList<Widget> grandWidget = new ArrayList<Widget>();
            this.flatButChildren(grandWidget, widget.getChildren());
            if (HussarUtils.isNotEmpty(grandWidget)) {
                for (Widget widget1 : grandWidget) {
                    if (!WidgetType.CHILDREN_TABLE.getType().equals(widget1.getType())) continue;
                    realWidgets.add(widget1);
                }
            }
            widget.getChildren().clear();
            for (Widget childWidget : realWidgets) {
                if (widget.getChildren().contains(childWidget) || childWidget.getName().equals("title")) continue;
                widget.getChildren().add(childWidget);
            }
            children.add(widget);
        }
    }
}

