/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.mongo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnMongo;
import com.jxdinfo.hussar.formdesign.no.code.util.MongoCommon;
import com.mongodb.BasicDBObject;
import javax.annotation.Resource;
import org.bson.Document;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={NoCodeConditionOnMongo.class})
public class ViewSchemaMongoImpl
implements ViewSchemaService {
    @Resource
    private CanvasSchemaService canvasSchemaService;

    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(FormViewSchema formViewSchema) {
        MongoTemplate template = MongoCommon.getMongoTemplate();
        formViewSchema.setAppId(AppContextUtil.getAppId());
        String mongoId = MongoCommon.getMongoId(formViewSchema.getFormId());
        formViewSchema.setMongoId(mongoId);
        template.getConverter().write((Object)formViewSchema, (Object)new BasicDBObject());
        Update update = Update.fromDocument((Document)Document.parse((String)JSON.toJSONString((Object)formViewSchema, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect})), (String[])new String[0]);
        template.upsert(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)mongoId)), (UpdateDefinition)update, FormViewSchema.class);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<FormViewSchema> get(String formId) {
        MongoTemplate template = MongoCommon.getMongoTemplate();
        String mongoId = MongoCommon.getMongoId(formId);
        return FormDesignResponse.success((Object)template.findById((Object)mongoId, FormViewSchema.class));
    }

    @Override
    public FormDesignResponse<FormViewSchema> get(SysForm form) {
        return this.get(Long.toString(form.getId()));
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId) {
        MongoTemplate template = MongoCommon.getMongoTemplate();
        String mongoId = MongoCommon.getMongoId(formId);
        template.remove((Object)Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)mongoId)));
        return FormDesignResponse.success((Object)true);
    }
}

