/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.db;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.no.code.business.service.SysMiddleFileStorageService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ReferenceService;
import com.jxdinfo.hussar.formdesign.no.code.model.ResourceReference;
import com.jxdinfo.hussar.formdesign.no.code.model.SysMiddleFileStorage;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnDB;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={NoCodeConditionOnDB.class})
@ComponentScan(basePackages={"com.jxdinfo.hussar.formdesign.no.code.cured"})
public class ReferenceServiceDBImpl
implements ReferenceService {
    @Resource
    private SysMiddleFileStorageService sysMiddleFileStorageService;

    @Override
    public FormDesignResponse<Boolean> write(List<ResourceReference> references) throws JsonProcessingException {
        Wrapper wrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FILE_TYPE", (Object)"4")).eq((Object)"DEL_FLAG", (Object)"0");
        this.sysMiddleFileStorageService.remove(wrapper);
        for (ResourceReference resourceReference : references) {
            SysMiddleFileStorage sysMiddleFileStorage = new SysMiddleFileStorage();
            sysMiddleFileStorage.setFileType("4");
            sysMiddleFileStorage.setMiddleFileInfo(JSON.toJSONString((Object)resourceReference));
            sysMiddleFileStorage.setDelFlag("0");
            this.sysMiddleFileStorageService.save((Object)sysMiddleFileStorage);
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<List<ResourceReference>> get() {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>();
        Wrapper wrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FILE_TYPE", (Object)"4")).eq((Object)"DEL_FLAG", (Object)"0");
        List sysMiddleFileStorages = this.sysMiddleFileStorageService.list(wrapper);
        if (sysMiddleFileStorages.size() > 0) {
            for (SysMiddleFileStorage sysMiddleFileStorage : sysMiddleFileStorages) {
                ResourceReference resourceReference = (ResourceReference)JSON.parseObject((String)sysMiddleFileStorage.getMiddleFileInfo(), ResourceReference.class);
                references.add(resourceReference);
            }
        }
        return FormDesignResponse.success(references, (String)"");
    }
}

