/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.widget;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.no.code.constant.DMSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.KingBaseSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.OSCARSqlTypeEnum;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleParam;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.widget.JXDNWidgetDefault;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.region.vo.RegionVo;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.mysql.cj.MysqlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import oracle.jdbc.OracleType;
import org.springframework.stereotype.Component;

@Component(value="JXDNSecurityLevel")
public class JXDNSecurityLevel
extends JXDNWidgetDefault {
    private Widget widget;
    private FormSchema form;
    private Map<String, String> fieldDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.INT.name());
            this.put("ORACLE", OracleType.NUMBER.name());
            this.put("DM", DMSqlTypeEnum.INT.getTypeName());
            this.put(DbType.KINGBASE.name(), KingBaseSqlTypeEnum.INTEGER.getTypeName());
            this.put(DbType.OSCAR.name(), OSCARSqlTypeEnum.INT.getTypeName());
        }
    };
    private Map<String, String> fieldLabelDbType = new HashMap<String, String>(){
        {
            this.put("MYSQL", MysqlType.TEXT.name());
            this.put("ORACLE", OracleType.CLOB.name());
            this.put("DM", DMSqlTypeEnum.TEXT.getTypeName());
            this.put(DbType.KINGBASE.name(), KingBaseSqlTypeEnum.CLOB.getTypeName());
            this.put(DbType.OSCAR.name(), OSCARSqlTypeEnum.TEXT.getTypeName());
        }
    };

    @Override
    public void init(Widget widget, FormSchema form) {
        this.widget = widget;
        this.form = form;
    }

    @Override
    public List<DataModelFieldBase> withField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<DataModelFieldBase> fields = new ArrayList<DataModelFieldBase>();
        fields.add(new DataModelFieldBase.Builder().withId(name).withName(name).withComment(title).withDataType(ComponentData.DataTypeEnum.INTEGER.getValue()).withSourceDataType(this.fieldDbType.get(dbType)).withDataLength(16).build());
        fields.add(this.getLabelField(dbType, widget));
        return fields;
    }

    @Override
    public List<ModelFieldDto> withEngineField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = WidgetTool.concatTitle(widget.getTitle());
        ArrayList<ModelFieldDto> fields = new ArrayList<ModelFieldDto>();
        ModelFieldDto fieldDto = new ModelFieldDto();
        fieldDto.setFieldName(name);
        fieldDto.setFieldComment(title);
        fieldDto.setDefaultValue(null);
        fieldDto.setDataLength(Long.valueOf(18L));
        fieldDto.setDataType(this.fieldDbType.get(dbType));
        Optional engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)ComponentData.DataTypeEnum.INTEGER.getValue());
        fieldDto.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
        fieldDto.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        fieldDto.setNeedChangeIsRequired(false);
        fieldDto.setPurpose(widget.getUsage());
        fieldDto.setRequired("0");
        fields.add(fieldDto);
        ModelFieldDto fieldDtoLabel = new ModelFieldDto();
        fieldDtoLabel.setFieldName(name + "_label");
        fieldDtoLabel.setFieldComment(title + "-\u663e\u793a\u503c");
        fieldDtoLabel.setDefaultValue(null);
        fieldDtoLabel.setDataType(this.fieldLabelDbType.get(dbType));
        Optional engineLabelColumnType = EngineColumnTypeUtil.getEngineColumnType((String)ComponentData.DataTypeEnum.STRING.getValue());
        fieldDtoLabel.setJdbcType(((EngineColumnType)engineLabelColumnType.get()).getJdbcType().getName());
        fieldDtoLabel.setJavaType(((EngineColumnType)engineLabelColumnType.get()).getJavaType());
        fieldDtoLabel.setNeedChangeIsRequired(false);
        fieldDtoLabel.setPurpose(null);
        fieldDtoLabel.setRequired("0");
        fields.add(fieldDtoLabel);
        return fields;
    }

    @Override
    public DataModelFieldBase getLabelField(String dbType, Widget widget) {
        String name = widget.getName();
        String title = widget.getTitle();
        return new DataModelFieldBase.Builder().withId(name + "_label").withName(name + "_label").withComment(title + "-\u663e\u793a\u503c").withDataType(ComponentData.DataTypeEnum.STRING.getValue()).withSourceDataType(this.fieldLabelDbType.get(dbType)).build();
    }

    @Override
    public void wrapTitle(TitleSchema title, TitleParam currentParam) {
        currentParam.setWidgetTitle(this.widget.getTitle());
        currentParam.setWidgetType(this.widget.getType());
        currentParam.putDetail("derived", String.format("%s%s", this.widget.getName(), "_label"));
    }

    @Override
    public Object getModelByWidgetType(String name, Map<String, SysUsers> mapUserNameSysUsers, Map<String, OrganizationBo> mapOrganNameSysOrgans, Map<Long, List<RegionVo>> parentIdRegionVoMap, Integer addressLevel) {
        JSONObject userObject = new JSONObject();
        if (HussarUtils.isEmpty((Object)name)) {
            userObject.put("label", (Object)"");
            userObject.put("value", (Object)"");
        } else {
            userObject.put("label", (Object)name);
            userObject.put("value", (Object)name);
        }
        return userObject;
    }
}

