/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.alibaba.fastjson.JSONPath;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.staff.StaffScope;
import com.jxdinfo.hussar.formdesign.no.code.business.service.StaffScopeService;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.StaffScopeScemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.StaffScopeCopy;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.StaffScopeCopyDTO;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.staff.StaffScopeHistory;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class StaffScopeServiceImpl
implements StaffScopeService {
    @Resource
    private StaffScopeScemaService staffScopeScemaService;
    @Resource
    private CanvasSchemaService canvasSchemaService;

    @Override
    public FormDesignResponse<Boolean> saveStaff(StaffScope staffScope) throws JsonProcessingException {
        return this.staffScopeScemaService.saveOrUpdate(staffScope);
    }

    @Override
    public FormDesignResponse<StaffScope> getStaffScope(String formId, String widgetName) {
        return this.staffScopeScemaService.getByName(formId, widgetName);
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId, String widgetName) throws JsonProcessingException {
        return this.staffScopeScemaService.delete(formId, widgetName);
    }

    @Override
    public FormDesignResponse<Boolean> copyBatch(StaffScopeCopyDTO staffScopeCop) throws JsonProcessingException {
        for (StaffScopeCopy scopeCopy : staffScopeCop.getStaffScopeCopy()) {
            StaffScope staffScope = (StaffScope)this.staffScopeScemaService.getByName(staffScopeCop.getFormId(), scopeCopy.getWidgetName()).getData();
            if (HussarUtils.isNotEmpty((Object)staffScope)) {
                StaffScope newScope = new StaffScope();
                HussarUtils.copy((Object)staffScope, (Object)newScope);
                newScope.setWidgetName(scopeCopy.getWidgetNames());
                this.staffScopeScemaService.saveOrUpdate(newScope);
            }
            if (!HussarUtils.isNotEmpty((Object)scopeCopy.getStepKey())) continue;
            StaffScope scopeHistory = (StaffScope)this.getStaffScopeHistory(staffScopeCop.getFormId(), scopeCopy.getWidgetName(), scopeCopy.getStepKey()).getData();
            scopeHistory.setWidgetName(scopeCopy.getWidgetNames());
            StaffScopeHistory newScopeHistory = new StaffScopeHistory();
            newScopeHistory.setFormId(staffScopeCop.getFormId());
            newScopeHistory.setWidgetName(scopeCopy.getWidgetNames());
            newScopeHistory.setStepKey(scopeCopy.getStepKey());
            newScopeHistory.setContent(scopeHistory);
            this.staffScopeScemaService.saveOrUpdateHistory(newScopeHistory);
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<String> saveStaffHistory(StaffScope staffScope) throws JsonProcessingException {
        StaffScopeHistory staffScopeHistory = new StaffScopeHistory();
        BeanUtil.copyProperties((Object)staffScope, (Object)staffScopeHistory);
        staffScopeHistory.setStepKey(IdUtil.randomUUID());
        staffScopeHistory.setContent(staffScope);
        return this.staffScopeScemaService.saveOrUpdateHistory(staffScopeHistory);
    }

    @Override
    public FormDesignResponse<StaffScope> getStaffScopeHistory(String formId, String widgetName, String stepKey) {
        FormDesignResponse<StaffScopeHistory> response = this.staffScopeScemaService.getHistoryByName(formId, widgetName, stepKey);
        if (HussarUtils.isEmpty((Object)response.getData())) {
            return FormDesignResponse.success(null);
        }
        return FormDesignResponse.success((Object)((StaffScopeHistory)response.getData()).getContent());
    }

    @Override
    public FormDesignResponse<Boolean> deleteHistory(String formId) throws JsonProcessingException {
        FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)this.canvasSchemaService.get(formId).getData());
        if (canvasSchema == null) {
            return FormDesignResponse.success((Object)true);
        }
        for (Widget widget : canvasSchema.widgets()) {
            Optional<String> value = JsonParser.value(widget, "$.props.rangeId", String.class);
            if (!value.isPresent()) continue;
            JSONPath.set((Object)widget, (String)"$.props.rangeId", (Object)"");
        }
        if (HussarUtils.isNotEmpty(canvasSchema.childTables())) {
            for (Widget childWidget : canvasSchema.childTables()) {
                List<Widget> children = childWidget.getChildren();
                Optional<String> value = JsonParser.value(children, "$.props.rangeId", String.class);
                if (!value.isPresent()) continue;
                JSONPath.set(children, (String)"$.props.rangeId", (Object)"");
            }
        }
        this.canvasSchemaService.saveOrUpdate(canvasSchema);
        return this.staffScopeScemaService.deleteScopeHistory(formId);
    }
}

