/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.controller;

import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.eai.sysapi.api.datapack.dto.EaiDataPacketMarketApp;
import com.jxdinfo.hussar.eai.sysapi.api.datapack.dto.EaiMarketDataPacket;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppTreeExtendVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.BestMatchField;
import com.jxdinfo.hussar.formdesign.application.form.vo.DataPacketMarketInfoVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.FieldBriefVO;
import com.jxdinfo.hussar.formdesign.application.form.vo.FieldDetailVO;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormFieldVO;
import com.jxdinfo.hussar.formdesign.application.form.vo.GroupShowFormField;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FieldDataSourceService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="FieldDataSourceControllerNoCode")
@RequestMapping(value={"/formdesign/dataSource"})
public class FieldDataSourceController {
    private static final Logger logger = LoggerFactory.getLogger(FieldDataSourceController.class);
    @Resource
    private FieldDataSourceService fieldDataSourceService;

    @GetMapping(value={"/list"})
    public FormDesignResponse<List<AppTreeExtendVo>> dataList(@RequestParam String type, @RequestParam(required=false) String key) {
        return this.fieldDataSourceService.dataList(type, key);
    }

    @GetMapping(value={"/detail"})
    public FormDesignResponse<FieldDetailVO> sourceDetail(@RequestParam String type, @RequestParam String appId, @RequestParam String formId, @RequestParam(required=false) String appCode, @RequestParam(required=false) String apiCode, @RequestParam(required=false) String packetCode) throws IOException, LcdpException {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        return this.fieldDataSourceService.sourceDetail(type, appId, formId, appCode, apiCode, packetCode);
    }

    @GetMapping(value={"/app_list"})
    public FormDesignResponse<List<SysAppGroupVo>> appList(@RequestParam String type) {
        return this.fieldDataSourceService.appList(type);
    }

    @GetMapping(value={"/form_field_group"})
    public FormDesignResponse<GroupShowFormField> getFormFieldWithGroup(@RequestParam String appId, @RequestParam(required=false) String widgetType) {
        return this.fieldDataSourceService.getFormFieldWithGroup(appId, widgetType);
    }

    @GetMapping(value={"/form_field_group_lazy"})
    public FormDesignResponse<GroupShowFormField> getFormFieldWithGroupLazy(@RequestParam String appId, @RequestParam(required=false) String groupId, @RequestParam(required=false) String formId, @RequestParam(required=false) String widgetType) {
        return this.fieldDataSourceService.getFormFieldWithGroupLazy(appId, groupId, formId, widgetType);
    }

    @GetMapping(value={"/form_field"})
    public FormDesignResponse<List<FormFieldVO>> getFormField(@RequestParam String appId) {
        return this.fieldDataSourceService.getFormField(appId);
    }

    @GetMapping(value={"/api_field"})
    public FormDesignResponse<List<FormFieldVO>> getApiField(@RequestParam String appId) {
        return this.fieldDataSourceService.getApiField(appId);
    }

    @GetMapping(value={"/field_brief"})
    public FormDesignResponse<FieldBriefVO> getFieldBrief(@RequestParam String type, @RequestParam String appId, @RequestParam String formId, @RequestParam String fieldName, @RequestParam(required=false) String packetCode) {
        return this.fieldDataSourceService.getFieldBrief(type, appId, formId, fieldName, packetCode);
    }

    @GetMapping(value={"/app_details"})
    public FormDesignResponse<SysApplication> appDetails(@RequestParam String type, @RequestParam String appId) {
        return this.fieldDataSourceService.appDetails(type, appId);
    }

    @GetMapping(value={"/field_recommend"})
    public FormDesignResponse<BestMatchField> fieldRecommend(@RequestParam Long appId, @RequestParam Long formId, @RequestParam String fieldName, @RequestParam String fieldTitle, @RequestParam String fieldType) {
        return this.fieldDataSourceService.fieldRecommend(appId, formId, fieldName, fieldTitle, fieldType);
    }

    @GetMapping(value={"/isOpenEaiService"})
    @ApiOperation(value="eai\u5916\u90e8\u5e94\u7528\u670d\u52a1\u662f\u5426\u5f00\u542f", notes="eai\u5916\u90e8\u5e94\u7528\u670d\u52a1\u662f\u5426\u5f00\u542f")
    public FormDesignResponse<Boolean> isOpenEaiService() {
        return this.fieldDataSourceService.isOpenEaiService();
    }

    @GetMapping(value={"/getMarketApps"})
    @ApiOperation(value="\u6839\u636e\u6570\u636e\u5305\u5e94\u7528\u540d\u79f0\u6a21\u7cca\u67e5\u8be2\u6570\u636e\u5305\u5e02\u573a\u5e94\u7528", notes="\u6839\u636e\u6570\u636e\u5305\u5e94\u7528\u540d\u79f0\u6a21\u7cca\u67e5\u8be2\u6570\u636e\u5305\u5e02\u573a\u5e94\u7528")
    public FormDesignResponse<List<EaiDataPacketMarketApp>> getMarketApps(@ApiParam(value="\u6570\u636e\u5305\u5e94\u7528\u540d\u79f0") @RequestParam(required=false) String fipAppName) {
        return this.fieldDataSourceService.getMarketApps(fipAppName);
    }

    @GetMapping(value={"/getDataPacketsByFipAppCode"})
    @ApiOperation(value="\u6839\u636e\u6570\u636e\u5305\u5e94\u7528\u6807\u8bc6\u83b7\u53d6\u6570\u636e\u5305", notes="\u6839\u636e\u6570\u636e\u5305\u5e94\u7528\u6807\u8bc6\u83b7\u53d6\u6570\u636e\u5305")
    public FormDesignResponse<List<EaiMarketDataPacket>> getDataPacketsByFipAppCode(@ApiParam(value="\u6570\u636e\u5305\u5e94\u7528\u6807\u8bc6") @RequestParam String fipAppCode, @ApiParam(value="\u6a21\u7cca\u67e5\u8be2\u6570\u636e\u5305\u540d\u79f0") @RequestParam(required=false) String packetName, @ApiParam(value="\u5e94\u7528id") @RequestParam(required=false) String appId) {
        return this.fieldDataSourceService.getDataPacketsByFipAppCode(fipAppCode, packetName, appId);
    }

    @GetMapping(value={"/getApplyPacketApps"})
    @ApiOperation(value="\u6839\u636e\u5e94\u7528ID\u67e5\u8be2\u5df2\u7533\u8bf7\u6570\u636e\u5305\u5e94\u7528", notes="\u6839\u636e\u5e94\u7528ID\u67e5\u8be2\u5df2\u7533\u8bf7\u6570\u636e\u5305\u5e94\u7528")
    public FormDesignResponse<List<EaiDataPacketMarketApp>> getApplyPacketApps(@ApiParam(value="\u5e94\u7528id") @RequestParam String appId, @ApiParam(value="\u5e94\u7528\u540d\u79f0") @RequestParam(required=false) String fipAppName) {
        return this.fieldDataSourceService.getApplyPacketApps(appId, fipAppName);
    }

    @GetMapping(value={"/getApplyDataPackets"})
    @ApiOperation(value="\u6839\u636e\u5e94\u7528id\u3001\u6570\u636e\u5305\u5e94\u7528\u6807\u8bc6\u67e5\u8be2\u5df2\u7533\u8bf7\u7684\u6570\u636e\u5305", notes="\u6839\u636e\u5e94\u7528id\u3001\u6570\u636e\u5305\u5e94\u7528\u6807\u8bc6\u67e5\u8be2\u5df2\u7533\u8bf7\u7684\u6570\u636e\u5305")
    public FormDesignResponse<List<EaiMarketDataPacket>> getApplyDataPackets(@ApiParam(value="\u5e94\u7528id") @RequestParam String appId, @ApiParam(value="\u6570\u636e\u5305\u5e94\u7528\u6807\u8bc6") @RequestParam(required=false) String fipAppCode, @ApiParam(value="\u6570\u636e\u5305\u540d\u79f0") @RequestParam(required=false) String packetName) {
        return this.fieldDataSourceService.getApplyDataPackets(appId, fipAppCode, packetName);
    }

    @GetMapping(value={"/getDataPacketDetail"})
    @ApiOperation(value="\u6839\u636e\u6570\u636e\u5305\u6807\u8bc6\u67e5\u8be2\u6570\u636e\u5305\u8be6\u60c5", notes="\u6839\u636e\u6570\u636e\u5305\u6807\u8bc6\u67e5\u8be2\u6570\u636e\u5305\u8be6\u60c5")
    public FormDesignResponse<DataPacketMarketInfoVo> getDataPacketDetail(@ApiParam(value="\u6570\u636e\u5305\u6807\u8bc6") @RequestParam String packetCode) {
        return this.fieldDataSourceService.getDataPacketDetail(packetCode);
    }

    @PostMapping(value={"/dataPacketAuthorize"})
    @ApiOperation(value="\u6570\u636e\u5305\u6388\u6743", notes="\u6570\u636e\u5305\u6388\u6743")
    public ApiResponse<Boolean> dataPacketAuthorize(@ApiParam(value="\u6570\u636e\u5305\u6388\u6743\u53c2\u6570") @RequestBody(required=false) Map<String, Object> params) {
        logger.info("\u5076\u53d1\u6027\u95ee\u9898\u6392\u67e5\uff1a\u6570\u636e\u5305\u6388\u6743>>dataPacketAuthorize.params:", params);
        return this.fieldDataSourceService.dataPacketAuthorize(params);
    }
}

