/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.tool;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.WidgetDTO;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.mail.core.collection.CollUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class WidgetTool {
    public static final String CREATE_USER = "createUser_user";
    public static final String CREATE_NAME = "createUserName";
    public static final String UPDATE_USER = "updateUser_user";
    public static final String UPDATE_NAME = "updateUserName";
    public static final String POST = "post";
    public static final String POST_NAME = "postName";
    public static final String DATA_ORGAN = "dataOrgan";
    public static final String STAFF = "staff";
    public static final String PROCESS_KEY = "PROCESS_KEY";
    public static final String PROCESS_STATE = "PROCESS_STATE";
    public static final String PROCESS_NODE = "PROCESS_NODE";
    public static final String PROCESS_INST_ID = "PROCESS_INST_ID";
    public static final String START_TIME = "START_TIME";
    public static final String FINISH_TIME = "FINISH_TIME";
    public static final String TASK_INFO_ID = "TASK_INFO_ID";
    public static final String BUSINESS_ID = "BUSINESS_ID";
    public static final String TASK_ID = "TASK_ID";
    public static final String ASSIGNEE = "ASSIGNEE";
    public static final String TASK_DEF_KEY = "TASK_DEF_KEY";
    public static final String TASK_DEF_NAME = "TASK_DEF_NAME";
    public static final String TASK_STATE = "TASK_STATE";
    public static final String FORM_KEY = "FORM_KEY";
    public static final String FORM_DETAIL_KEY = "FORM_DETAIL_KEY";
    public static final String CREATE_TIME = "CREATE_TIME";
    public static final String END_TIME = "END_TIME";
    private static final String PRIMARY_KEY_TITLE_NAME = "\u6570\u636eid\uff08\u4e0d\u53ef\u66f4\u6539\uff09";

    public static void ofWidgetFields(List<WidgetField> widgetFields, List<Widget> widgets, Predicate<Widget> filter) {
        for (Widget widget : widgets) {
            if (filter.test(widget)) continue;
            WidgetField widgetField = new WidgetField();
            widgetField.setName(widget.getName());
            widgetField.setType(widget.getType());
            widgetField.setTitle(widget.getTitle());
            widgetField.setUsage(widget.getUsage());
            widgetField.setDataType(widget.getDataType());
            widgetField.setIsRealField(widget.getIsRealField());
            widgetField.setReadOnly(widget.isReadOnly());
            widgetField.setProps(widget.getProps());
            widgetField.setParentKey(widget.getParentKey());
            widgetField.setVirtualField(widget.isVirtualField());
            widgetField.setIconClass(widget.getIconClass());
            widgetField.setI18ntitle(widget.getI18ntitle());
            widgetFields.add(widgetField);
            if (!WidgetTool.isChildrenTable(widget)) continue;
            if (HussarUtils.isEmpty((Object)widgetField.getChildren())) {
                widgetField.setChildren(new ArrayList());
            }
            WidgetTool.ofWidgetFields(widgetField.getChildren(), widget.getChildren(), filter);
        }
    }

    public static void ofWidgetDTO(List<WidgetDTO> widgetFields, List<Widget> widgets, Predicate<Widget> filter) {
        for (Widget widget : widgets) {
            if (filter.test(widget)) continue;
            WidgetDTO widgetField = new WidgetDTO();
            widgetField.setName(widget.getName());
            widgetField.setType(widget.getType());
            widgetField.setTitle(widget.getTitle());
            widgetField.setUsage(widget.getUsage());
            widgetField.setDataType(widget.getDataType());
            widgetField.setIsRealField(widget.getIsRealField());
            widgetField.setReadOnly(widget.isReadOnly());
            widgetField.setProps(widget.getProps());
            widgetField.setParentKey(widget.getParentKey());
            widgetFields.add(widgetField);
            if (!WidgetTool.isChildrenTable(widget)) continue;
            if (HussarUtils.isEmpty((Object)widgetField.getChildren())) {
                widgetField.setChildren(new ArrayList());
            }
            WidgetTool.ofWidgetDTO(widgetField.getChildren(), widget.getChildren(), filter);
        }
    }

    public static List<Widget> settingWidgets(List<Widget> widgets, Predicate<Widget> filter) {
        ArrayList<Widget> widgetsCopy = new ArrayList<Widget>();
        CollectionUtils.addAll(widgetsCopy, (Object[])new Object[widgets.size()]);
        Collections.copy(widgetsCopy, widgets);
        widgetsCopy.removeIf(filter);
        return widgetsCopy;
    }

    public static String[] excludeFields() {
        return new String[]{CREATE_USER, UPDATE_USER, POST, DATA_ORGAN, STAFF, POST_NAME};
    }

    public static String[] showFieldsExcludeFields() {
        return new String[]{CREATE_NAME, UPDATE_NAME, POST, DATA_ORGAN, STAFF, POST_NAME, PROCESS_INST_ID, TASK_ID, TASK_DEF_KEY};
    }

    public static Optional<List<Widget>> filterWidgets(List<Widget> widgets, Predicate<Widget> filter) {
        ArrayList widgetsCopy = new ArrayList();
        CollectionUtils.addAll(widgetsCopy, (Object[])new Object[widgets.size()]);
        Collections.copy(widgetsCopy, widgets);
        List collect = widgetsCopy.stream().filter(filter).collect(Collectors.toList());
        if (HussarUtils.isEmpty(collect) && collect.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(collect);
    }

    public static boolean anyMatch(String target, String ... conditions) {
        boolean or = false;
        for (String condition : conditions) {
            or = or || target.equals(condition);
        }
        return or;
    }

    public static boolean noneMatch(String target, String ... conditions) {
        boolean or = false;
        for (String condition : conditions) {
            or = or || target.equals(condition);
        }
        return !or;
    }

    public static boolean allMatch(String target, String ... conditions) {
        boolean and = true;
        for (String condition : conditions) {
            and = and && target.equals(condition);
        }
        return and;
    }

    public static boolean isChildrenTable(Widget widget) {
        return HussarUtils.isNotEmpty(widget.getChildren()) && (WidgetType.CHILDREN_TABLE.getType().equals(widget.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType()));
    }

    public static String concatTitle(String title) {
        if (HussarUtils.isEmpty((Object)title) || title.length() <= 120) {
            return title;
        }
        return title.substring(0, 120);
    }

    public static ApiResponse<Boolean> isSourceExist(String appId, String formId) {
        ISysApplicationExternalService externalService = (ISysApplicationExternalService)SpringContextUtil.getBean(ISysApplicationExternalService.class);
        SysApplicationVo app = externalService.getAppDetailById(Long.valueOf(appId));
        if (HussarUtils.isEmpty((Object)app)) {
            return ApiResponse.fail((int)12021, (Object)false, (String)"\u5e94\u7528\u88ab\u5220\u9664");
        }
        SysForm form = externalService.getFormDetailById(Long.valueOf(formId));
        if (HussarUtils.isEmpty((Object)form)) {
            return ApiResponse.fail((int)12022, (Object)false, (String)"\u8868\u5355\u88ab\u5220\u9664");
        }
        ApiResponse booleanApiResponse = externalService.checkRolePermissions(Long.valueOf(formId));
        if (!((Boolean)booleanApiResponse.getData()).booleanValue()) {
            return ApiResponse.fail((int)12011, (Object)false, (String)"\u65e0\u6743\u9650\u67e5\u770b\u8868\u5355");
        }
        return ApiResponse.success((Object)true);
    }

    public static <T> T invoke(String type, String method, Class<T> clazz, Object ... args) {
        Object invokeRes;
        Object bean = SpringUtil.getBean((String)type);
        if (HussarUtils.isEmpty((Object)bean)) {
            throw new IllegalArgumentException("\u5bf9\u5e94\u7ec4\u4ef6\u5b9e\u4f8b\u4e0d\u5b58\u5728\uff1a" + type);
        }
        Method[] methods = bean.getClass().getDeclaredMethods();
        Optional<Method> mOpt = Arrays.stream(methods).filter(m -> m.getName().equals(method)).findFirst();
        if (!mOpt.isPresent()) {
            throw new IllegalArgumentException("\u5bf9\u5e94\u7ec4\u4ef6\u5b9e\u4f8b\uff1a" + type + "\u7684\u65b9\u6cd5\u4e0d\u5b58\u5728\uff1a" + method);
        }
        try {
            invokeRes = mOpt.get().invoke(bean, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("\u8c03\u7528\u5bf9\u5e94\u7ec4\u4ef6\u5b9e\u4f8b\uff1a" + type + "\u7684\u65b9\u6cd5\u5931\u8d25\uff1a" + method + " \u53c2\u6570\uff1a" + Arrays.toString(args));
        }
        if (HussarUtils.isEmpty((Object)invokeRes)) {
            return null;
        }
        return (T)JSONObject.parseObject((String)JSONObject.toJSONString((Object)invokeRes), clazz);
    }

    public static List<Widget> flatSelect(List<Widget> widgets, String ... types) {
        ArrayList<Widget> result = new ArrayList<Widget>();
        List groups = widgets.stream().filter(s -> HussarUtils.equals((Object)s.getType(), (Object)WidgetType.GROUP.getType())).collect(Collectors.toList());
        List tabs = widgets.stream().filter(s -> HussarUtils.equals((Object)s.getType(), (Object)WidgetType.JXDNTabs.getType())).collect(Collectors.toList());
        List<Widget> area = widgets.stream().filter(s -> HussarUtils.equals((Object)s.getType(), (Object)WidgetType.JXDNContainer.getType())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(groups)) {
            for (Widget widget : groups) {
                for (Widget child : widget.getChildren()) {
                    if (!WidgetTool.anyMatch(child.getType(), types)) continue;
                    result.add(child);
                }
            }
        }
        if (HussarUtils.isNotEmpty(tabs)) {
            for (Widget tab : tabs) {
                for (Widget tabChild : tab.getChildren()) {
                    if (!HussarUtils.isNotEmpty(tabChild.getChildren())) continue;
                    for (Widget child : tabChild.getChildren()) {
                        if (!WidgetTool.anyMatch(child.getType(), types)) continue;
                        result.add(child);
                    }
                }
            }
        }
        if (HussarUtils.isNotEmpty(area)) {
            ArrayList<Widget> flat = new ArrayList<Widget>();
            WidgetTool.flatLayout(flat, area);
            result.addAll(flat.stream().filter(s -> WidgetTool.anyMatch(s.getType(), types)).collect(Collectors.toList()));
        }
        List targets = widgets.stream().filter(s -> WidgetTool.anyMatch(s.getType(), types)).collect(Collectors.toList());
        result.addAll(targets);
        return result;
    }

    public static List<Widget> flatButChildren(List<Widget> children, List<Widget> widgets) {
        if (CollUtil.isEmpty(widgets)) {
            return children;
        }
        for (Widget widget : widgets) {
            if (WidgetType.GROUP.getType().equals(widget.getType()) || WidgetType.JXDNTabs.getType().equals(widget.getType()) || WidgetType.JXDNTab.getType().equals(widget.getType()) || WidgetType.JXDNContainer.getType().equals(widget.getType())) {
                WidgetTool.flatButChildren(children, widget.getChildren());
            }
            if (!WidgetTool.isChildTableType(widget)) continue;
            children.add(widget);
        }
        return children;
    }

    public static boolean isChildTableType(Widget widget) {
        return WidgetType.CHILDREN_TABLE.getType().equals(widget.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType());
    }

    public static boolean isChildTableType(String type) {
        return WidgetType.CHILDREN_TABLE.getType().equals(type) || WidgetType.JXDNChildrenTableAgg.getType().equals(type);
    }

    public static List<Widget> flatButNotChildren(List<Widget> flatWidgets, List<Widget> widgets) {
        for (Widget widget : widgets) {
            if (WidgetTool.isChildTableType(widget)) continue;
            if (widget.getIsContainer() && HussarUtils.isNotEmpty(widget.getChildren())) {
                WidgetTool.flatButNotChildren(flatWidgets, widget.getChildren());
            }
            if (widget.getIsContainer() || !widget.getIsRealField()) continue;
            flatWidgets.add(widget);
        }
        return flatWidgets;
    }

    public static List<Widget> flatAllWidget(List<Widget> originals) {
        Widget tmp;
        ArrayList<Widget> result = new ArrayList<Widget>();
        LinkedList<Widget> buff = new LinkedList<Widget>();
        buff.addAll(originals);
        Widget widget = tmp = buff.isEmpty() ? null : (Widget)buff.pollFirst();
        while (tmp != null) {
            result.add(tmp);
            List<Widget> ws = tmp.getChildren();
            if (CollUtil.isNotEmpty(ws)) {
                buff.addAll(ws);
            }
            if (buff.isEmpty()) {
                tmp = null;
                continue;
            }
            tmp = (Widget)buff.pollFirst();
        }
        return result;
    }

    public static List<Widget> flatAllTableWidget(List<Widget> originals) {
        List<Widget> widgets = WidgetTool.flatAllWidget(originals);
        return widgets.stream().filter(WidgetTool::isChildTableType).collect(Collectors.toList());
    }

    public static Widget genIdWidget(String parentKey) {
        Widget dataIdWidget = new Widget();
        dataIdWidget.setTitle(PRIMARY_KEY_TITLE_NAME);
        dataIdWidget.setName("RECORD_ID");
        dataIdWidget.setType(WidgetType.INPUT.getType());
        dataIdWidget.setDataType("string");
        dataIdWidget.setParentKey(parentKey);
        dataIdWidget.setIsInChild(true);
        return dataIdWidget;
    }

    private static void flatLayout(List<Widget> result, List<Widget> widgets) {
        for (Widget widget : widgets) {
            if (WidgetType.GROUP.getType().equals(widget.getType()) || WidgetType.JXDNTabs.getType().equals(widget.getType()) || WidgetType.JXDNTab.getType().equals(widget.getType()) || WidgetType.JXDNContainer.getType().equals(widget.getType())) {
                WidgetTool.flatLayout(result, widget.getChildren());
                continue;
            }
            result.add(widget);
        }
    }
}

