/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.factory;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.CanvasServiceImpl;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.ViewServiceImpl;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.PageBuilder;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class PageBuilderFactory
implements InitializingBean,
ApplicationContextAware {
    private static final ConcurrentHashMap<String, PageBuilder> STRATEGY = new ConcurrentHashMap();
    private ApplicationContext context;
    private static String defaultViewSchema;
    private static String defaultFlowViewSchema;
    private static String processInfoWidgets;
    private static String processTaskInfoWidgets;
    private static String systemWidgets;
    private static String defaultSettingSchema;
    private static String defaultProcessBpmInternet;
    private static String taskProcessInfo;

    public static PageBuilder strategy(String strategy) {
        if (!STRATEGY.containsKey(strategy)) {
            throw new IllegalArgumentException("\u6a21\u578b\u7b56\u7565\u4e0d\u5b58\u5728\uff1a" + strategy);
        }
        return STRATEGY.get(strategy);
    }

    public void afterPropertiesSet() {
        this.context.getBeansOfType(PageBuilder.class).values().forEach(strategy -> STRATEGY.put(strategy.strategy(), (PageBuilder)strategy));
        defaultViewSchema = ToolUtil.loadResource(ViewServiceImpl.class, (String)"/default_view_schema.json");
        defaultFlowViewSchema = ToolUtil.loadResource(ViewServiceImpl.class, (String)"/default_flow_view_schema.json");
        processInfoWidgets = ToolUtil.loadResource(CanvasServiceImpl.class, (String)"/process_info_widgets.json");
        processTaskInfoWidgets = ToolUtil.loadResource(CanvasServiceImpl.class, (String)"/process_task_info_widgets.json");
        systemWidgets = ToolUtil.loadResource(this.getClass(), (String)"/system_widgets.json");
        defaultSettingSchema = ToolUtil.loadResource(this.getClass(), (String)"/default_setting_schema.json");
        defaultProcessBpmInternet = ToolUtil.loadResource(this.getClass(), (String)"/default_process_bpm_internet.json");
        taskProcessInfo = ToolUtil.loadResource(this.getClass(), (String)"/task/process_info.json");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public static FormViewSchema getDefaultViewSchema() {
        return (FormViewSchema)JSON.parseObject((String)defaultViewSchema, FormViewSchema.class);
    }

    public static FormViewSchema getDefaultFlowViewSchema() {
        return (FormViewSchema)JSON.parseObject((String)defaultFlowViewSchema, FormViewSchema.class);
    }

    public static List<Widget> getProcessInfoWidgets() {
        return JSON.parseArray((String)processInfoWidgets, Widget.class);
    }

    public static List<Widget> getProcessTaskInfoWidgets() {
        return JSON.parseArray((String)processTaskInfoWidgets, Widget.class);
    }

    public static List<Widget> getSystemWidgets() {
        return JSON.parseArray((String)systemWidgets, Widget.class);
    }

    public static FormSettingSchema getDefaultSettingSchema() {
        return (FormSettingSchema)((Object)JSON.parseObject((String)defaultSettingSchema, FormSettingSchema.class));
    }

    public static JSONObject getDefaultProcessBpmInternet() {
        return JSON.parseObject((String)defaultProcessBpmInternet);
    }

    public static String getTaskProcessInfo() {
        return taskProcessInfo;
    }
}

