/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.storage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormIndexMeta;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnOfflineStorage;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.random.RandomUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={NoCodeConditionOnOfflineStorage.class})
public class CanvasSchemaStorageImpl
implements CanvasSchemaService {
    public static final String CANVAS_PATH = "canvas";
    public static final String CANVAS_SUFFIX = ".fd";
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private StorageService storage;
    private static final Logger LOGGER = LoggerFactory.getLogger(CanvasSchemaStorageImpl.class);

    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(FormCanvasSchema schema, String appId) throws JsonProcessingException {
        AppContextUtil.setAppId((String)appId);
        String path = FileUtil.posixPath((String[])new String[]{schema.getId(), CANVAS_PATH, schema.getName() + CANVAS_SUFFIX});
        StorageResult jsonRes = this.storage.uploadByUuid(CategoryEnum.JSON, schema.getId(), path, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)schema).getBytes(StandardCharsets.UTF_8), true);
        FormIndexMeta indexMeta = this.getMeta(schema.getId(), appId);
        if (HussarUtils.isEmpty((Object)indexMeta)) {
            ToolUtil.getLogger(this.getClass()).info("\u4fee\u6539\u6216\u66f4\u65b0\u8868\u5355\u753b\u5e03\uff0c\u8868\u5355\u5143\u6570\u636e\u6ca1\u627e\u5230,appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)schema.getId());
            indexMeta = new FormIndexMeta();
        }
        indexMeta.setId(schema.getId());
        if (HussarUtils.isEmpty((Object)indexMeta.getViewId())) {
            ToolUtil.getLogger(this.getClass()).info("\u4fee\u6539\u6216\u66f4\u65b0\u8868\u5355\u753b\u5e03\uff0c\u8868\u5355\u5143\u6570\u636e\u89c6\u56fe\u4e3a\u7a7a, appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)schema.getId());
            indexMeta.setViewId(RandomUtil.randomString((int)schema.getId().length()));
        }
        if (HussarUtils.isEmpty((Object)indexMeta.getSettingId())) {
            indexMeta.setSettingId(RandomUtil.randomString((int)schema.getId().length()));
        }
        indexMeta.setPath(path + ".meta");
        FormDesignResponse<Boolean> metaRes = this.updateMeta(indexMeta);
        if (jsonRes.isSuccess() && ((Boolean)metaRes.getData()).booleanValue()) {
            String cacheKey = String.format("%s:%s:%s", AppContextUtil.getAppId(), "0", schema.getId());
            LOGGER.info("key%%%:{}", (Object)cacheKey);
            HussarCacheUtil.evict((String)"vfg_no-code_schema", (Object)cacheKey);
            return FormDesignResponse.success((Object)true, (String)"");
        }
        ToolUtil.getLogger(this.getClass()).error("\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> Storage\u4fdd\u5b58\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)schema.getId());
        return FormDesignResponse.fail((Object)false, (String)"\u4fdd\u5b58\u8868\u5355\u753b\u5e03 ==> Storage\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(FormCanvasSchema schema) throws JsonProcessingException {
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(Long.parseLong(schema.getId())));
        if (HussarUtils.isNotEmpty((Object)form)) {
            AppContextUtil.setAppId((String)form.getAppId().toString());
            schema.setAppId(form.getAppId().toString());
        }
        return this.saveOrUpdate(schema, AppContextUtil.getAppId());
    }

    @Override
    public FormDesignResponse<FormCanvasSchema> get(String formId) {
        String appId = AppContextUtil.getAppId();
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(formId));
        if (HussarUtils.isNotEmpty((Object)form)) {
            appId = Long.toString(form.getAppId());
        } else {
            LOGGER.error("\u8868\u5355\u4e0d\u5b58\u5728,appId: {} formId: {}", (Object)appId, (Object)formId);
        }
        String cacheKey = String.format("%s:%s:%s", appId, "0", formId);
        FormCanvasSchema formCanvasSchema = (FormCanvasSchema)((Object)HussarCacheUtil.get((String)"vfg_no-code_schema", (Object)cacheKey, FormCanvasSchema.class));
        if (HussarUtils.isNotEmpty((Object)((Object)formCanvasSchema))) {
            if (HussarUtils.isNotEmpty((Object)form)) {
                formCanvasSchema.setI18nKeys(form.getI18nKeys());
                formCanvasSchema.setTitle(form.getFormName());
            }
            return FormDesignResponse.success((Object)((Object)formCanvasSchema), (String)"");
        }
        AppContextUtil.setAppId((String)appId);
        StorageResult storageResult = this.storage.downloadByUuid(CategoryEnum.JSON, formId);
        if (storageResult.isSuccess()) {
            FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)JSON.parseObject((byte[])((byte[])storageResult.getData()), FormCanvasSchema.class, (Feature[])new Feature[0]));
            try {
                HussarCacheUtil.put((String)"vfg_no-code_schema", (Object)cacheKey, (Object)((Object)canvasSchema));
                if (HussarUtils.isNotEmpty((Object)form) && HussarUtils.isNotEmpty((Object)((Object)canvasSchema))) {
                    canvasSchema.setI18nKeys(form.getI18nKeys());
                    canvasSchema.setTitle(form.getFormName());
                }
            }
            catch (Exception e) {
                ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u753b\u5e03 ==> Redis\u8fde\u63a5\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
            return FormDesignResponse.success((Object)((Object)canvasSchema), (String)"");
        }
        ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u753b\u5e03 ==> Storage\u83b7\u53d6\u5931\u8d25 appId: {} formId: {}", (Object)appId, (Object)formId);
        return FormDesignResponse.fail(null, (String)"\u8868\u5355\u4e0d\u5b58\u5728");
    }

    @Override
    public FormDesignResponse<FormCanvasSchema> get(String formId, SysForm form) {
        String appId = String.valueOf(form.getAppId());
        String cacheKey = String.format("%s:%s:%s", appId, "0", formId);
        FormCanvasSchema formCanvasSchema = (FormCanvasSchema)((Object)HussarCacheUtil.get((String)"vfg_no-code_schema", (Object)cacheKey, FormCanvasSchema.class));
        if (HussarUtils.isNotEmpty((Object)((Object)formCanvasSchema))) {
            formCanvasSchema.setI18nKeys(form.getI18nKeys());
            formCanvasSchema.setTitle(form.getFormName());
            return FormDesignResponse.success((Object)((Object)formCanvasSchema), (String)"");
        }
        AppContextUtil.setAppId((String)appId);
        StorageResult storageResult = this.storage.downloadByUuid(CategoryEnum.JSON, formId);
        if (storageResult.isSuccess()) {
            FormCanvasSchema canvasSchema = (FormCanvasSchema)((Object)JSON.parseObject((byte[])((byte[])storageResult.getData()), FormCanvasSchema.class, (Feature[])new Feature[0]));
            try {
                HussarCacheUtil.put((String)"vfg_no-code_schema", (Object)cacheKey, (Object)((Object)canvasSchema));
                canvasSchema.setI18nKeys(form.getI18nKeys());
                canvasSchema.setTitle(form.getFormName());
            }
            catch (Exception e) {
                ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u753b\u5e03 ==> Redis\u8fde\u63a5\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
            return FormDesignResponse.success((Object)((Object)canvasSchema), (String)"");
        }
        ToolUtil.getLogger(this.getClass()).error("\u83b7\u53d6\u8868\u5355\u753b\u5e03 ==> Storage\u83b7\u53d6\u5931\u8d25 appId: {} formId: {}", (Object)appId, (Object)formId);
        return FormDesignResponse.fail(null, (String)"\u8868\u5355\u4e0d\u5b58\u5728");
    }

    @Override
    public FormIndexMeta getMeta(String formId) {
        ToolUtil.getLogger(this.getClass()).info("formId=========>: {}", (Object)formId);
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(Long.parseLong(formId)));
        if (HussarUtils.isNotEmpty((Object)form)) {
            AppContextUtil.setAppId((String)String.valueOf(form.getAppId()));
        }
        ToolUtil.getLogger(this.getClass()).info("AppContextUtil.getAppId=========>: {},formId=====:{}", (Object)AppContextUtil.getAppId(), (Object)formId);
        StorageResult metaRes = this.storage.downloadByUuid(CategoryEnum.META, formId);
        if (!metaRes.isSuccess()) {
            ToolUtil.getLogger(this.getClass()).info("metaRes\u4e3a\u7a7a===============>");
            return new FormIndexMeta();
        }
        if (HussarUtils.isEmpty((Object)metaRes.getData())) {
            ToolUtil.getLogger(this.getClass()).info("metaResData\u4e3a\u7a7a===============>");
            return new FormIndexMeta();
        }
        return (FormIndexMeta)JSON.parseObject((byte[])((byte[])metaRes.getData()), FormIndexMeta.class, (Feature[])new Feature[0]);
    }

    public FormIndexMeta getMeta(String formId, String appId) {
        ToolUtil.getLogger(this.getClass()).info("formId=========>: {}", (Object)formId);
        ToolUtil.getLogger(this.getClass()).info("AppContextUtil.getAppId=========>: {},formId=====:{}", (Object)AppContextUtil.getAppId(), (Object)formId);
        AppContextUtil.setAppId((String)String.valueOf(appId));
        StorageResult metaRes = this.storage.downloadByUuid(CategoryEnum.META, formId);
        if (!metaRes.isSuccess()) {
            ToolUtil.getLogger(this.getClass()).info("metaRes\u4e3a\u7a7a===============>");
            return new FormIndexMeta();
        }
        if (HussarUtils.isEmpty((Object)metaRes.getData())) {
            ToolUtil.getLogger(this.getClass()).info("metaResData\u4e3a\u7a7a===============>");
            return new FormIndexMeta();
        }
        return (FormIndexMeta)JSON.parseObject((byte[])((byte[])metaRes.getData()), FormIndexMeta.class, (Feature[])new Feature[0]);
    }

    @Override
    public FormDesignResponse<Boolean> updateMeta(FormIndexMeta meta) throws JsonProcessingException {
        StorageResult metaRes = this.storage.uploadByUuid(CategoryEnum.META, meta.getId(), meta.getPath(), new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)meta).getBytes(StandardCharsets.UTF_8), true);
        if (!((Boolean)metaRes.getData()).booleanValue()) {
            return FormDesignResponse.fail((Object)false, (String)"\u66f4\u65b0\u8868\u5355meta\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId) {
        StorageResult jsonRes = this.storage.deleteByUuid(CategoryEnum.JSON, formId, false);
        StorageResult metaRes = this.storage.deleteByUuid(CategoryEnum.META, formId, false);
        if (jsonRes.isSuccess() && metaRes.isSuccess()) {
            return FormDesignResponse.success((Object)true, (String)"");
        }
        ToolUtil.getLogger(this.getClass()).error("\u5220\u9664\u8868\u5355\u753b\u5e03 ==> Storage\u5220\u9664\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
        return FormDesignResponse.fail((Object)false, (String)"\u5220\u9664\u8868\u5355\u753b\u5e03 ==> Storage\u5220\u9664\u5931\u8d25");
    }
}

