/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.storage;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.no.code.cured.ReferenceService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormIndexMeta;
import com.jxdinfo.hussar.formdesign.no.code.model.ResourceReference;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnOfflineStorage;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={NoCodeConditionOnOfflineStorage.class})
public class ReferenceServiceStorageImpl
implements ReferenceService {
    @Resource
    private StorageService storage;
    private final String UUID = "reference";

    @Override
    public FormDesignResponse<Boolean> write(List<ResourceReference> references) throws JsonProcessingException {
        String appId = AppContextUtil.getAppId();
        AppContextUtil.setAppId((String)"reference");
        String path = FileUtil.posixPath((String[])new String[]{"form", "reference.ref"});
        String metaPath = FileUtil.posixPath((String[])new String[]{"form", "reference.ref.meta"});
        this.storage.uploadByUuid(CategoryEnum.JSON, "reference", path, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(references).getBytes(StandardCharsets.UTF_8), false);
        FormIndexMeta indexMeta = new FormIndexMeta();
        indexMeta.setId("reference");
        indexMeta.setPath(path);
        this.storage.uploadByUuid(CategoryEnum.META, "reference", metaPath, new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)indexMeta).getBytes(StandardCharsets.UTF_8), false);
        AppContextUtil.setAppId((String)appId);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<List<ResourceReference>> get() {
        String appId = AppContextUtil.getAppId();
        AppContextUtil.setAppId((String)"reference");
        StorageResult storageResult = this.storage.downloadByUuid(CategoryEnum.JSON, "reference");
        if (storageResult.isSuccess()) {
            List references = JSON.parseArray((String)new String((byte[])storageResult.getData(), StandardCharsets.UTF_8), ResourceReference.class);
            AppContextUtil.setAppId((String)appId);
            return FormDesignResponse.success((Object)references);
        }
        AppContextUtil.setAppId((String)appId);
        return FormDesignResponse.success(null);
    }
}

