/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.cured.mongo;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormIndexMeta;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeConditionOnMongo;
import com.jxdinfo.hussar.formdesign.no.code.util.MongoCommon;
import com.mongodb.BasicDBObject;
import org.bson.Document;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={NoCodeConditionOnMongo.class})
public class CanvasSchemaMongoImpl
implements CanvasSchemaService {
    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(FormCanvasSchema schema, String appId) throws JsonProcessingException {
        MongoTemplate template = MongoCommon.getMongoTemplate();
        BasicDBObject dbObject = new BasicDBObject();
        schema.setAppId(AppContextUtil.getAppId());
        String mongoId = MongoCommon.getMongoId(schema.getId());
        schema.setMongoId(mongoId);
        template.getConverter().write((Object)schema, (Object)dbObject);
        Update update = Update.fromDocument((Document)Document.parse((String)JSON.toJSONString((Object)((Object)schema))), (String[])new String[0]);
        template.upsert(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)mongoId)), update, FormCanvasSchema.class);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> saveOrUpdate(FormCanvasSchema schema) {
        MongoTemplate template = MongoCommon.getMongoTemplate();
        BasicDBObject dbObject = new BasicDBObject();
        schema.setAppId(AppContextUtil.getAppId());
        String mongoId = MongoCommon.getMongoId(schema.getId());
        schema.setMongoId(mongoId);
        template.getConverter().write((Object)schema, (Object)dbObject);
        Update update = Update.fromDocument((Document)Document.parse((String)JSON.toJSONString((Object)((Object)schema))), (String[])new String[0]);
        template.upsert(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)mongoId)), update, FormCanvasSchema.class);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<FormCanvasSchema> get(String formId) {
        MongoTemplate template = MongoCommon.getMongoTemplate();
        String mongoId = MongoCommon.getMongoId(formId);
        return FormDesignResponse.success((Object)template.findById((Object)mongoId, FormCanvasSchema.class), (String)"");
    }

    @Override
    public FormDesignResponse<FormCanvasSchema> get(String formId, SysForm sysForm) {
        MongoTemplate template = MongoCommon.getMongoTemplate();
        String mongoId = MongoCommon.getMongoId(formId);
        return FormDesignResponse.success((Object)template.findById((Object)mongoId, FormCanvasSchema.class), (String)"");
    }

    @Override
    public FormIndexMeta getMeta(String formId) {
        MongoTemplate template = MongoCommon.getMongoTemplate();
        return (FormIndexMeta)template.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)formId)), FormIndexMeta.class);
    }

    @Override
    public FormDesignResponse<Boolean> updateMeta(FormIndexMeta meta) {
        MongoTemplate template = MongoCommon.getMongoTemplate();
        Update update = Update.fromDocument((Document)Document.parse((String)JSON.toJSONString((Object)meta)), (String[])new String[0]);
        template.updateFirst(Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)meta.getId())), update, FormIndexMeta.class);
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> delete(String formId) {
        MongoTemplate template = MongoCommon.getMongoTemplate();
        String mongoId = MongoCommon.getMongoId(formId);
        template.remove((Object)Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)mongoId)));
        return FormDesignResponse.success((Object)true);
    }
}

