/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.util;

import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControl;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class FormCanvasUtil {
    public static void getFieldControl(List<Widget> widgets, List<FieldControl> addOrEdit) {
        ArrayList delControls = new ArrayList();
        CollectionUtils.addAll(delControls, (Object[])new Object[addOrEdit.size()]);
        Collections.copy(delControls, addOrEdit);
        for (Widget widget : widgets) {
            boolean isRepeat = false;
            for (FieldControl control : addOrEdit) {
                if (!control.getField().equals(widget.getName())) continue;
                control.setTitle(widget.getTitle());
                isRepeat = true;
                delControls.remove(control);
                if (!WidgetTool.isChildrenTable(widget)) break;
                if (HussarUtils.isEmpty((Object)control.getChildren())) {
                    control.setChildren(new ArrayList());
                }
                FormCanvasUtil.getFieldControl(widget.getChildren(), control.getChildren());
                break;
            }
            if (isRepeat) continue;
            FieldControl control = new FieldControl();
            control.setField(widget.getName());
            control.setType(widget.getType());
            control.setTitle(widget.getTitle());
            control.setReadOnly(widget.isReadOnly());
            control.setVisible(true);
            control.setWitable(true);
            control.setRequired(false);
            if (WidgetTool.isChildrenTable(widget)) {
                control.setChildren(new ArrayList());
                FormCanvasUtil.getFieldControl(widget.getChildren(), control.getChildren());
            }
            addOrEdit.add(control);
        }
        if (HussarUtils.isNotEmpty(delControls)) {
            addOrEdit.removeAll(delControls);
        }
    }

    public static void sortFieldControl(List<FieldControl> fieldControls, List<String> orders) {
        fieldControls.sort((o1, o2) -> {
            int io1 = orders.indexOf(o1.getField());
            int io2 = orders.indexOf(o2.getField());
            if (io1 == -1 && io2 == -1) {
                return 0;
            }
            if (io1 == -1 || io2 == -1) {
                return io1 == -1 ? 1 : -1;
            }
            return Integer.compare(io1, io2);
        });
    }
}

