/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.no.code.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.service.INoCodeAppDevelopTeamService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.FilterField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.NavLeftTreeOption;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.ShowField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.ShowFieldMulti;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.TableButton;
import com.jxdinfo.hussar.formdesign.no.code.business.dao.CustomViewMapper;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CustomViewService;
import com.jxdinfo.hussar.formdesign.no.code.model.view.CustomView;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class CustomViewServiceImpl
extends HussarServiceImpl<CustomViewMapper, CustomView>
implements CustomViewService {
    @Resource
    private CustomViewMapper customViewMapper;
    @Resource
    private INoCodeAppDevelopTeamService noCodeAppDevelopTeamService;
    @Resource
    private ISysFormService sysFormService;
    private static Logger logger = LoggerFactory.getLogger(CustomViewServiceImpl.class);

    @Override
    public FormDesignResponse<Long> saveViewReturnId(DataView dataView) {
        CustomView customView = this.convertToCustomView(dataView);
        try {
            this.customViewMapper.insert((Object)customView);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u81ea\u5b9a\u4e49\u89c6\u56fe\u5f02\u5e38\uff1a{}\uff0cformId\uff1a{}", (Object)e.getMessage(), (Object)dataView);
            return FormDesignResponse.fail((Object)0L, (String)"\u4fdd\u5b58\u89c6\u56fe\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)customView.getViewId());
    }

    @Override
    public FormDesignResponse<List<DataView>> get(String formId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            user = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser");
        }
        if (HussarUtils.isEmpty((Object)user)) {
            logger.error("\u81ea\u5b9a\u4e49\u89c6\u56fe\u67e5\u8be2\u5931\u8d25\uff0c\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
            return FormDesignResponse.fail(null, (String)"\u65e0\u7528\u6237\u4fe1\u606f");
        }
        Long userId = user.getId();
        String userIdString = HussarUtils.isEmpty((Object)userId) ? "" : "%\\\"" + userId + "\\\"%";
        List appIds = this.noCodeAppDevelopTeamService.selectAppListByCurrentUser();
        SysForm form = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        if (HussarUtils.isEmpty((Object)form)) {
            return FormDesignResponse.fail(null, (String)"\u8868\u5355\u4e0d\u5b58\u5728");
        }
        Boolean isDevelop = HussarUtils.contains(appIds.iterator(), (Object)form.getAppId());
        List<CustomView> customViews = this.customViewMapper.getByUser(Long.valueOf(formId), userIdString, isDevelop);
        if (HussarUtils.isEmpty(customViews)) {
            return FormDesignResponse.success(null, (String)"\u65e0\u81ea\u5b9a\u4e49\u89c6\u56fe");
        }
        ArrayList<DataView> dataViews = new ArrayList<DataView>();
        for (CustomView customView : customViews) {
            DataView view = this.convertToDataView(customView);
            dataViews.add(view);
        }
        return FormDesignResponse.success(dataViews);
    }

    @Override
    public FormDesignResponse<List<DataView>> getAll(String formId) {
        List<CustomView> customViews = this.customViewMapper.getByFormId(Long.valueOf(formId));
        if (HussarUtils.isEmpty(customViews)) {
            return FormDesignResponse.success(null, (String)"\u65e0\u81ea\u5b9a\u4e49\u89c6\u56fe");
        }
        ArrayList<DataView> dataViews = new ArrayList<DataView>();
        for (CustomView customView : customViews) {
            DataView view = this.convertToDataView(customView);
            dataViews.add(view);
        }
        return FormDesignResponse.success(dataViews);
    }

    @Override
    public FormDesignResponse<List<DataView>> getView(String formId, int type) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            user = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser");
        }
        if (HussarUtils.isEmpty((Object)user)) {
            logger.error("\u81ea\u5b9a\u4e49\u89c6\u56fe\u67e5\u8be2\u5931\u8d25\uff0c\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
            return FormDesignResponse.fail(null, (String)"\u65e0\u7528\u6237\u4fe1\u606f");
        }
        Long userId = user.getId();
        List<CustomView> customViews = this.customViewMapper.getView(Long.valueOf(formId), userId + "", type);
        if (HussarUtils.isEmpty(customViews)) {
            return FormDesignResponse.success(null, (String)"\u65e0\u81ea\u5b9a\u4e49\u89c6\u56fe");
        }
        ArrayList<DataView> dataViews = new ArrayList<DataView>();
        for (CustomView customView : customViews) {
            DataView view = this.convertToDataView(customView);
            dataViews.add(view);
        }
        return FormDesignResponse.success(dataViews);
    }

    @Override
    public FormDesignResponse<DataView> getById(Long viewId) {
        CustomView customView = (CustomView)((Object)this.customViewMapper.selectById(viewId));
        try {
            return FormDesignResponse.success((Object)this.convertToDataView(customView));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u81ea\u5b9a\u4e49\u89c6\u56fe\u5f02\u5e38\uff1a{}\uff0cviewId\uff1a{}", (Object)e.getMessage(), (Object)viewId);
            return FormDesignResponse.fail(null, (String)"\u83b7\u53d6\u89c6\u56fe ==> \u83b7\u53d6\u5931\u8d25");
        }
    }

    @Override
    public FormDesignResponse<Boolean> deleteById(String viewId) {
        try {
            this.customViewMapper.deleteById(Long.valueOf(viewId));
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u81ea\u5b9a\u4e49\u89c6\u56fe\u5f02\u5e38\uff1a{}\uff0cviewId\uff1a{}", (Object)e.getMessage(), (Object)viewId);
            return FormDesignResponse.fail((Object)false, (String)"\u5220\u9664\u89c6\u56fe ==> \u5220\u9664\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> update(DataView dataView) {
        if (HussarUtils.isEmpty((Object)dataView.getViewPermission())) {
            Long userId = BaseSecurityUtil.getUser().getId();
            ArrayList<String> authority = new ArrayList<String>();
            authority.add(String.valueOf(userId));
            dataView.setViewPermission(authority);
        }
        CustomView customView = this.convertToCustomView(dataView);
        try {
            this.customViewMapper.updateById((Object)customView);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u81ea\u5b9a\u4e49\u89c6\u56fe\u5f02\u5e38\uff1a{}\uff0cformId\uff1a{}\uff0cviewId{}", new Object[]{e.getMessage(), dataView.getFormId(), dataView.getId()});
            return FormDesignResponse.fail((Object)false, (String)"\u66f4\u65b0\u81ea\u5b9a\u4e49\u89c6\u56fe ==> \u66f4\u65b0\u5931\u8d25");
        }
        return FormDesignResponse.success((Object)true);
    }

    @Override
    public FormDesignResponse<Boolean> updateBatch(String formId, List<DataView> dataViews) {
        if (HussarUtils.isEmpty(dataViews)) {
            return FormDesignResponse.success((Object)true);
        }
        List customViews = dataViews.stream().map(dataView -> {
            CustomView customView = this.convertToCustomView((DataView)dataView);
            customView.setFormId(Long.valueOf(formId));
            return customView;
        }).collect(Collectors.toList());
        boolean saveOrUpdateBatch = this.saveOrUpdateBatch(customViews);
        if (saveOrUpdateBatch) {
            return FormDesignResponse.success((Object)true);
        }
        logger.error("\u6279\u91cf\u66f4\u65b0\u89c6\u56fe\u5931\u8d25\uff0cappId:{}\uff0cformId:{}", (Object)AppContextUtil.getAppId(), (Object)formId);
        return FormDesignResponse.fail((Object)false, (String)"\u6279\u91cf\u66f4\u65b0\u516c\u5171\u89c6\u56fe\u5931\u8d25");
    }

    public CustomView convertToCustomView(DataView dataView) {
        CustomView customView = new CustomView();
        if (HussarUtils.isNotEmpty((Object)dataView.getId())) {
            customView.setViewId(Long.valueOf(dataView.getId()));
        }
        customView.setAppId(Long.valueOf(AppContextUtil.getAppId()));
        customView.setName(dataView.getName());
        customView.setAlias(dataView.getAlias());
        customView.setCategory(dataView.getCategory());
        customView.setViewType(dataView.getViewType());
        customView.setTabType(dataView.getTabType());
        customView.setStyles(JSON.toJSONString((Object)dataView.getStyles()));
        customView.setButtons(JSON.toJSONString((Object)dataView.getButtons()));
        customView.setTools(JSON.toJSONString((Object)dataView.getTools()));
        customView.setFilters(JSON.toJSONString((Object)dataView.getFilters()));
        customView.setOrderBy(JSON.toJSONString((Object)dataView.getOrderBy()));
        customView.setShowFields(JSON.toJSONString((Object)dataView.getShowFields()));
        customView.setShowFieldMulti(JSON.toJSONString((Object)dataView.getShowFieldMulti()));
        customView.setViewPermission(JSON.toJSONString((Object)dataView.getViewPermission()));
        customView.setVisible(String.valueOf(dataView.isVisible()));
        customView.setFormId(dataView.getFormId());
        customView.setI18nKeys(dataView.getI18nKeys());
        customView.setNavLeftTreeOption(JSON.toJSONString((Object)dataView.getNavLeftTreeOption()));
        customView.setFilterFields(JSON.toJSONString((Object)dataView.getFilterFields()));
        customView.setTopFilterFields(JSON.toJSONString((Object)dataView.getTopFilterFields()));
        customView.setCssConfigs(JSON.toJSONString((Object)dataView.getConfigs()));
        customView.setShowCount(dataView.getShowCount());
        return customView;
    }

    private DataView convertToDataView(CustomView customView) {
        DataView view = new DataView();
        view.setId(String.valueOf(customView.getViewId()));
        view.setName(customView.getName());
        view.setAlias(customView.getAlias());
        view.setCategory(customView.getCategory());
        view.setViewType(customView.getViewType());
        view.setTabType(customView.getTabType());
        view.setVisible(HussarUtils.equals((Object)customView.getVisible(), (Object)"true"));
        view.setStyles((Map)JSON.parseObject((String)customView.getStyles(), HashMap.class));
        view.setViewPermission(JSON.parseObject((String)customView.getViewPermission(), Object.class));
        view.setButtons(JSONArray.parseArray((String)customView.getButtons(), TableButton.class));
        view.setTools(JSONArray.parseArray((String)customView.getTools(), TableButton.class));
        view.setFilters(JSONArray.parseArray((String)customView.getFilters(), Filter.class));
        view.setOrderBy(JSONArray.parseArray((String)customView.getOrderBy(), OrderItem.class));
        view.setShowFields(JSONArray.parseArray((String)customView.getShowFields(), ShowField.class));
        view.setShowFieldMulti(JSONArray.parseArray((String)customView.getShowFieldMulti(), ShowFieldMulti.class));
        view.setFormId(customView.getFormId());
        view.setI18nKeys(customView.getI18nKeys());
        view.setNavLeftTreeOption((NavLeftTreeOption)JSON.parseObject((String)customView.getNavLeftTreeOption(), NavLeftTreeOption.class));
        view.setFilterFields(JSONArray.parseArray((String)customView.getFilterFields(), FilterField.class));
        view.setTopFilterFields(JSONArray.parseArray((String)customView.getTopFilterFields(), FilterField.class));
        view.setConfigs((Map)JSONObject.parseObject((String)customView.getCssConfigs()));
        view.setShowCount(customView.getShowCount());
        return view;
    }
}

