/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authorization.extension.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.extend.service.IHussarBaseUserExtendWebService;
import com.jxdinfo.hussar.authorization.permit.dto.AddUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.EditUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.UserActivateDto;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.formdesign.application.authorization.extension.dao.HussarBaseUserExtendMapper;
import com.jxdinfo.hussar.formdesign.application.authorization.extension.service.IHussarBaseUserExtendService;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.nocode.authorization.extension.service.impl.HussarBaseUserExtendApiServiceImpl")
public class HussarBaseUserExtendServiceImpl
implements IHussarBaseUserExtendService {
    @Resource
    private IHussarBaseUserExtendWebService hussarBaseUserExtendService;
    @Autowired
    private HussarBaseUserExtendMapper hussarBaseUserExtendMapper;
    @Autowired
    private IConvertPinyinService convertPinyinService;

    @Override
    public ApiResponse<String> sortUser(List<Long> idList) {
        AssertUtil.isNotEmpty(idList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_PARAM.getMessage()));
        ArrayList<SysUsers> sysUsersList = new ArrayList<SysUsers>();
        for (int i = 0; i < idList.size(); ++i) {
            Long id = idList.get(i);
            SysUsers sysUsers = new SysUsers();
            sysUsers.setId(id);
            sysUsers.setUserOrder(Integer.valueOf(i + 1));
            sysUsersList.add(sysUsers);
        }
        this.hussarBaseUserExtendMapper.updateBatchById(sysUsersList);
        return this.hussarBaseUserExtendService.sortUser(idList);
    }

    @Override
    public ApiResponse<String> deleteUser(String ids) {
        return this.hussarBaseUserExtendService.deleteUser(ids);
    }

    @Override
    public ApiResponse<Long> getMaxOrder() {
        return ApiResponse.success((Object)this.hussarBaseUserExtendMapper.getMaxOrder());
    }

    @Override
    public ApiResponse<Long> addUserBaseInfo(AddUserDto addUserDto) {
        return this.hussarBaseUserExtendService.addUserBaseInfo(addUserDto);
    }

    @Override
    public ApiResponse<Long> editUserBaseInfo(EditUserDto editUserDto) {
        return this.hussarBaseUserExtendService.editUserBaseInfo(editUserDto);
    }

    @Override
    public void saveUsersPost(Map<String, Object> params) {
        if (HussarUtils.isEmpty((Object)params.get("id"))) {
            throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        String s = JSON.toJSONString(params);
        EditUserDto editUserDto = (EditUserDto)JSON.parseObject((String)s, EditUserDto.class);
        this.hussarBaseUserExtendService.saveUsersPost(editUserDto);
    }

    @Override
    public void saveUsersRole(Map<String, Object> params) {
        String s = JSON.toJSONString(params);
        EditUserDto editUserDto = (EditUserDto)JSON.parseObject((String)s, EditUserDto.class);
        this.hussarBaseUserExtendService.saveUsersRole(editUserDto);
    }

    @Override
    public void saveUsersStru(Map<String, Object> params) {
        if (HussarUtils.isEmpty((Object)params.get("id"))) {
            throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        String s = JSON.toJSONString(params);
        EditUserDto editUserDto = (EditUserDto)JSON.parseObject((String)s, EditUserDto.class);
        this.hussarBaseUserExtendService.saveUsersStru(editUserDto);
    }

    @Override
    public ApiResponse<String> saveUsersStaff(Map<String, Object> params) {
        if (HussarUtils.isEmpty((Object)params.get("id")) || HussarUtils.isEmpty((Object)params.get("employeeId"))) {
            throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        String id = params.get("id").toString();
        String employeeId = params.get("employeeId").toString();
        String s = JSON.toJSONString(params);
        EditUserDto editUserDto = (EditUserDto)JSON.parseObject((String)s, EditUserDto.class);
        String userName = (String)this.hussarBaseUserExtendService.saveUsersStaff(editUserDto).getData();
        String userNamePinYinFull = this.convertPinyinService.getNameFullPinyin(userName);
        String userNamePinYinInitial = this.convertPinyinService.getNameInitialsPinyin(userName);
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        queryParam.put("employeeId", employeeId);
        queryParam.put("userName", userName);
        queryParam.put("id", id);
        queryParam.put("userNamePinYinFull", userNamePinYinFull);
        queryParam.put("userNamePinYinInitial", userNamePinYinInitial);
        this.hussarBaseUserExtendMapper.updateUserExtendStaff(queryParam);
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<String> dormancyUserExtend(Long id) {
        LocalDateTime lockTime = Java8DateUtils.currentLocalDateTime();
        String accountStatus = UserStatus.DORMANCY.getCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", String.valueOf(id));
        map.put("accountStatus", accountStatus);
        map.put("lockTime", lockTime);
        this.hussarBaseUserExtendMapper.dormancyUserExtend(map);
        return this.hussarBaseUserExtendService.dormancyUserExtend(id, lockTime);
    }

    @Override
    public ApiResponse<String> activateUserExtend(Long id) {
        String accountStatus = UserStatus.OK.getCode();
        Date lastLoginTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", String.valueOf(id));
        map.put("accountStatus", accountStatus);
        map.put("lastLoginTime", lastLoginTime);
        this.hussarBaseUserExtendMapper.activateUserExtend(map);
        return this.hussarBaseUserExtendService.activateUserExtend(id);
    }

    @Override
    public ApiResponse<String> cancelUserExtend(Long id) {
        String accountStatus = UserStatus.CANCEL.getCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", String.valueOf(id));
        map.put("accountStatus", accountStatus);
        this.hussarBaseUserExtendMapper.CancelUserExtend(map);
        return this.hussarBaseUserExtendService.cancelUserExtend(id);
    }

    @Override
    public ApiResponse<String> activateTempUserExtend(UserActivateDto activateDto) {
        String accountStatus = UserStatus.OK.getCode();
        LocalDateTime endTime = Java8DateUtils.convertStringToLocalDateTime((String)StringUtils.trimToEmpty((String)activateDto.getEndTime()));
        Date lastLoginTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        Date expiredTime = Date.from(endTime.atZone(ZoneId.systemDefault()).toInstant());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", String.valueOf(activateDto.getId()));
        map.put("accountStatus", accountStatus);
        map.put("lastLoginTime", lastLoginTime);
        map.put("expiredTime", expiredTime);
        this.hussarBaseUserExtendMapper.CancelUserExtend(map);
        this.hussarBaseUserExtendMapper.activateTempUserExtend(map);
        return this.hussarBaseUserExtendService.activateTempUserExtend(activateDto);
    }

    @Override
    public ApiResponse<List<Map<String, Object>>> fillOrganInfos(List<Map<String, Object>> userInfoList) {
        String str = JsonUtil.toJson(userInfoList);
        str = (String)this.hussarBaseUserExtendService.fillOrganInfos(str).getData();
        userInfoList = (List)JsonUtil.parse((String)str, List.class);
        return ApiResponse.success((Object)userInfoList);
    }

    @Override
    public ApiResponse<List<Map<String, Object>>> wrapUsers(List<Map<String, Object>> userInfoList) {
        String str = JsonUtil.toJson(userInfoList);
        str = (String)this.hussarBaseUserExtendService.wrapUsers(str).getData();
        userInfoList = (List)JsonUtil.parse((String)str, List.class);
        return ApiResponse.success((Object)userInfoList);
    }

    @Override
    public ApiResponse<List<Map<String, Object>>> fillUserSignInfos(List<Map<String, Object>> userInfoList) {
        String str = JsonUtil.toJson(userInfoList);
        str = (String)this.hussarBaseUserExtendService.fillUserSignInfos(str).getData();
        userInfoList = (List)JsonUtil.parse((String)str, List.class);
        return ApiResponse.success((Object)userInfoList);
    }

    @Override
    public ApiResponse<String> updateUserExtend(Map<String, Object> queryParam) {
        this.hussarBaseUserExtendMapper.updateUserExtend(queryParam);
        return ApiResponse.success();
    }
}

