/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authorization.extension.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.extend.dto.OrganExtendFullDto;
import com.jxdinfo.hussar.authorization.extend.model.OrganExtendExcel;
import com.jxdinfo.hussar.authorization.extend.service.IHussarBaseOrganExtendWebService;
import com.jxdinfo.hussar.authorization.extend.vo.ExtendOrganInfoVo;
import com.jxdinfo.hussar.authorization.extend.vo.OrganExtendSortVo;
import com.jxdinfo.hussar.authorization.extend.vo.OrganExtendTransferVo;
import com.jxdinfo.hussar.authorization.extend.vo.OrganWithStruIdVo;
import com.jxdinfo.hussar.authorization.organ.dto.AddOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.TransferOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.formdesign.application.authorization.extension.dao.HussarBaseOrganExtendMapper;
import com.jxdinfo.hussar.formdesign.application.authorization.extension.service.IHussarBaseOrganExtendService;
import com.jxdinfo.hussar.formdesign.application.authorization.extension.util.NoCodeAuthorizationExtendUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.nocode.authorization.extension.service.impl.HussarBaseOrganExtendApiServiceImpl")
public class HussarBaseOrganExtendServiceImpl
implements IHussarBaseOrganExtendService {
    @Resource
    private IHussarBaseOrganExtendWebService hussarBaseOrganExtendService;
    @Autowired
    private HussarBaseOrganExtendMapper hussarBaseOrganExtendMapper;
    @Resource
    private NoCodeAuthorizationExtendUtil authorizationExtendUtils;

    @Override
    public ApiResponse<Map<String, Object>> addOrgan(Map<String, Object> params) {
        AddOrganizationDto addOrganizationDto = this.authorizationExtendUtils.processAddOrganization(params);
        OrganWithStruIdVo organWithStruIdVo = (OrganWithStruIdVo)this.hussarBaseOrganExtendService.addOrgan(addOrganizationDto).getData();
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        resultMap.put("id", organWithStruIdVo.getOrganId());
        resultMap.put("struId", organWithStruIdVo.getStruId());
        resultMap.put("param", (Long)organWithStruIdVo.getSysOrgan());
        return ApiResponse.success(resultMap);
    }

    @Override
    public ApiResponse<List<OrganExtendSortVo>> sortOrganization(List<Long> idList) {
        ApiResponse response = this.hussarBaseOrganExtendService.sortOrganization(idList);
        List sortVoList = (List)response.getData();
        if (HussarUtils.isNotEmpty((Object)sortVoList)) {
            this.hussarBaseOrganExtendMapper.updateBatchById(sortVoList);
        }
        return response;
    }

    @Override
    public ApiResponse<String> deleteOrgan(List<Long> idList) {
        return this.hussarBaseOrganExtendService.deleteOrgan(idList);
    }

    @Override
    public ApiResponse<String> editOrgan(Map<String, Object> params) {
        String pName = params.get("ORGAN_NAME").toString();
        String id = params.get("RECORD_ID").toString();
        this.hussarBaseOrganExtendMapper.updatePname(pName, id);
        EditOrganizationDto editOrganizationDto = this.authorizationExtendUtils.processEditOrganization(params);
        return this.hussarBaseOrganExtendService.editOrgan(editOrganizationDto);
    }

    @Override
    public ApiResponse<String> transferOrganization(TransferOrganizationDto transferOrganizationDto, String organName) {
        OrganExtendTransferVo organExtendTransferVo = (OrganExtendTransferVo)this.hussarBaseOrganExtendService.transferOrganization(transferOrganizationDto, organName).getData();
        String oldId = organExtendTransferVo.getOldOrganId().toString();
        String newId = organExtendTransferVo.getNewOrganId().toString();
        String parentNameLabel = organExtendTransferVo.getNewParentName();
        String parentName = this.getParentName(parentNameLabel, newId);
        ArrayList<SysOrgan> organList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)organExtendTransferVo.getUpdateOrganList())) {
            organList = organExtendTransferVo.getUpdateOrganList();
        }
        HashMap<String, String> updateMap = new HashMap<String, String>();
        updateMap.put("oldOrganId", oldId);
        updateMap.put("newOrganId", newId);
        updateMap.put("parentNameLabel", parentNameLabel);
        updateMap.put("parentName", parentName);
        Integer count = this.hussarBaseOrganExtendMapper.transferOrganization(updateMap);
        if (HussarUtils.isNotEmpty(organList)) {
            this.hussarBaseOrganExtendMapper.updateTransferOrganInfo(organList);
        }
        if (count > 0) {
            return ApiResponse.success((String)String.valueOf(organExtendTransferVo.getMessage() == null ? "" : organExtendTransferVo.getMessage()));
        }
        return ApiResponse.fail((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    private String getParentName(String parentNameLabel, String newId) {
        HashMap<String, String> parentName = new HashMap<String, String>();
        parentName.put("label", parentNameLabel);
        parentName.put("id", newId);
        ArrayList list = Lists.newArrayList((Object[])new Map[]{parentName});
        return JSON.toJSONString((Object)list);
    }

    @Override
    public ApiResponse<String> saveOrganInfo(String appId, String formId, Map<String, Object> params) {
        String s = JsonUtil.toJson(params);
        OrganExtendFullDto organExtendFullDto = (OrganExtendFullDto)JsonUtil.parse((String)s, OrganExtendFullDto.class);
        if (HussarUtils.isNotEmpty((Object)params.get("STRU_ID"))) {
            organExtendFullDto.setId(Long.valueOf(Long.parseLong(params.get("STRU_ID").toString())));
        }
        return this.hussarBaseOrganExtendService.saveOrganInfo(appId, formId, organExtendFullDto);
    }

    @Override
    public ApiResponse<String> saveOrganPost(String appId, String formId, Map<String, Object> params) {
        EditOrganizationDto editOrganizationDto = new EditOrganizationDto();
        if (HussarUtils.isNotEmpty((Object)params.get("STRU_ID"))) {
            editOrganizationDto.setId(Long.valueOf(Long.parseLong(params.get("STRU_ID").toString())));
        }
        if (HussarUtils.isNotEmpty((Object)params.get("POST_IDS"))) {
            String ids = params.get("POST_IDS").toString();
            editOrganizationDto.setPostIds(Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList()));
        }
        return this.hussarBaseOrganExtendService.saveOrganPost(appId, formId, editOrganizationDto);
    }

    @Override
    public ApiResponse<String> saveOrganRole(String appId, String formId, Map<String, Object> params) {
        EditOrganizationDto editOrganizationDto = new EditOrganizationDto();
        if (HussarUtils.isNotEmpty((Object)params.get("STRU_ID"))) {
            editOrganizationDto.setId(Long.valueOf(Long.parseLong(params.get("STRU_ID").toString())));
        }
        if (HussarUtils.isNotEmpty((Object)params.get("ROLE_IDS"))) {
            String ids = params.get("ROLE_IDS").toString();
            editOrganizationDto.setRoleIds(Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList()));
        }
        return this.hussarBaseOrganExtendService.saveOrganRole(appId, formId, editOrganizationDto);
    }

    @Override
    public ApiResponse<List<ExtendOrganInfoVo>> getOrganInfo(String struId) {
        return this.hussarBaseOrganExtendService.getOrganInfo(struId);
    }

    @Override
    public ApiResponse<String> saveOrganBatch(Map<String, Object> params) {
        List<OrganExtendExcel> list = this.authorizationExtendUtils.processOrganExtendExcel(params);
        return this.hussarBaseOrganExtendService.saveOrganBatch(list);
    }

    @Override
    public ApiResponse<Integer> deletePhysically() {
        return ApiResponse.success((Object)this.hussarBaseOrganExtendMapper.deletePhysically());
    }
}

