/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authorization.extension.extract.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.authorization.extend.enums.OrganExtendEnum;
import com.jxdinfo.hussar.authorization.extend.model.UserExtendExcel;
import com.jxdinfo.hussar.authorization.extend.service.IHussarBaseStaffExtendWebService;
import com.jxdinfo.hussar.authorization.extend.service.IHussarBaseUserExtendWebService;
import com.jxdinfo.hussar.authorization.extend.vo.ExtendUserInfoVo;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.permit.dto.AddUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.EditUserDto;
import com.jxdinfo.hussar.excel.model.ExcelCheckResult;
import com.jxdinfo.hussar.formdesign.application.authorization.extension.service.IHussarBaseStaffExtendService;
import com.jxdinfo.hussar.formdesign.application.authorization.extension.service.IHussarBaseUserExtendService;
import com.jxdinfo.hussar.formdesign.application.authorization.extension.util.NoCodeAuthorizationExtendUtil;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.engine.api.service.EngineApiService;
import com.jxdinfo.hussar.formdesign.extension.api.service.IExtFormService;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.InvokeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.hotloaded.framework.annotation.Extract;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Extract(bus="main", scene="main", useCase="user")
@Component
@HussarTransactional
@HussarTokenDs
public class HussarBaseUserExtendCustomServiceImpl
implements IExtFormService {
    private static final Logger logger = LoggerFactory.getLogger(HussarBaseUserExtendCustomServiceImpl.class);
    @Resource
    private IHussarBaseUserExtendWebService hussarBaseUserExtendWebService;
    @Resource
    private NoCodeAuthorizationExtendUtil authorizationExtendUtils;
    @Resource
    private FormOperateExposedService formOperateExposedImpl;
    @Resource
    private EngineApiService engineApiService;
    @Resource
    private IHussarBaseUserExtendService hussarBaseUserExtendService;
    @Autowired
    private ModelRelateService modelRelateService;
    @Autowired
    private IHussarBaseStaffExtendService staffExtendService;
    @Autowired
    private IHussarBaseStaffExtendWebService staffExtendWebService;
    @Autowired
    private InvokeService invokeService;

    public ApiResponse<Object> tableQuery(Long appId, Long formId, String viewId, Map<String, Object> params) {
        List queryConditionList = JsonUtil.parseArray((String)JsonUtil.toJson((Object)params.get("superQueryConditionDto")), SuperQueryConditionDto.class);
        String struId = "";
        ArrayList<SuperQueryConditionDto> struConditionList = new ArrayList<SuperQueryConditionDto>();
        for (SuperQueryConditionDto superQueryConditionDto : queryConditionList) {
            if (!"ORGAN_ID".equals(superQueryConditionDto.getField())) continue;
            struId = superQueryConditionDto.getVal().toString();
            struConditionList.add(superQueryConditionDto);
            break;
        }
        queryConditionList.removeAll(struConditionList);
        if (HussarUtils.isEmpty((Object)EngineUtil.getUser()) || !OrganExtendEnum.ADMIN_USER_ID.contains(EngineUtil.getUser().getUserId())) {
            SuperQueryConditionDto isSysQeryCondition = new SuperQueryConditionDto();
            isSysQeryCondition.setField("IS_SYS");
            isSysQeryCondition.setRule("_eq");
            isSysQeryCondition.setMatch("AND");
            isSysQeryCondition.setVal((Object)"0");
            queryConditionList.add(isSysQeryCondition);
            params.put("superQueryConditionDto", queryConditionList);
        }
        HashMap<String, Object> orderMap = new HashMap<String, Object>();
        orderMap.put("column", "USER_ORDER");
        orderMap.put("asc", Boolean.TRUE);
        ((List)params.get("orders")).add(OrganExtendEnum.FIRST_ELEMENT, orderMap);
        ResponseEntity aggResponseEntity = this.invokeService.tableQuery(appId.toString(), formId.toString(), viewId, params);
        ApiResponse apiResponse = (ApiResponse)aggResponseEntity.getBody();
        PageVo apiResData = (PageVo)apiResponse.getData();
        List resultList = apiResData.getData();
        List finalList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)resultList)) {
            int current = Integer.parseInt(params.get("current").toString());
            int size = Integer.parseInt(params.get("size").toString());
            List userInfoVoList = (List)this.hussarBaseUserExtendWebService.getUserInfo(struId).getData();
            Map<String, List<ExtendUserInfoVo>> organInfoMap = userInfoVoList.stream().collect(Collectors.groupingBy(ExtendUserInfoVo::getUserId));
            ArrayList<String> struIdList = new ArrayList<String>(organInfoMap.keySet());
            resultList = resultList.stream().filter(o -> struIdList.contains(o.get("RECORD_ID").toString())).collect(Collectors.toList());
            int startNum = (current - 1) * size;
            int endNum = current * size;
            if (resultList.size() > startNum) {
                if (resultList.size() < endNum) {
                    endNum = resultList.size();
                }
                for (int i = startNum; i < endNum; ++i) {
                    ((Map)resultList.get(i)).put("id", organInfoMap.get(((Map)resultList.get(i)).get("RECORD_ID").toString()).get(0).getStruId());
                    ((Map)resultList.get(i)).put("ORGAN_FNAME", organInfoMap.get(((Map)resultList.get(i)).get("RECORD_ID").toString()).get(0).getOrganFname());
                    finalList.add(resultList.get(i));
                }
            }
        }
        if (HussarUtils.isNotEmpty(finalList)) {
            String jsonStr = JsonUtil.toJson(finalList);
            jsonStr = (String)this.hussarBaseUserExtendWebService.fillOrganInfos(jsonStr).getData();
            jsonStr = (String)this.hussarBaseUserExtendWebService.wrapUsers(jsonStr).getData();
            jsonStr = (String)this.hussarBaseUserExtendWebService.fillUserSignInfos(jsonStr).getData();
            finalList = (List)JsonUtil.parse((String)jsonStr, List.class);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "");
        resultMap.put("columnFields", new HashMap());
        resultMap.put("count", finalList.size());
        resultMap.put("data", finalList);
        return ApiResponse.success(resultMap);
    }

    public ApiResponse<Object> tableQueryAll(Long appId, Long formId) {
        return null;
    }

    public ApiResponse<Object> tableSave(Long appId, Long formId, Map<String, Object> params) {
        List sysOrganList = (List)params.get("importList");
        List userNameList = sysOrganList.stream().map(o -> o.get("USER_NAME").toString()).collect(Collectors.toList());
        List staffList = (List)this.staffExtendWebService.getStaffInfoByName(userNameList).getData();
        Map<String, String> nameEmpIdMap = staffList.stream().collect(Collectors.toMap(SysStaff::getName, o -> o.getId().toString()));
        for (Map stringObjectMap : sysOrganList) {
            String userName = stringObjectMap.get("USER_NAME").toString();
            stringObjectMap.put("EMPLOYEE_ID", nameEmpIdMap.get(userName));
        }
        List<UserExtendExcel> excelList = this.authorizationExtendUtils.processUserExtendExcel(params);
        ExcelCheckResult importResult = (ExcelCheckResult)this.hussarBaseUserExtendWebService.saveUserBatch(excelList).getData();
        this.invokeService.tableSave(appId.toString(), formId.toString(), params);
        return null;
    }

    public ApiResponse<Object> formSave(Long appId, Long formId, Map<String, Object> params) {
        String s;
        if (HussarUtils.isEmpty((Object)params.get("RECORD_ID"))) {
            s = JSON.toJSONString(params);
            AddUserDto addUserDto = (AddUserDto)JSON.parseObject((String)s, AddUserDto.class);
            if (HussarUtils.isNotEmpty((Object)params.get("EXPIRED_TIME"))) {
                addUserDto.setEndTime(params.get("EXPIRED_TIME").toString());
            }
            Long id = (Long)this.hussarBaseUserExtendWebService.addUserBaseInfo(addUserDto).getData();
            params.put("RECORD_ID", id);
        } else {
            s = JSON.toJSONString(params);
            EditUserDto editUserDto = (EditUserDto)JSON.parseObject((String)s, EditUserDto.class);
            editUserDto.setId(Long.valueOf(Long.parseLong(params.get("RECORD_ID").toString())));
            editUserDto.setUserSecurityLevel(params.get("SECURITY_LEVEL").toString());
            editUserDto.setAccountProperty(params.get("TYPE_PROPERTY").toString());
            if (HussarUtils.isNotEmpty((Object)params.get("EXPIRED_TIME"))) {
                editUserDto.setEndTime(params.get("EXPIRED_TIME").toString());
            }
            this.hussarBaseUserExtendWebService.editUserBaseInfo(editUserDto);
        }
        if (HussarUtils.isEmpty((Object)params.get("USER_ORDER"))) {
            Long maxOrder = (Long)this.hussarBaseUserExtendService.getMaxOrder().getData();
            if (HussarUtils.isEmpty((Object)maxOrder)) {
                params.put("USER_ORDER", 1);
            } else {
                params.put("USER_ORDER", maxOrder + 1L);
            }
        }
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId.toString());
        }
        this.authorizationExtendUtils.setIdAndTableNameColumnValue(formId.toString(), params);
        String businessId = this.formOperateExposedImpl.getBusinessId(HttpMethod.POST.name(), appId.toString(), formId.toString(), "FormSave");
        ResponseEntity responseEntity = this.engineApiService.invokeByReturnEntity(businessId, (String)null, params);
        return (ApiResponse)responseEntity.getBody();
    }

    public ApiResponse<Object> formQuery(Long appId, Long formId, String recordId, String tabType) {
        return null;
    }

    public ApiResponse<Object> deleteBatch(Long appId, Long formId, String ids) {
        this.hussarBaseUserExtendWebService.deleteUser(ids);
        return (ApiResponse)this.authorizationExtendUtils.deleteBatchWithRuleExtend(formId.toString(), ids, appId.toString(), null, new ArrayList<String>()).getBody();
    }
}

