/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authorization.extension.hook;

import com.jxdinfo.hussar.formdesign.extension.api.dto.form.FlowFormSubmitHookDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.FormDeleteHookDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.FormSaveHookDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.HookQueryConditionDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.TableQueryHookDto;
import com.jxdinfo.hussar.formdesign.extension.api.service.IFormOperateHookService;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.authorizationextend.hook.FormOperateHookServiceImpl")
public class FormOperateHookServiceImpl
implements IFormOperateHookService {
    @Autowired
    private IConvertPinyinService convertPinyinService;
    @Autowired
    private ISysIdtableService sysIdtableService;
    public static final Long EXTEND_APPLICATION_ID = 918541819388895233L;
    public static final Long EXTEND_ORGAN_FORM_ID = 918549920531881984L;
    public static final Long EXTEND_USER_FORM_ID = 918542307098370048L;
    public static final Long EXTEND_STRU_FORM_ID = 918553689994829824L;
    public static final String STAFF_PINYIN_FULL_COLUMN = "STAFF_NAME_PINYIN_FULL";
    public static final String STAFF_PINYIN_INITIAL_COLUMN = "STAFF_NAME_PINYIN_INITIAL";
    public static final String USER_PINYIN_FULL_COLUMN = "USER_NAME_PINYIN_FULL";
    public static final String USER_PINYIN_INITIAL_COLUMN = "USER_NAME_PINYIN_INITIAL";
    public static final String ORGAN_PINYIN_FULL_COLUMN = "ORGAN_NAME_PINYIN_FULL";
    public static final String ORGAN_PINYIN_INITIAL_COLUMN = "ORGAN_NAME_PINYIN_INITIAL";
    public static final String QUERY_CONDITION_MATCH_OR = "OR";
    public static final String QUERY_CONDITION_RULE_LIKE = "_like";
    public static final String NAME = "NAME";
    public static final String ORGAN_NAME = "ORGAN_NAME";
    public static final String USER_NAME = "USER_NAME";

    public void beforeTableQuery(TableQueryHookDto tableQueryHookDto) {
        if (EXTEND_APPLICATION_ID.equals(tableQueryHookDto.getAppId())) {
            List conditionDtoList;
            if (EXTEND_ORGAN_FORM_ID.equals(tableQueryHookDto.getFormId())) {
                List conditionDtoList2 = tableQueryHookDto.getHookParamDto().getHookQueryConditionDtos();
                if (HussarUtils.isNotEmpty((Object)conditionDtoList2)) {
                    for (HookQueryConditionDto filter : conditionDtoList2) {
                        if (!ORGAN_NAME.equals(filter.getField())) continue;
                        if (HussarUtils.isNotEmpty((Object)filter.getChildren())) {
                            filter.getChildren().addAll(this.getPinyinConditionDto(filter.getVal(), tableQueryHookDto.getFormId()));
                            break;
                        }
                        filter.setChildren(this.getPinyinConditionDto(filter.getVal(), tableQueryHookDto.getFormId()));
                        break;
                    }
                    tableQueryHookDto.getHookParamDto().setHookQueryConditionDtos(conditionDtoList2);
                }
            } else if (EXTEND_USER_FORM_ID.equals(tableQueryHookDto.getFormId())) {
                List conditionDtoList3 = tableQueryHookDto.getHookParamDto().getHookQueryConditionDtos();
                if (HussarUtils.isNotEmpty((Object)conditionDtoList3)) {
                    for (HookQueryConditionDto filter : conditionDtoList3) {
                        if (!USER_NAME.equals(filter.getField())) continue;
                        if (HussarUtils.isNotEmpty((Object)filter.getChildren())) {
                            filter.getChildren().addAll(this.getPinyinConditionDto(filter.getVal(), tableQueryHookDto.getFormId()));
                            break;
                        }
                        filter.setChildren(this.getPinyinConditionDto(filter.getVal(), tableQueryHookDto.getFormId()));
                        break;
                    }
                    tableQueryHookDto.getHookParamDto().setHookQueryConditionDtos(conditionDtoList3);
                }
            } else if (EXTEND_STRU_FORM_ID.equals(tableQueryHookDto.getFormId()) && HussarUtils.isNotEmpty((Object)(conditionDtoList = tableQueryHookDto.getHookParamDto().getHookQueryConditionDtos()))) {
                for (HookQueryConditionDto filter : conditionDtoList) {
                    if (!NAME.equals(filter.getField())) continue;
                    if (HussarUtils.isNotEmpty((Object)filter.getChildren())) {
                        filter.getChildren().addAll(this.getPinyinConditionDto(filter.getVal(), tableQueryHookDto.getFormId()));
                        break;
                    }
                    filter.setChildren(this.getPinyinConditionDto(filter.getVal(), tableQueryHookDto.getFormId()));
                    break;
                }
                tableQueryHookDto.getHookParamDto().setHookQueryConditionDtos(conditionDtoList);
            }
        }
    }

    public void tableQueryHook(TableQueryHookDto tableQueryHookDto, ApiResponse<Object> apiResponse) {
    }

    public void beforeFormSave(FormSaveHookDto formSaveHookDto) {
        if (EXTEND_APPLICATION_ID.equals(formSaveHookDto.getAppId())) {
            if (EXTEND_STRU_FORM_ID.equals(formSaveHookDto.getFormId())) {
                if (HussarUtils.isNotEmpty((Object)formSaveHookDto.getParams())) {
                    Map params = formSaveHookDto.getParams();
                    String name = HussarUtils.isEmpty(params.get(NAME)) ? "" : String.valueOf(params.get(NAME));
                    params.put(STAFF_PINYIN_FULL_COLUMN, this.convertPinyinService.getFullPinyin(name));
                    params.put(STAFF_PINYIN_INITIAL_COLUMN, this.convertPinyinService.getInitialsPinyin(name));
                    formSaveHookDto.setParams(params);
                }
            } else if (EXTEND_ORGAN_FORM_ID.equals(formSaveHookDto.getFormId())) {
                if (HussarUtils.isNotEmpty((Object)formSaveHookDto.getParams())) {
                    Map params = formSaveHookDto.getParams();
                    String name = HussarUtils.isEmpty(params.get(ORGAN_NAME)) ? "" : String.valueOf(params.get(ORGAN_NAME));
                    params.put(ORGAN_PINYIN_FULL_COLUMN, this.convertPinyinService.getFullPinyin(name));
                    params.put(ORGAN_PINYIN_INITIAL_COLUMN, this.convertPinyinService.getInitialsPinyin(name));
                    formSaveHookDto.setParams(params);
                }
            } else if (EXTEND_USER_FORM_ID.equals(formSaveHookDto.getFormId()) && HussarUtils.isNotEmpty((Object)formSaveHookDto.getParams())) {
                Map params = formSaveHookDto.getParams();
                String name = HussarUtils.isEmpty(params.get(NAME)) ? "" : String.valueOf(params.get(NAME));
                params.put(USER_PINYIN_FULL_COLUMN, this.convertPinyinService.getFullPinyin(name));
                params.put(USER_PINYIN_INITIAL_COLUMN, this.convertPinyinService.getInitialsPinyin(name));
                formSaveHookDto.setParams(params);
            }
        }
    }

    public void formSaveHook(FormSaveHookDto formSaveHookDto, ApiResponse<Object> apiResponse) {
    }

    public void beforeFlowFormSubmit(FlowFormSubmitHookDto flowFormSubmitHookDto) {
    }

    public void flowFormSubmitHook(FlowFormSubmitHookDto flowFormSubmitHookDto, ApiResponse<Object> apiResponse) {
    }

    public void beforeFormDelete(FormDeleteHookDto formDeleteHookDto) {
    }

    public void formDeleteHook(FormDeleteHookDto formDeleteHookDto) {
    }

    private List<HookQueryConditionDto> getPinyinConditionDto(String val, Long formId) {
        String fullField = "";
        String initFided = "";
        if (EXTEND_ORGAN_FORM_ID.equals(formId)) {
            fullField = ORGAN_PINYIN_FULL_COLUMN;
            initFided = ORGAN_PINYIN_INITIAL_COLUMN;
        } else if (EXTEND_USER_FORM_ID.equals(formId)) {
            fullField = USER_PINYIN_FULL_COLUMN;
            initFided = USER_PINYIN_INITIAL_COLUMN;
        } else if (EXTEND_STRU_FORM_ID.equals(formId)) {
            fullField = STAFF_PINYIN_FULL_COLUMN;
            initFided = STAFF_PINYIN_INITIAL_COLUMN;
        }
        ArrayList<HookQueryConditionDto> filterList = new ArrayList<HookQueryConditionDto>();
        HookQueryConditionDto fullCondition = new HookQueryConditionDto();
        fullCondition.setField(fullField);
        fullCondition.setRule(QUERY_CONDITION_RULE_LIKE);
        fullCondition.setMatch(QUERY_CONDITION_MATCH_OR);
        fullCondition.setVal(val);
        filterList.add(fullCondition);
        HookQueryConditionDto initCondition = new HookQueryConditionDto();
        initCondition.setField(initFided);
        initCondition.setRule(QUERY_CONDITION_RULE_LIKE);
        initCondition.setMatch(QUERY_CONDITION_MATCH_OR);
        initCondition.setVal(val);
        filterList.add(initCondition);
        return filterList;
    }
}

