/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authorization.extension.service.impl;

import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.extend.service.IHussarBaseStaffExtendWebService;
import com.jxdinfo.hussar.authorization.extend.vo.ExtendStaffInfoVo;
import com.jxdinfo.hussar.authorization.extend.vo.SysStaffExtendVo;
import com.jxdinfo.hussar.authorization.organ.dto.StaffDto;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.application.authorization.extension.dao.HussarBaseStaffExtendMapper;
import com.jxdinfo.hussar.formdesign.application.authorization.extension.service.IHussarBaseStaffExtendService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.nocode.authorization.extension.service.impl.HussarBaseStaffExtendApiServiceImpl")
public class HussarBaseStaffExtendServiceImpl
implements IHussarBaseStaffExtendService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarBaseStaffExtendServiceImpl.class);
    @Resource
    private IHussarBaseStaffExtendWebService hussarBaseStaffExtendService;
    @Autowired
    private HussarBaseStaffExtendMapper hussarBaseStaffExtendMapper;

    @Override
    public ApiResponse<String> deleteStaff(String ids) {
        return this.hussarBaseStaffExtendService.deleteStaff(ids);
    }

    @Override
    public ApiResponse<String> sortUnifyStaff(List<Long> idList) {
        List<String> idStrList = idList.stream().map(String::valueOf).collect(Collectors.toList());
        List<SysStaffExtendVo> list = this.hussarBaseStaffExtendMapper.list(idStrList);
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_STAFF_SORTING.getMessage()));
        AssertUtil.isNotEmpty(idList, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_PARAM.getMessage()));
        ArrayList<Long> ids = new ArrayList<Long>();
        AssertUtil.isTrue((idList.size() == list.size() ? 1 : 0) != 0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CONTAINS_NON_PERSONNEL.getMessage()));
        for (int i = 0; i < idList.size(); ++i) {
            LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_STAFF_COMPARE_ID_ORDER.getMessage()));
            if (Objects.equals(list.get(i).getRECORD_ID(), idList.get(i))) continue;
            ids.add(idList.get(i));
        }
        ArrayList<SysStaffExtendVo> update = new ArrayList<SysStaffExtendVo>();
        if (HussarUtils.isNotEmpty(ids)) {
            List<String> idStr = ids.stream().map(String::valueOf).collect(Collectors.toList());
            List<SysStaffExtendVo> listTemp = this.hussarBaseStaffExtendMapper.list(idStr);
            Map map = listTemp.stream().collect(Collectors.toMap(SysStaffExtendVo::getRECORD_ID, Function.identity()));
            LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_STAFF_SORT_CHANGED.getMessage()));
            SysStaffExtendVo temp = null;
            for (int i = 0; i < ids.size(); ++i) {
                temp = new SysStaffExtendVo();
                SysStaffExtendVo sysStaffT = (SysStaffExtendVo)map.get(ids.get(i));
                BeanUtils.copyProperties((Object)sysStaffT, (Object)temp);
                temp.setSTAFF_ORDER(listTemp.get(i).getSTAFF_ORDER());
                update.add(temp);
            }
        }
        boolean flag = true;
        if (HussarUtils.isNotEmpty(update)) {
            flag = this.hussarBaseStaffExtendMapper.updateBatchById(update);
            this.hussarBaseStaffExtendService.sortUnifyStaff(update);
        }
        if (flag) {
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SORT_SUCCESS.getMessage()));
        }
        return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SORT_FAIL.getMessage()));
    }

    @Override
    public ApiResponse<SysStaff> add(StaffDto staffDto) {
        return this.hussarBaseStaffExtendService.add(staffDto);
    }

    @Override
    public ApiResponse<String> edit(StaffDto staffDto) {
        return this.hussarBaseStaffExtendService.edit(staffDto);
    }

    @Override
    public ApiResponse<String> saveStaffOrgan(StaffDto staffDto) {
        return this.hussarBaseStaffExtendService.saveStaffOrgan(staffDto);
    }

    @Override
    public ApiResponse<List<ExtendStaffInfoVo>> getStaffInfo(String struId) {
        return this.hussarBaseStaffExtendService.getStaffInfo(struId);
    }

    @Override
    public ApiResponse<List<String>> getUserByStruId(Long appId, Long formId, String ids) {
        return this.hussarBaseStaffExtendService.getUserByStruId(appId, formId, ids);
    }

    @Override
    public ApiResponse<List<Map<String, Object>>> listNew(String sql) {
        return ApiResponse.success(this.hussarBaseStaffExtendMapper.listNew(sql));
    }

    @Override
    public ApiResponse<Long> getMaxOrder() {
        return ApiResponse.success((Object)this.hussarBaseStaffExtendMapper.getMaxOrder());
    }
}

