/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authorization.extension.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.extend.model.OrganExtendExcel;
import com.jxdinfo.hussar.authorization.extend.model.StaffExtendExcel;
import com.jxdinfo.hussar.authorization.extend.model.UserExtendExcel;
import com.jxdinfo.hussar.authorization.extend.service.IHussarBaseOrganExtendWebService;
import com.jxdinfo.hussar.authorization.organ.dto.AddOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOrganizationDto;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.NoCodeRuleTriggerType;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.server.push.PushDataAsync;
import com.jxdinfo.hussar.formdesign.app.frame.server.rule.rules.NoCodeRuleAsync;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.authorization.extension.dao.HussarBaseStaffExtendMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.mail.core.collection.CollUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@HussarTokenDs
public class NoCodeAuthorizationExtendUtil {
    private static final Logger logger = LoggerFactory.getLogger(NoCodeAuthorizationExtendUtil.class);
    @Autowired
    private HussarBaseStaffExtendMapper staffExtendMapper;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private IHussarAppFormService hussarAppFormService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private NoCodeRuleAsync noCodeRuleAsync;
    @Resource
    private PushDataAsync pushDataAsync;
    @Resource
    private IHussarBaseOrganExtendWebService hussarBaseOrganExtendWebService;

    public void setIdAndTableNameColumnValue(String formId, Map<String, Object> params) {
        FormDesignResponse formDesignResponse = this.canvasSchemaService.get(formId);
        if (HussarUtils.isEmpty((Object)formDesignResponse.getData())) {
            logger.error("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)formId);
            throw new BaseException("\u8868\u5355\u753b\u5e03\u4e0d\u5b58\u5728");
        }
        this.setIdAndTableNameColumnValue((FormCanvasSchema)formDesignResponse.getData(), params);
        this.parseSuggestValueToJsonString((FormCanvasSchema)formDesignResponse.getData(), params);
    }

    public void parseSuggestValueToJsonString(FormCanvasSchema canvasSchema, Map<String, Object> params) {
        canvasSchema.widgets().stream().filter(widget -> HussarUtils.equals((Object)widget.getType(), (Object)WidgetType.JXDN_SUGGESTION.getType())).forEach(widget -> {
            Object suggestValue = params.get(widget.getName());
            if (HussarUtils.isNotEmpty(suggestValue) && !(suggestValue instanceof String)) {
                params.put(widget.getName(), JSON.toJSONString(suggestValue));
            }
        });
    }

    private void setIdAndTableNameColumnValue(FormCanvasSchema canvasSchema, Map<String, Object> params) {
        if (HussarUtils.isEmpty((Object)params.get("RECORD_ID"))) {
            params.put("RECORD_ID", EngineUtil.getId());
        } else {
            this.paddingSubTableColumn(canvasSchema, params);
        }
        params.put(canvasSchema.getName(), params.get("RECORD_ID"));
        canvasSchema.childTables().forEach(childTable -> this.setChildIdAndTableName((Widget)childTable, (List)params.get(childTable.getName()), params.get("RECORD_ID"), null));
    }

    private void paddingSubTableColumn(FormCanvasSchema canvasSchema, Map<String, Object> params) {
        if (!HussarUtils.isEmpty((Object)params.get("RECORD_ID")) && HussarUtils.isNotEmpty((Object)canvasSchema.childTables())) {
            String recordId = String.valueOf(params.get("RECORD_ID"));
            ResponseEntity formQuery = this.formOperateExposedService.formQuery(canvasSchema.getId(), recordId, (String)null, canvasSchema.getAppId(), Boolean.FALSE.booleanValue());
            if (formQuery.getStatusCode() == HttpStatus.OK && ((ApiResponse)formQuery.getBody()).isSuccess()) {
                canvasSchema.childTables().forEach(widget -> {
                    List childs = (List)params.get(widget.getName());
                    Optional.ofNullable(childs).ifPresent(o -> o.forEach(child -> {
                        if (HussarUtils.isNotEmpty(child.get("RECORD_ID"))) {
                            Set subTableKeys = child.keySet();
                            Map oldData = (Map)((ApiResponse)formQuery.getBody()).getData();
                            List oldChildData = (List)oldData.get(widget.getName());
                            if (!HussarUtils.isEmpty((Object)oldChildData)) {
                                Map<Object, Map> oldChildDataMap = oldChildData.stream().collect(Collectors.toMap(map -> map.get("RECORD_ID"), map -> map, (v1, v2) -> v1));
                                Map oldOneData = oldChildDataMap.get(child.get("RECORD_ID"));
                                Optional.ofNullable(oldOneData).ifPresent(ood -> ood.entrySet().forEach(feildValue -> {
                                    if (!subTableKeys.contains(feildValue.getKey())) {
                                        child.put(feildValue.getKey(), feildValue.getValue());
                                    }
                                }));
                            }
                        }
                    }));
                });
            }
        }
    }

    private void setChildIdAndTableName(Widget widget, List<Map<String, Object>> childList, Object fid, Object gid) {
        if (HussarUtils.isNotEmpty(childList)) {
            childList.forEach(child -> {
                List cs;
                if (ToolUtil.isEmpty(child.get("RECORD_ID"))) {
                    child.put("RECORD_ID", EngineUtil.getId());
                }
                child.put(widget.getName(), child.get("RECORD_ID"));
                child.put("F_RECORD_ID", fid);
                if (gid != null) {
                    child.put("G_RECORD_ID", gid);
                }
                if (CollUtil.isNotEmpty((Collection)(cs = WidgetTool.flatButChildren(new ArrayList(), (List)widget.getChildren())))) {
                    cs.forEach(e -> this.setChildIdAndTableName((Widget)e, (List)child.get(e.getName()), child.get("RECORD_ID"), gid == null ? fid : gid));
                }
            });
        }
    }

    public ResponseEntity<ApiResponse<Object>> deleteBatchWithRuleExtend(String formId, String ids, String appId, Integer convertVersion, List<String> ruleIds) {
        this.hussarAppFormService.convertVersionCheck(formId, convertVersion);
        ResponseEntity result = null;
        SecurityUser user = BaseSecurityUtil.getUser() == null ? (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser") : BaseSecurityUtil.getUser();
        String traceId = (String)TransmittableThreadLocalHolder.get((String)"traceId");
        Filter idsFilter = new Filter();
        idsFilter.setField("RECORD_ID");
        idsFilter.setMatch("AND");
        idsFilter.setRule("_in");
        idsFilter.setVal(ids);
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(idsFilter);
        HashMap<String, ArrayList<Filter>> params = new HashMap<String, ArrayList<Filter>>();
        params.put("superQueryConditionDto", filters);
        ResponseEntity apiResponse = this.formOperateExposedService.tableQueryByCondition(appId, formId, params);
        PageVo pageData = (PageVo)((ApiResponse)Objects.requireNonNull(apiResponse.getBody())).getData();
        List dataTemp = pageData.getData();
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        if (!this.hussarAppFormService.contrastFormid(appId, formId, ids).booleanValue()) {
            return ResponseEntity.ok().body((Object)ApiResponse.fail((String)"\u8be5\u6570\u636e\u65e0\u6cd5\u901a\u8fc7\u5f53\u524d\u8868\u5355\u5220\u9664"));
        }
        result = this.hussarAppFormService.deleteBatch(formId, ids, appId);
        ApiResponse body = (ApiResponse)result.getBody();
        boolean isSuccess = (Boolean)body.getData();
        if (isSuccess) {
            for (Map stringObjectMap : dataTemp) {
                HussarNoCodeThreadUtil.executeUserTask(() -> {
                    this.noCodeRuleAsync.excNoCodeRuleAsync(appId, formId, new JSONObject(stringObjectMap), user, NoCodeRuleTriggerType.TriggerTypeDelete.getType(), traceId, ruleIds);
                    this.pushDataAsync.excPushDataAsync(appId, formId, new JSONObject(stringObjectMap), user, NoCodeRuleTriggerType.TriggerTypeDelete.getType());
                });
            }
        }
        return result;
    }

    public AddOrganizationDto processAddOrganization(Map<String, Object> params) {
        String s = JSON.toJSONString(params);
        AddOrganizationDto addOrganDto = (AddOrganizationDto)JSON.parseObject((String)s, AddOrganizationDto.class);
        if (HussarUtils.isNotEmpty((Object)params.get("PARENT_NAME_id"))) {
            addOrganDto.setParentId(Long.valueOf(Long.parseLong(params.get("PARENT_NAME_id").toString())));
        }
        if (HussarUtils.isNotEmpty((Object)params.get("PRINCIPAL_NAME_ref_id"))) {
            addOrganDto.setPrincipalId(Long.valueOf(Long.parseLong(params.get("PRINCIPAL_NAME_ref_id").toString())));
        }
        if (HussarUtils.isNotEmpty((Object)params.get("STRU_TYPE"))) {
            addOrganDto.setStruType(params.get("STRU_TYPE").toString());
        }
        return addOrganDto;
    }

    public EditOrganizationDto processEditOrganization(Map<String, Object> params) {
        String ids;
        String s = JSON.toJSONString(params);
        EditOrganizationDto editOrganDto = (EditOrganizationDto)JSON.parseObject((String)s, EditOrganizationDto.class);
        List struId = (List)this.hussarBaseOrganExtendWebService.getStruByOrganId((List)Lists.newArrayList((Object[])new Long[]{Long.parseLong(params.get("RECORD_ID").toString())})).getData();
        editOrganDto.setId(Long.valueOf(Long.parseLong(String.valueOf(struId.get(0)))));
        if (HussarUtils.isNotEmpty((Object)params.get("PRINCIPAL_NAME_ref_id"))) {
            editOrganDto.setPrincipalId(Long.valueOf(Long.parseLong(params.get("ORGAN_STRU_PRINC1_ref_id").toString())));
        }
        if (HussarUtils.isNotEmpty((Object)params.get("STRU_TYPE"))) {
            editOrganDto.setStruType(params.get("STRU_TYPE").toString());
        }
        if (HussarUtils.isNotEmpty((Object)params.get("POST_NAMES_ref_id"))) {
            ids = params.get("POST_NAMES_ref_id").toString();
            editOrganDto.setPostIds(Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList()));
        }
        if (HussarUtils.isNotEmpty((Object)params.get("ROLE_NAMES_ref_id"))) {
            ids = params.get("ROLE_NAMES_ref_id").toString();
            editOrganDto.setRoleIds(Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList()));
        }
        return editOrganDto;
    }

    public List<OrganExtendExcel> processOrganExtendExcel(Map<String, Object> params) {
        List sysOrganList = (List)params.get("importList");
        ArrayList<OrganExtendExcel> list = new ArrayList<OrganExtendExcel>();
        for (int i = 0; i < sysOrganList.size(); ++i) {
            String s = JSON.toJSONString(sysOrganList.get(i));
            OrganExtendExcel organExcel = (OrganExtendExcel)JSON.parseObject((String)s, OrganExtendExcel.class);
            Map map = (Map)sysOrganList.get(i);
            organExcel.setOrganCode(map.get("ORGAN_CODE").toString());
            organExcel.setOrganName(map.get("ORGAN_NAME").toString());
            organExcel.setOrganTypeName(map.get("STRU_TYPE_label").toString());
            organExcel.setShortName(map.get("SHORT_NAME").toString());
            organExcel.setOrganAlias(map.get("ORGAN_ALIAS").toString());
            organExcel.setOfficeAlias(map.get("OFFICE_ALIAS").toString());
            organExcel.setOfficeAddress(map.get("OFFICE_ADDRESS").toString());
            organExcel.setOrganProperty(map.get("ORGAN_PROPERTY").toString());
            organExcel.setValidTimeLimitType(map.get("VALID_TIME_LIMIT_TYPE").toString());
            organExcel.setStruOrder(map.get("STRU_ORDER").toString());
            organExcel.setOrganFName(map.get("ORGAN_FNAME").toString());
            organExcel.setOrganId(Long.valueOf(Long.parseLong(map.get("RECORD_ID").toString())));
            String organFname = map.get("ORGAN_FNAME").toString();
            List<String> organFnameList = Arrays.asList(organFname.split("/"));
            ArrayList<String> modifiableList = new ArrayList<String>(organFnameList);
            modifiableList.remove(modifiableList.size() - 1);
            organExcel.setParentOrganNames(String.join((CharSequence)"/", modifiableList));
            String principalName = map.get("PRINCIPAL_NAME").toString();
            JSONArray jsonArray = JSON.parseArray((String)principalName);
            JSONObject jsonObject = jsonArray.getJSONObject(0);
            String labelValue = jsonObject.getString("label");
            String idValue = jsonObject.getString("id");
            organExcel.setUserAccount(labelValue);
            organExcel.setPrincipalId(Long.valueOf(Long.parseLong(idValue)));
            list.add(organExcel);
        }
        return list;
    }

    public List<UserExtendExcel> processUserExtendExcel(Map<String, Object> params) {
        List sysOrganList = (List)params.get("importList");
        ArrayList<UserExtendExcel> list = new ArrayList<UserExtendExcel>();
        for (Map map : sysOrganList) {
            UserExtendExcel userExtendExcel = new UserExtendExcel();
            userExtendExcel.setUserAccount(HussarUtils.isNotEmpty((Object)params.get("USER_ACCOUNT")) ? params.get("USER_ACCOUNT").toString() : "");
            userExtendExcel.setUserId(HussarUtils.isNotEmpty((Object)params.get("RECORD_ID")) ? params.get("RECORD_ID").toString() : "");
            userExtendExcel.setUserName(HussarUtils.isNotEmpty((Object)params.get("USER_NAME")) ? params.get("USER_NAME").toString() : "");
            userExtendExcel.setUserOrder(HussarUtils.isNotEmpty((Object)params.get("USER_ORDER")) ? params.get("USER_ORDER").toString() : "");
            userExtendExcel.setMaxSessions(HussarUtils.isNotEmpty((Object)params.get("MAX_SESSIONS")) ? params.get("MAX_SESSIONS").toString() : "");
            userExtendExcel.setAccountStatus(HussarUtils.isNotEmpty((Object)params.get("ACCOUNT_STATUS")) ? params.get("ACCOUNT_STATUS").toString() : "");
            userExtendExcel.setTypeProperty(HussarUtils.isNotEmpty((Object)params.get("TYPE_PROPERTY")) ? params.get("TYPE_PROPERTY").toString() : "1");
            userExtendExcel.setStartTime(HussarUtils.isNotEmpty((Object)params.get("START_TIME")) ? params.get("START_TIME").toString() : "");
            userExtendExcel.setExpiredTime(HussarUtils.isNotEmpty((Object)params.get("EXPIRED_TIME")) ? params.get("EXPIRED_TIME").toString() : "");
            userExtendExcel.setMail(HussarUtils.isNotEmpty((Object)params.get("E_MAIL")) ? params.get("E_MAIL").toString() : "");
            userExtendExcel.setMobile(HussarUtils.isNotEmpty((Object)params.get("MOBILE")) ? params.get("MOBILE").toString() : "");
            userExtendExcel.setWeChat(HussarUtils.isNotEmpty((Object)params.get("WECHAT")) ? params.get("WECHAT").toString() : "");
            userExtendExcel.setIdcard(HussarUtils.isNotEmpty((Object)params.get("IDCARD")) ? params.get("IDCARD").toString() : "");
            userExtendExcel.setTelephone(HussarUtils.isNotEmpty((Object)params.get("TELEPHONE")) ? params.get("TELEPHONE").toString() : "");
            userExtendExcel.setDepartment(HussarUtils.isNotEmpty((Object)params.get("ORGAN_FNAME")) ? params.get("ORGAN_FNAME").toString() : "");
            userExtendExcel.setEmployeeId(HussarUtils.isNotEmpty((Object)params.get("EMPLOYEE_ID")) ? Long.valueOf(params.get("EMPLOYEE_ID").toString()) : null);
            list.add(userExtendExcel);
        }
        return list;
    }

    public List<StaffExtendExcel> processStaffExtendExcel(Map<String, Object> params) {
        List sysOrganList = (List)params.get("importList");
        ArrayList<StaffExtendExcel> list = new ArrayList<StaffExtendExcel>();
        for (Map map : sysOrganList) {
            StaffExtendExcel staffExtendExcel = new StaffExtendExcel();
            staffExtendExcel.setStaffId(HussarUtils.isNotEmpty((Object)params.get("RECORD_ID")) ? params.get("RECORD_ID").toString() : "");
            staffExtendExcel.setUserName(HussarUtils.isNotEmpty((Object)params.get("USER_NAME")) ? params.get("USER_NAME").toString() : "");
            staffExtendExcel.setBirthday(HussarUtils.isNotEmpty((Object)params.get("BIRTHDAY")) ? params.get("BIRTHDAY").toString() : "");
            staffExtendExcel.setDepartment(HussarUtils.isNotEmpty((Object)params.get("ORGAN_FNAME")) ? params.get("ORGAN_FNAME").toString() : "");
            staffExtendExcel.setStaffCode(HussarUtils.isNotEmpty((Object)params.get("STAFF_CODE")) ? params.get("STAFF_CODE").toString() : "");
            staffExtendExcel.setAddress(HussarUtils.isNotEmpty((Object)params.get("ADDRESS")) ? params.get("ADDRESS").toString() : "1");
            staffExtendExcel.setGraduateDate(HussarUtils.isNotEmpty((Object)params.get("GRADUATE_DATE")) ? params.get("GRADUATE_DATE").toString() : "");
            staffExtendExcel.setWorkDate(HussarUtils.isNotEmpty((Object)params.get("WORK_DATE")) ? params.get("WORK_DATE").toString() : "");
            staffExtendExcel.setWorkId(HussarUtils.isNotEmpty((Object)params.get("WORK_ID")) ? params.get("WORK_ID").toString() : "");
            staffExtendExcel.setSex(HussarUtils.isNotEmpty((Object)params.get("SEX")) ? params.get("SEX").toString() : "1");
            staffExtendExcel.setStaffOrder(HussarUtils.isNotEmpty((Object)params.get("STAFF_ORDER")) ? params.get("STAFF_ORDER").toString() : "");
            staffExtendExcel.setGraduateSchool(HussarUtils.isNotEmpty((Object)params.get("GRADUATE_SCHOOL")) ? params.get("GRADUATE_SCHOOL").toString() : "");
            staffExtendExcel.setRemark(HussarUtils.isNotEmpty((Object)params.get("STAFF_REMARK")) ? params.get("STAFF_REMARK").toString() : "");
            list.add(staffExtendExcel);
        }
        return list;
    }
}

