/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authorization.extension.extract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.extend.model.OrganExtendExcel;
import com.jxdinfo.hussar.authorization.extend.service.IHussarBaseOrganExtendWebService;
import com.jxdinfo.hussar.authorization.extend.vo.ExtendOrganInfoVo;
import com.jxdinfo.hussar.authorization.extend.vo.OrganWithStruIdVo;
import com.jxdinfo.hussar.authorization.organ.dto.AddOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.application.authorization.extension.service.IHussarBaseOrganExtendService;
import com.jxdinfo.hussar.formdesign.application.authorization.extension.service.IHussarBaseStaffExtendService;
import com.jxdinfo.hussar.formdesign.application.authorization.extension.util.NoCodeAuthorizationExtendUtil;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.engine.api.service.EngineApiService;
import com.jxdinfo.hussar.formdesign.extension.api.service.IExtFormService;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.InvokeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.hotloaded.framework.annotation.Extract;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Extract(bus="main", scene="main", useCase="organization")
@Component
@HussarTransactional
@HussarTokenDs
public class HussarBaseOrganExtendCustomServiceImpl
implements IExtFormService {
    @Autowired
    private IHussarBaseOrganExtendWebService hussarBaseOrganExtendWebService;
    @Resource
    private NoCodeAuthorizationExtendUtil authorizationExtendUtils;
    @Resource
    private FormOperateExposedService formOperateExposedImpl;
    @Resource
    private EngineApiService engineApiService;
    @Resource
    private IHussarBaseOrganExtendService hussarBaseOrganExtendService;
    @Resource
    private IHussarAppFormService appFormService;
    @Autowired
    private ModelRelateService modelRelateService;
    @Autowired
    private IHussarBaseStaffExtendService staffExtendService;
    @Autowired
    private InvokeService invokeService;

    public ApiResponse<Object> tableQuery(Long appId, Long formId, String viewId, Map<String, Object> params) {
        List queryConditionList = JsonUtil.parseArray((String)JsonUtil.toJson((Object)params.get("superQueryConditionDto")), SuperQueryConditionDto.class);
        ArrayList<SuperQueryConditionDto> removeDtos = new ArrayList<SuperQueryConditionDto>();
        String struId = "";
        for (SuperQueryConditionDto superQueryConditionDto : queryConditionList) {
            if ("ORGAN_TYPE".equals(superQueryConditionDto.getField())) {
                superQueryConditionDto.setField("STRU_TYPE");
            }
            if (!"ORGAN_ID".equals(superQueryConditionDto.getField())) continue;
            removeDtos.add(superQueryConditionDto);
            struId = superQueryConditionDto.getVal().toString();
        }
        queryConditionList.removeAll(removeDtos);
        params.put("superQueryConditionDto", queryConditionList);
        ResponseEntity aggResponseEntity = this.invokeService.tableQuery(appId.toString(), formId.toString(), viewId, params);
        ApiResponse apiResponse = (ApiResponse)aggResponseEntity.getBody();
        PageVo apiResData = (PageVo)apiResponse.getData();
        List resultList = apiResData.getData();
        ArrayList<Object> finalList = new ArrayList<Object>();
        if (HussarUtils.isNotEmpty((Object)resultList)) {
            int current = Integer.parseInt(params.get("current").toString());
            int size = Integer.parseInt(params.get("size").toString());
            List organInfoVoList = (List)this.hussarBaseOrganExtendWebService.getOrganInfo(struId).getData();
            List organTypeList = (List)this.hussarBaseOrganExtendWebService.getOrganType().getData();
            Map<String, String> organTypeMap = organTypeList.stream().collect(Collectors.toMap(SysOrganType::getOrganType, SysOrganType::getTypeName));
            Map<String, List<ExtendOrganInfoVo>> organInfoMap = organInfoVoList.stream().collect(Collectors.groupingBy(o -> o.getOrganId().toString()));
            ArrayList<String> organIdList = new ArrayList<String>(organInfoMap.keySet());
            resultList = resultList.stream().filter(o -> organIdList.contains(o.get("RECORD_ID").toString())).collect(Collectors.toList());
            int startNum = (current - 1) * size;
            int endNum = current * size;
            if (resultList.size() > startNum) {
                if (resultList.size() < endNum) {
                    endNum = resultList.size();
                }
                for (int i = startNum; i < endNum; ++i) {
                    ((Map)resultList.get(i)).put("icon", organInfoMap.get(((Map)resultList.get(i)).get("RECORD_ID").toString()).get(0).getImgUrl());
                    ((Map)resultList.get(i)).put("id", organInfoMap.get(((Map)resultList.get(i)).get("RECORD_ID").toString()).get(0).getStruId());
                    ((Map)resultList.get(i)).put("struOrder", organInfoMap.get(((Map)resultList.get(i)).get("RECORD_ID").toString()).get(0).getStruOrder());
                    ((Map)resultList.get(i)).put("userCount", 0);
                    ((Map)resultList.get(i)).put("STRU_TYPE_label", organTypeMap.get(((Map)resultList.get(i)).get("STRU_TYPE").toString()));
                    finalList.add(resultList.get(i));
                }
            }
        }
        finalList.sort(Comparator.comparing(o -> Integer.parseInt(o.get("struOrder").toString())));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "");
        resultMap.put("columnFields", new HashMap());
        resultMap.put("count", finalList.size());
        resultMap.put("data", finalList);
        return ApiResponse.success(resultMap);
    }

    public ApiResponse<Object> tableQueryAll(Long appId, Long formId) {
        return null;
    }

    public ApiResponse<Object> tableSave(Long appId, Long formId, Map<String, Object> params) {
        List<OrganExtendExcel> list = this.authorizationExtendUtils.processOrganExtendExcel(params);
        this.hussarBaseOrganExtendWebService.saveOrganBatch(list);
        String appIdS = appId.toString();
        String formIdS = formId.toString();
        List sysOrganList = (List)params.get("importList");
        for (Map stringObjectMap : sysOrganList) {
            String principalName = stringObjectMap.get("PRINCIPAL_NAME").toString();
            JSONArray jsonArray = JSON.parseArray((String)principalName);
            JSONObject jsonObject = jsonArray.getJSONObject(0);
            String labelValue = jsonObject.getString("label");
            stringObjectMap.put("PRINCIPAL_NAME", labelValue);
            stringObjectMap.put("PARENT_NAME", stringObjectMap.get("PARENT_NAME_label"));
        }
        this.invokeService.tableSave(appIdS, formIdS, params);
        return ApiResponse.success((String)"\u5bfc\u5165\u6210\u529f\uff01");
    }

    public ApiResponse<Object> formSave(Long appId, Long formId, Map<String, Object> params) {
        if (HussarUtils.isEmpty((Object)params.get("ORGAN_CODE"))) {
            SysOrgan sysOrgan = new SysOrgan();
            String organCode = (String)this.hussarBaseOrganExtendWebService.getCode(sysOrgan).getData();
            params.put("ORGAN_CODE", organCode);
        }
        String struId = "";
        if (HussarUtils.isEmpty((Object)params.get("RECORD_ID"))) {
            AddOrganizationDto addOrganizationDto = this.authorizationExtendUtils.processAddOrganization(params);
            OrganWithStruIdVo organWithStruIdVo = (OrganWithStruIdVo)this.hussarBaseOrganExtendWebService.addOrgan(addOrganizationDto).getData();
            params.put("RECORD_ID", organWithStruIdVo.getOrganId().toString());
            SysOrgan sysOrgan = organWithStruIdVo.getSysOrgan();
            params.put("ORGAN_FCODE", sysOrgan.getOrganFcode());
            params.put("ORGAN_FNAME", sysOrgan.getOrganFname());
            params.put("SHORT_NAME", sysOrgan.getShortName());
            params.put("PARENT_TYPE_CODE", sysOrgan.getParentTypeCode());
            struId = organWithStruIdVo.getStruId().toString();
        } else {
            EditOrganizationDto editOrganizationDto = this.authorizationExtendUtils.processEditOrganization(params);
            this.hussarBaseOrganExtendWebService.editOrgan(editOrganizationDto);
        }
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId.toString());
        }
        this.authorizationExtendUtils.setIdAndTableNameColumnValue(formId.toString(), params);
        String businessId = this.formOperateExposedImpl.getBusinessId(HttpMethod.POST.name(), appId.toString(), formId.toString(), "FormSave");
        ResponseEntity responseEntity = this.engineApiService.invokeByReturnEntity(businessId, (String)null, params);
        ApiResponse apiResponse = (ApiResponse)responseEntity.getBody();
        if (HussarUtils.isNotEmpty((Object)struId)) {
            return ApiResponse.success((Object)Lists.newArrayList((Object[])new String[]{struId}));
        }
        return ApiResponse.success((Object)(HussarUtils.isEmpty((Object)apiResponse) ? null : apiResponse.getData()));
    }

    public ApiResponse<Object> formQuery(Long appId, Long formId, String recordId, String tabType) {
        return null;
    }

    public ApiResponse<Object> deleteBatch(Long appId, Long formId, String ids) {
        List idList = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
        List struIdList = (List)this.hussarBaseOrganExtendWebService.getStruByOrganId(idList).getData();
        this.hussarBaseOrganExtendWebService.deleteOrgan(struIdList);
        ApiResponse apiResponse = (ApiResponse)this.appFormService.deleteBatch(formId.toString(), ids, appId.toString()).getBody();
        this.hussarBaseOrganExtendService.deletePhysically();
        return ApiResponse.success((Object)(HussarUtils.isEmpty((Object)apiResponse) ? null : apiResponse.getData()));
    }
}

