const file = params.file; // 文件对象

// 微信小程序需要用 file.path，H5/App 用 file 对象
const filePath = file.path || file;

uni.uploadFile({
url: '/hussarApi/attachment/uploadfilewithdrag', // 你的上传接口地址
filePath: filePath,    // 文件路径（小程序）或文件对象（H5）
name: 'file',          // 后端接收的文件字段名
formData: {            // 其他附加参数
  // 可以添加额外的表单字段
  userId: sessionStorage.getItem(process.env.VUE_APP_USERID)
},
success: (res) => {
  // 注意：小程序返回的res.data是字符串需要手动parse
  const response = typeof res.data === 'string' ? JSON.parse(res.data) : res.data;

  if (response.code === 10000 || response.code === 200) {
    self.${instanceKey!}UploadSuccess(response, file, self.${instanceKey!}FileList);
    uni.showToast({
      title: '文件上传成功',
      icon: 'success',
      duration: 2000
    });
  } else {
    uni.showModal({
      title: '上传失败',
      content: response.msg || '未知错误',
      showCancel: false
    });
  }
},
fail: (err) => {
  console.error('上传失败:', err);
  uni.showModal({
    title: '上传异常',
    content: '网络错误或服务器异常',
    showCancel: false
  });
}
});