/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.lock.FileLockInfoVo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.properties.MobileUniProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVueInfo;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVuePathVO;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVueVO;
import com.jxdinfo.hussar.formdesign.extend.service.ExtendCustomVueCommonService;
import com.jxdinfo.hussar.formdesign.extend.service.ExtendCustomVueService;
import com.jxdinfo.hussar.formdesign.extend.util.ParsingUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileLockManagerService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl.BaseFileServiceImpl;
import com.jxdinfo.hussar.formdesign.publish.uni.UniPathStrategyService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.IResultCode;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

@ClientKind(kind="com.jxdinfo.UniPage.extend.vue")
public class ExtendMobileUniVueimpl
extends BaseFileServiceImpl<ExtendCustomVueInfo>
implements ExtendCustomVueService {
    private UniPathStrategyService uniPathStrategy = (UniPathStrategyService)SpringContextUtil.getBean(UniPathStrategyService.class);
    private PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
    private FormDesignProperties speedCodeProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
    private MobileUniProperties mobileUniProperties = (MobileUniProperties)SpringContextUtil.getBean(MobileUniProperties.class);
    private final ExtendCustomVueCommonService extendCustomVueCommonService = (ExtendCustomVueCommonService)SpringContextUtil.getBean(ExtendCustomVueCommonService.class);
    private FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
    private FileLockManagerService lockManagerService = (FileLockManagerService)SpringContextUtil.getBean(FileLockManagerService.class);

    public ApiResponse<List<ExtendCustomVuePathVO>> listVue() throws LcdpException, IOException {
        String projectPath = this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath();
        List extendCustomVuePathVos = this.extendCustomVueCommonService.listVue(projectPath, "UniPage");
        return ApiResponse.success((Object)extendCustomVuePathVos);
    }

    public ApiResponse<FileLockInfoVo> saveCustomVue(ExtendCustomVueInfo fileInfo) throws IOException, LcdpException {
        ApiResponse response = this.lockManagerService.checkLock(fileInfo.getId(), null);
        if (!response.isSuccess()) {
            return response;
        }
        if (StringUtil.isNotBlank((CharSequence)fileInfo.getId()) && this.fileMappingService.isFileExist(fileInfo.getId())) {
            this.extendCustomVueCommonService.updateFile((BaseFile)fileInfo);
        } else if (StringUtil.isNotBlank((CharSequence)fileInfo.getFilePath())) {
            if (this.extendCustomVueCommonService.checkExists(fileInfo.getFilePath(), "UniCustomPage")) {
                return ApiResponse.fail((String)"\u8be5\u6587\u4ef6\u5df2\u6ce8\u518c");
            }
            this.extendCustomVueCommonService.create((BaseFile)fileInfo);
        } else {
            return ApiResponse.fail((String)"\u53c2\u6570\u7f3a\u5931");
        }
        return ApiResponse.success();
    }

    public ApiResponse<ExtendCustomVueVO> getDetailById(String id) throws IOException, LcdpException {
        if (StringUtil.isBlank((CharSequence)id)) {
            return ApiResponse.fail((String)"\u53c2\u6570\u7f3a\u5931");
        }
        if (!this.fileMappingService.isFileExist(id)) {
            return ApiResponse.fail((String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        ExtendCustomVueVO customVueDetail = this.extendCustomVueCommonService.getCustomVueDetail(this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), (ExtendCustomVueInfo)this.extendCustomVueCommonService.get(id), "UniPage");
        return ApiResponse.success((Object)customVueDetail);
    }

    public ApiResponse<String> getVueContentByPath(String filePath) throws LcdpException {
        if (StringUtil.isEmpty((Object)filePath)) {
            return ApiResponse.fail((IResultCode)ResultCode.NO_EXIST_RESOURCE);
        }
        String vueContent = this.extendCustomVueCommonService.getVueContentByPath(this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), filePath, "UniPage");
        return ApiResponse.success((String)vueContent);
    }

    private boolean checkExists(String filePath) throws LcdpException, IOException {
        String metaPath = this.pathStrategy.resourcePathService().getProjectAndCodePath();
        List metaList = ParsingUtil.getFilePath((String)metaPath, (String)".ucpd.meta");
        try {
            for (String path : metaList) {
                String content = FileUtils.readFileToString((File)new File(path), (String)"UTF-8");
                ExtendCustomVueInfo fileInfo = (ExtendCustomVueInfo)JSON.parseObject((String)content, ExtendCustomVueInfo.class);
                if (!filePath.replaceAll("\\\\", "/").equals(fileInfo.getFilePath().replaceAll("\\\\", "/")) || !fileInfo.getType().equals("UniCustomPage")) continue;
                return true;
            }
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, filePath);
        }
        return false;
    }
}

