/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.cascade;

import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.ResourceCascadeService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import com.jxdinfo.hussar.formdesign.publish.uni.UniPathStrategyService;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.io.IOException;

@ClientKind(kind="com.jxdinfo.UniFrontScript.cascade")
public class UniFrontScriptCascadeImpl
implements ResourceCascadeVisitor {
    public static final String KIND = "com.jxdinfo.UniFrontScript.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException {
    }

    public void cascadeCopy(String id, String newId, String newName, String parentId) throws LcdpException, IOException {
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
    }

    public void cascadeDelete(String id) throws LcdpException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldVueFilePath = this.getOldVuePath(id, strategy);
        File file = new File(oldVueFilePath);
        if (FileUtils.exists((File)file)) {
            try {
                FileUtils.forceDelete((File)file);
                ResourceCascadeService resourceCascadeService = (ResourceCascadeService)SpringContextUtil.getBean(ResourceCascadeService.class);
                resourceCascadeService.deleteVuePublishFile(id);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, oldVueFilePath);
            }
        }
    }

    String getOldVuePath(String id, Integer strategy) throws LcdpException {
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String name = fileMappingService.getFileName(id);
        UniPathStrategyService uniPathStrategy = (UniPathStrategyService)SpringContextUtil.getBean(UniPathStrategyService.class);
        String rootPath = FileUtil.systemPath((String[])new String[]{uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), "src/extend"});
        return FileUtil.systemPath((String[])new String[]{rootPath, "js", name + ".js"});
    }

    protected boolean fixName(File oldFile, File newFile) {
        return FileUtils.fixName((File)oldFile, (File)newFile);
    }
}

