/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.uniui.vistor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.ctx.MobileUniCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Trigger;
import com.jxdinfo.hussar.formdesign.common.util.DynDataUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TabVoidVisitor
implements VoidVisitor<LcdpComponent, MobileUniCtx> {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, MobileUniCtx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("template/uniui/uni/tab/vant_tab.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderParms(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.judgeHorizontalAndVerticalFill(lcdpComponent, ctx);
    }

    private Boolean renderTrigger(LcdpComponent lcdpComponent) {
        List triggerList = lcdpComponent.getTrigger();
        ArrayList triggers = new ArrayList();
        for (int i = 0; i < triggerList.size(); ++i) {
            if (!((Trigger)triggerList.get(i)).getName().equals("clickItem")) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("triggerName", ((Trigger)triggerList.get(i)).getName());
            map.put("methodName", lcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)((Trigger)triggerList.get(i)).getName()));
            triggers.add(map);
            triggerList.remove(i);
            --i;
            return true;
        }
        return false;
    }

    private void renderAttrs(LcdpComponent lcdpComponent, MobileUniCtx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        if (ToolUtil.isNotEmpty(lcdpComponent.getInnerStyles().get("bottomCheckedLineColor"))) {
            lcdpComponent.addRenderParam("activeColor", (Object)lcdpComponent.getInnerStyles().get("bottomCheckedLineColor").toString());
        } else {
            lcdpComponent.addRenderParam("activeColor", (Object)"#0D8EFF");
        }
        Object hidden = lcdpComponent.getProps().get("hidden");
        if (ToolUtil.isNotEmpty(hidden)) {
            ctx.addData(lcdpComponent.getInstanceKey() + "Hidden: " + hidden + ",", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u9690\u85cf\u5c5e\u6027"));
            lcdpComponent.addAttr("v-if", "!" + lcdpComponent.getInstanceKey() + "Hidden");
        }
    }

    private void renderParms(LcdpComponent lcdpComponent, MobileUniCtx ctx) {
        Map props = lcdpComponent.getProps();
        String instanceKey = lcdpComponent.getInstanceKey();
        String defaultActiveTab = (String)props.get("defaultActiveTab");
        lcdpComponent.addRenderParam("id", (Object)instanceKey);
        List tabList = JSON.parseArray((String)lcdpComponent.getProps().get("tabList").toString(), HashMap.class);
        Integer defaultActiveTabNum = 0;
        for (int i = 0; i < tabList.size(); ++i) {
            if (!defaultActiveTab.equals(((HashMap)tabList.get(i)).get("slotName"))) continue;
            defaultActiveTabNum = i;
        }
        lcdpComponent.addRenderParam("bindData", (Object)(instanceKey + "Data"));
        ctx.addData(instanceKey + "Data:" + defaultActiveTabNum + ",", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u9ed8\u8ba4\u663e\u793a\u9875"));
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("type"))) {
            lcdpComponent.addRenderParam("styleType", lcdpComponent.getProps().get("type"));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("customAttr"))) {
            JSONObject stringData = (JSONObject)lcdpComponent.getProps().get("customAttr");
            JSONObject customAttr = (JSONObject)stringData.get((Object)"stringData");
            Map customMap = lcdpComponent.getCustomAttr();
            for (String key : customAttr.keySet()) {
                lcdpComponent.addRenderParam("customAttrKey", (Object)key);
                lcdpComponent.addRenderParam("customAttrValue", customAttr.get((Object)key));
                customMap.remove(key);
            }
            lcdpComponent.setCustomAttr(customMap);
        }
    }

    private void renderMethod(LcdpComponent lcdpComponent, MobileUniCtx ctx) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> param = new ArrayList<String>();
        param.add("index");
        params.put("configClickItem", this.renderTrigger(lcdpComponent));
        params.put("id", lcdpComponent.getInstanceKey());
        ctx.addMethod(lcdpComponent.getInstanceKey() + "OnClickItem", param, RenderUtil.renderTemplate((String)"template/uniui/uni/tab/vant_tab_click-item.ftl", params));
    }

    private void renderData(LcdpComponent lcdpComponent, MobileUniCtx ctx) throws Exception {
        List tabList = JSON.parseArray((String)lcdpComponent.getProps().get("tabList").toString(), HashMap.class);
        ArrayList<String> options = new ArrayList<String>();
        for (HashMap tab : tabList) {
            String name;
            if (tab.get("tabName").getClass() == String.class) {
                name = "'" + tab.get("tabName").toString() + "'";
            } else {
                JSONObject labelObj = (JSONObject)tab.get("tabName");
                if (labelObj.get((Object)"international").equals(true)) {
                    name = "this.hussar_t({key: `" + labelObj.get((Object)"internationalCode") + "`, fallbackStr: `" + labelObj.get((Object)"name") + "`})";
                    lcdpComponent.addRenderParam("international", (Object)true);
                } else {
                    name = "'" + labelObj.get((Object)"name").toString() + "'";
                }
            }
            options.add(name);
        }
        ComponentData componentData = RenderVModelUtil.renderDataItem((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._OPTION.getType(), Collections.singletonList("data"), (String)((Object)options).toString());
        String optionValue = componentData.getRenderValue();
        if (ToolUtil.isNotEmpty((Object)lcdpComponent.getListParentKeyChain()) && componentData.getComponentValueStatusEnum().equals("NONE")) {
            optionValue = lcdpComponent.getInstanceKey() + CodeSuffix._OPTION.getType();
            ctx.addData(optionValue + ": " + (ToolUtil.isNotEmpty((Object)componentData.getRenderValue()) ? componentData.getRenderValue() : "[]"), MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"tab\u9009\u9879"));
        }
        JSONObject fromComponentParams = JSON.parseObject((String)String.valueOf(lcdpComponent.getProps().get("formComponentParams")));
        ArrayList formComponentParamList = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)fromComponentParams)) {
            for (Map.Entry entry : fromComponentParams.entrySet()) {
                HashMap fromComponentParam = new HashMap();
                fromComponentParam.put(entry.getKey(), entry.getValue());
                formComponentParamList.add(fromComponentParam);
            }
        }
        int index = 0;
        for (HashMap tab : tabList) {
            String routePath = "";
            if (ToolUtil.isNotEmpty(tab.get("outLink")) && !"".equals(tab.get("outLink"))) {
                routePath = tab.get("outLink").toString();
                tab.put("outLink", routePath);
                continue;
            }
            if (!ToolUtil.isNotEmpty(tab.get("url")) || "".equals(tab.get("url").toString())) continue;
            StringBuilder props = new StringBuilder();
            StringBuilder triggers = new StringBuilder();
            JSONObject pageParamConfig = (JSONObject)((HashMap)JSON.parseObject((String)tab.get("url").toString(), HashMap.class)).get("pageParamConfig");
            String id = ((HashMap)JSON.parseObject((String)tab.get("url").toString(), HashMap.class)).get("fileId").toString();
            routePath = this.fileMappingService.getFormatPath(id);
            String pageName = routePath.substring(routePath.lastIndexOf(47) + 1);
            List events = lcdpComponent.getEvents();
            for (Object entry : events) {
                String eventName = entry.getTrigger();
                String oldName = "";
                List eventTriggers = lcdpComponent.getDynamicEventTriggers();
                for (Object eventTrigger : eventTriggers) {
                    Map e = DynDataUtil.asObject(eventTrigger).orElse(Collections.emptyMap());
                    if (!eventName.equals(e.get("name"))) continue;
                    oldName = String.valueOf(e.get("oName"));
                }
                if (entry.getTrigger().contains(String.valueOf(tab.get("slotName")))) {
                    String strTrigger = " @" + oldName + " =" + lcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)eventName);
                    triggers.append(strTrigger);
                }
                lcdpComponent.getTrigger().removeIf(trigger -> trigger.getName().equals(eventName));
            }
            for (Object entry : pageParamConfig.entrySet()) {
                HashMap<String, Map<String, Object>> moduleMap = new HashMap<String, Map<String, Object>>();
                String key = String.valueOf(entry.getKey());
                JSONObject value = JSON.parseObject((String)JSON.toJSONString(entry.getValue()));
                String propValue = pageName + index + ToolUtil.firstLetterToUpper((String)key);
                if (!ToolUtil.isNotEmpty((Object)value) || !ToolUtil.isNotEmpty(value.get("type"))) continue;
                String strProp = " :" + key + " = " + propValue;
                props.append(strProp);
                Map<String, Object> config = TabVoidVisitor.getRenderPageParamData(ctx, (Map.Entry<String, Object>)entry);
                if (config.size() > 0) {
                    moduleMap.put("params", config);
                }
                ctx.addComputed(propValue, RenderUtil.renderTemplate((String)"template/uniui/uni/tab/vant_tab_props.ftl", moduleMap), false, MultilineExegesisUtil.dealComputedExegesis((LcdpComponent)lcdpComponent));
            }
            tab.put("url", routePath);
            tab.put("pageName", "<!-- #ifdef MP-ALIPAY -->\n                <view>\u9489\u9489\u6682\u4e0d\u652f\u6301</view>\n              <!-- #endif -->\n              <!-- #ifndef MP-ALIPAY -->\n              <" + pageName + index + props + triggers + " />\n              <!-- #endif -->");
            ctx.addImports("import " + pageName.toLowerCase() + index + " from '@/views" + routePath + "'");
            ctx.addComponent(pageName.toLowerCase() + index);
            ++index;
        }
        lcdpComponent.addRenderParam("tabs", (Object)tabList);
    }

    private static Map<String, Object> getRenderPageParamData(MobileUniCtx ctx, Map.Entry<String, Object> entry) throws LcdpException {
        HashMap<String, Object> paramConfig = new HashMap<String, Object>();
        ComponentReference componentReference = (ComponentReference)JSON.parseObject((String)entry.getValue().toString(), ComponentReference.class);
        ComponentData data = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)componentReference);
        if (null != data) {
            paramConfig.put(entry.getKey(), data.getRenderValue());
        } else {
            paramConfig.put(entry.getKey(), "''");
        }
        return paramConfig;
    }

    private void judgeHorizontalAndVerticalFill(LcdpComponent lcdpComponent, MobileUniCtx ctx) {
        boolean isHorizontalFill = lcdpComponent.isHorizontalFill();
        boolean isVerticalFill = lcdpComponent.isVerticalFill();
        List scrollList = JSON.parseArray((String)lcdpComponent.getProps().get("scrollList").toString(), HashMap.class);
        int realWidth = Integer.parseInt(StringUtils.removeEndIgnoreCase((String)String.valueOf(lcdpComponent.getInnerStyles().get("realWidth")), (String)"px"));
        int realHeight = Integer.parseInt(StringUtils.removeEndIgnoreCase((String)String.valueOf(lcdpComponent.getInnerStyles().get("realHeight")), (String)"px"));
        for (HashMap hashMap : scrollList) {
            int scrollWidth = Integer.parseInt(StringUtils.removeEndIgnoreCase((String)String.valueOf(hashMap.get("scrollWidth")), (String)"px"));
            int scrollHeight = Integer.parseInt(StringUtils.removeEndIgnoreCase((String)String.valueOf(hashMap.get("scrollHeight")), (String)"px"));
            int diffX = scrollWidth - realWidth;
            int diffY = scrollHeight - realHeight;
            if (isHorizontalFill) {
                hashMap.put("scrollWidth", "calc(100% + " + diffX + "px)");
            } else if (diffX == 0) {
                hashMap.put("scrollWidth", "100%");
            }
            if (isVerticalFill) {
                hashMap.put("scrollHeight", "calc(100% + " + diffY + "px)");
                continue;
            }
            if (diffY != 0) continue;
            hashMap.put("scrollHeight", "100%");
        }
        lcdpComponent.addRenderParam("scrolls", (Object)scrollList);
    }
}

