/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.cascade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.ResourceCascadeService;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import com.jxdinfo.hussar.formdesign.publish.uni.UniPathStrategyService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@ClientKind(kind="com.jxdinfo.UniModule.cascade")
public class UniModuleCascadeImpl
implements ResourceCascadeVisitor {
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    private final UniPathStrategyService uniPathStrategy = (UniPathStrategyService)SpringContextHolder.getBean(UniPathStrategyService.class);
    private final PathStrategyService pathStrategy = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);
    private final ResourceCascadeService resourceCascadeService = (ResourceCascadeService)SpringContextHolder.getBean(ResourceCascadeService.class);
    public static final String KIND = "com.jxdinfo.UniModule.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String unirootPath = FileUtil.systemPath((String[])new String[]{this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), this.uniPathStrategy.uniPathService().getUniVueCodePath()});
        String unipath = this.getMetaPath(baseFile.getId());
        String uniparentPath = this.getMetaPath(baseFile.getParentId());
        File uninewFile = new File(this.relativeToAbsolute(uniparentPath + File.separator + baseFile.getName(), unirootPath));
        File unioldFile = new File(FileUtil.systemPath((String[])new String[]{unirootPath, unipath}));
        this.moduleEdit(unioldFile, uninewFile);
        File code = new File(FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().getProjectAndCodePath(), unipath}));
        this.iteratorMobileFile(code);
        String uniapiRootPath = FileUtil.systemPath((String[])new String[]{this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), this.uniPathStrategy.uniPathService().getUniFrontApiPath()});
        String uniapiPath = this.getMetaPath(baseFile.getId());
        String uniapiParentPath = this.getMetaPath(baseFile.getParentId());
        File uniapiNewFile = new File(this.relativeToAbsolute(uniapiParentPath + File.separator + baseFile.getName(), uniapiRootPath));
        File uniapiOldFile = new File(FileUtil.systemPath((String[])new String[]{uniapiRootPath, uniapiPath}));
        this.moduleEdit(uniapiOldFile, uniapiNewFile);
        String uniextendRootPath = FileUtil.systemPath((String[])new String[]{this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), this.uniPathStrategy.uniPathService().getExtendScriptPath()});
        File uniextendnewFile = new File(uniextendRootPath);
        this.iteratorDirectory(uniextendnewFile, baseFile, this.fileMappingService.getFileName(baseFile.getId()));
    }

    public void iteratorDirectory(File extendnewFile, BaseFile baseFile, String oldName) {
        if (ToolUtil.isNotEmpty((Object)extendnewFile) && ToolUtil.isNotEmpty((Object)FileUtils.listFiles((File)extendnewFile))) {
            for (File file : FileUtils.listFiles((File)extendnewFile)) {
                if (!FileUtils.isDirectory((File)file)) continue;
                if (file.getName().equals(oldName)) {
                    File newFile = new File(file.getParent() + File.separator + baseFile.getName());
                    if (FileUtils.exists((File)newFile)) continue;
                    this.fixName(file, newFile);
                    continue;
                }
                this.iteratorDirectory(file, baseFile, oldName);
            }
        }
    }

    public void moduleEdit(File oldFile, File newFile) {
        if (FileUtils.exists((File)oldFile) && !FileUtils.exists((File)newFile)) {
            this.fixName(oldFile, newFile);
        }
    }

    public void cascadeCopy(String id, String newId, String newName, String parentId) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String rootPath = FileUtil.systemPath((String[])new String[]{this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), this.uniPathStrategy.uniPathService().getUniVueCodePath()});
        String path = this.getMetaPath(id);
        String parentPath = this.getMetaPath(parentId);
        File from = new File(FileUtil.systemPath((String[])new String[]{rootPath, path}));
        File to = new File(this.relativeToAbsolute(parentPath + File.separator + newName, rootPath));
        if (parentPath.contains(path) && parentPath.length() > path.length()) {
            throw new LcdpException(LcdpExceptionEnum.BAN_FOLDER, path);
        }
        if (FileUtils.exists((File)from)) {
            if (!FileUtils.exists((File)to)) {
                FileUtils.forceMkdir((File)to);
            }
            FileUtils.copyDirectoryToDirectory((File)from, (File)to);
        }
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String unirootPath = FileUtil.systemPath((String[])new String[]{this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), this.uniPathStrategy.uniPathService().getUniVueCodePath()});
        String uniparentPath = this.getMetaPath(parentId);
        this.moveFrontFile(id, uniparentPath, unirootPath, newName, parentId);
        File code = new File(FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().getProjectAndCodePath(), this.getMetaPath(id)}));
        this.iteratorMobileFile(code);
        String uniapiRootPath = FileUtil.systemPath((String[])new String[]{this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), this.uniPathStrategy.uniPathService().getUniFrontApiPath()});
        String uniapiParentPath = this.getMetaPath(parentId);
        this.moveFrontFile(id, uniapiParentPath, uniapiRootPath, newName, parentId);
    }

    public void moveFrontFile(String id, String parentPath, String rootPath, String newName, String parentId) throws LcdpException, IOException {
        String path = this.getMetaPath(id);
        File from = new File(FileUtil.systemPath((String[])new String[]{rootPath, path}));
        File to = new File(this.relativeToAbsolute(parentPath + File.separator + newName, rootPath));
        if (parentPath.contains(path) && (id.equals(parentId) || this.copyCheck(id, parentId))) {
            throw new LcdpException(LcdpExceptionEnum.BAN_FOLDER, path);
        }
        if (FileUtils.exists((File)from)) {
            if (!FileUtils.exists((File)to)) {
                FileUtils.moveDirectory((File)from, (File)to);
            } else {
                FileUtils.moveDirectoryToDirectory((File)from, (File)to, (boolean)false);
            }
        }
    }

    private boolean copyCheck(String id, String parentId) throws IOException, LcdpException {
        BaseFile baseFile = this.fileMappingService.getPageInfoById(parentId);
        if (ToolUtil.isNotEmpty((Object)baseFile) && !"#".equals(baseFile.getParentId())) {
            if (id.equals(baseFile.getId())) {
                return true;
            }
            return this.copyCheck(id, baseFile.getParentId());
        }
        return false;
    }

    public void cascadeDelete(String id) throws LcdpException, IOException {
        Integer strategy;
        Integer n = strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        if (ToolUtil.isEmpty((Object)id)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        String path = this.getMetaPath(id);
        String unirootPath = FileUtil.systemPath((String[])new String[]{this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), this.uniPathStrategy.uniPathService().getUniVueCodePath()});
        File unif = new File(this.relativeToAbsolute(path, unirootPath));
        this.moduleDelete(unif);
        String uniapiRootPath = FileUtil.systemPath((String[])new String[]{this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), this.uniPathStrategy.uniPathService().getUniFrontApiPath()});
        File uniapif = new File(this.relativeToAbsolute(path, uniapiRootPath));
        this.moduleDelete(uniapif);
        String uniextendRootPath = FileUtil.systemPath((String[])new String[]{this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), this.formDesignProperties.getMobileExtendScriptPath()});
        this.extendModuleDelete(uniextendRootPath, path);
        File code = new File(FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().getProjectAndCodePath(), path}));
        this.iteratorMobileFile(code);
    }

    private void moduleDelete(File f) throws LcdpException {
        if (FileUtils.exists((File)f)) {
            try {
                FileUtils.forceDelete((File)f);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.DIRECTORY_DELETE_FAIL, f.getAbsolutePath());
            }
        }
    }

    private void extendModuleDelete(String rootPath, String path) throws LcdpException {
        String jsPath = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendJavaScriptPath(), path});
        this.moduleDelete(new File(jsPath));
        String vuePath = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendVuePath(), path});
        this.moduleDelete(new File(vuePath));
        String cssPath = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendCssScriptPath(), path});
        this.moduleDelete(new File(cssPath));
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }

    void dealRouter(String id, String newPageName, String newModuleRelatePath, boolean isDelete) throws IOException, LcdpException {
        String moduleRelatePath = this.fileMappingService.getFormatParentPath(id);
        String projectPath = this.uniPathStrategy.uniPathService().getUniProjectAbsolutePath();
        JSONObject jsonObject = this.resourceCascadeService.getJSONObject(id);
        String pageName = jsonObject.get((Object)"name").toString();
        String desc = jsonObject.get((Object)"desc").toString();
        String component = FileUtil.posixPath((String[])new String[]{AppContextUtil.posixFilePathPrefix(), "views", moduleRelatePath, pageName});
        String newComponent = FileUtil.posixPath((String[])new String[]{AppContextUtil.posixFilePathPrefix(), "views", newModuleRelatePath, ToolUtil.isNotEmpty((Object)newPageName) ? newPageName : pageName});
        String routerExport = "{\n 'path': '" + newComponent + "',\n'style': {\n'navigationBarTitleText': '" + desc + "'\n}\n}";
        this.mobileUniRouterCode(component, newComponent, routerExport, projectPath, isDelete);
    }

    private ResourcePath mobileProject(String name, String ... pathSegments) {
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getWorkspace(), name});
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }

    private void mobileUniRouterCode(String component, String newComponent, String fileContent, String vueRootPath, boolean isDelete) throws IOException {
        String filePath = (vueRootPath = FileUtil.complementFilePath((String)vueRootPath)) + "/src/pages.json";
        File file = new File(filePath);
        if (FileUtils.exists((File)file)) {
            String fileMsg = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            JSONObject parse = JSON.parseObject((String)fileMsg, (Feature[])new Feature[]{Feature.OrderedField});
            JSONArray jsonArray = JSON.parseArray((String)parse.get((Object)"pages").toString());
            boolean type = true;
            for (Object o : jsonArray) {
                String path = JSON.parseObject((String)o.toString()).get((Object)"path").toString();
                if (!path.equals(component)) continue;
                jsonArray.remove(o);
                break;
            }
            parse.put("pages", (Object)jsonArray);
            if (ToolUtil.isEmpty((Object)parse)) {
                FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8", (boolean)false);
            } else {
                FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)parse), (String)"UTF-8", (boolean)false);
            }
        }
    }

    private void iteratorMobileFile(File file) throws IOException, LcdpException {
        if (FileUtils.exists((File)file)) {
            if (FileUtils.isDirectory((File)file)) {
                File[] files = FileUtils.listFiles((File)file);
                if (files != null) {
                    for (File childFile : files) {
                        this.iteratorMobileFile(childFile);
                    }
                }
            } else if (file.getName().endsWith(".meta")) {
                JSONObject jsonObject = null;
                jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"));
                String id = jsonObject.get((Object)"id").toString();
                String type = jsonObject.get((Object)"type").toString();
                String parentId = jsonObject.get((Object)"parentId").toString();
                String parentPath = this.getMetaPath(parentId);
                if ("UniPage".equals(type)) {
                    this.dealRouter(id, null, parentPath, false);
                }
            }
        }
    }

    protected boolean fixName(File oldFile, File newFile) {
        return FileUtils.fixName((File)oldFile, (File)newFile);
    }
}

