/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.publish;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.ScriptCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.properties.MobileUniProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ScriptPublisher;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendUniWCssScript;
import com.jxdinfo.hussar.formdesign.extend.result.UniCssScriptCodeResult;
import com.jxdinfo.hussar.formdesign.publish.uni.impl.UniPathStrategy;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;

@ClientKind(kind="com.jxdinfo.UniCssScript.extend.publish")
public class UniCssScriptPublishImpl
implements ScriptPublisher {
    private static UniPathStrategy uniPathStrategy = (UniPathStrategy)SpringContextUtil.getBean(UniPathStrategy.class);
    public static final String KIND = "com.jxdinfo.UniCssScript.extend.publish";
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final MobileUniProperties mobileUniProperties = (MobileUniProperties)SpringContextHolder.getBean(MobileUniProperties.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    private static FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
    private static final String CSS_SUFFIX = ".css";

    public void publish(ScriptCtx<CodeResult> scriptCtx) throws LcdpException {
        BaseFile baseFile = scriptCtx.getBaseFile();
        ExtendUniWCssScript extendWCssScript = (ExtendUniWCssScript)((Object)JSON.parseObject((String)baseFile.getData(), ExtendUniWCssScript.class));
        String modelPath = this.fileMappingService.getFormatParentPath(baseFile.getId());
        String rootPath = FileUtil.systemPath((String[])new String[]{uniPathStrategy.uniPathService().getUniProjectAbsolutePath(), uniPathStrategy.uniPathService().getExtendScriptPath()});
        String path = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendCssScriptPath(), modelPath, baseFile.getName() + CSS_SUFFIX});
        if (HussarUtils.isNotEmpty((Object)extendWCssScript.getEditorNote())) {
            filePublishService.writeStringToFile(extendWCssScript.getEditorNote(), path, baseFile.getId());
        }
        UniCssScriptCodeResult cssScriptCodeResult = new UniCssScriptCodeResult();
        cssScriptCodeResult.setFilePath(path);
        cssScriptCodeResult.setResultType(ResultBeanEnum.CSS_SCRIPT);
        cssScriptCodeResult.setId(baseFile.getId());
        scriptCtx.addGenCodeResults((CodeResult)cssScriptCodeResult);
    }
}

