<#--表单验证方法-->
<#list checkList! as checkItem >
<#--正则验证表达式-->
	<#if checkItem.type == "reg">
		const reg${checkItem_index} = ${checkItem.value};
		if ((value || value === 0) && !reg${checkItem_index}.test(value)) {
		return { result: false, errorMsg: "${checkItem.errorMsg}", field: "${field}" };
		}
	<#--必填-->
	<#elseif checkItem.type == "required">
		if (value === null || value === undefined || !/[\S]+/.test(value)) {
		return { result: false, errorMsg: "${checkItem.errorMsg}", field: "${field}" };
		}
	<#--自定义正则-->
	<#elseif checkItem.type == "customRegular">
		const reg${checkItem_index} = ${checkItem.customValue!};
		if ((value || value === 0) && !reg${checkItem_index}.test(value)) {
		return { result: false, errorMsg: "${checkItem.errorMsg}", field: "${field}" };
		}
	<#--长度限制自定义-->
	<#elseif checkItem.type == "lengthLimit">
		const reg${checkItem_index} = ${checkItem.customValue!};
		if ((value || value === 0) && !reg${checkItem_index}.test(value.replace(/\s*/g, ''))) {
		return { result: false, errorMsg: "${checkItem.errorMsg}", field: "${field}" };
		}
	<#--后端验证-->
	<#elseif checkItem.type == "http">
	<#--外部js引用-->
	<#elseif checkItem.type == "implementFunction">
		const res${checkItem_index} = await ${checkItem.fileIdentify!}.${checkItem.functionName!}.bind(self)(
		<#list checkItem.paramName! as param>
			<#if (param_index == (checkItem.paramName?size-1))>
				${param!}
			<#else>
				${param!},
			</#if>
		</#list>
		);
		if (!res${checkItem_index}) {
		return { result: false, errorMsg: "${checkItem.errorMsg}", field: "${field}" };
		}
	</#if>
</#list>
<#--走到最后返回验证成功信息-->
return { result: true, errorMsg: "", field: "${field}" };