<mobile-base-tabs
        <#if bindData??> v-model="${bindData}"</#if>>
    <template slot-scope="slotProps">
        <#list tabs as tab>
            <van-tab name="${tab.slotName}" <#if tab.disabled ?? && tab.disabled>disabled</#if>>
                <template slot="title">
                    <#if iconPositionLeft?? && tab.iconClassName?? && tab.iconClassName != "">
                        <van-icon v-if="slotProps.isIcon" name="${tab.iconClassName}"></van-icon>
                    </#if>
                    ${tab.tabName}
                    <#if iconPositionRight?? && tab.iconClassName?? && tab.iconClassName != "">
                        <van-icon v-if="slotProps.isIcon" name="${tab.iconClassName}"></van-icon>
                    </#if>
                </template>
                <template slot="default">
                    <#if tab.pageName?? && tab.pageName != "">
                    <#--url有值，以组件的形式引入内部页面-->
                        <#list scrolls as scroll>
                            <#if scroll.slotName = tab.slotName>
                                <div class="mobile-tab-container"
                                        <#if scroll.scrollWidth?? && scroll.scrollHeight??>
                                    style="width: ${scroll.scrollWidth}; height: ${scroll.scrollHeight};"
                                        </#if>>
                                    ${tab.pageName}
                                </div>
                            </#if>
                        </#list>
                    <#else>
                        <#if tab.outLink?? && tab.outLink != "">
                        <#--outLink有值，以iframe的形式引入页面-->
                            <#list scrolls as scroll>
                                <#if scroll.slotName = tab.slotName>
                                    <div class="mobile-tab-container"
                                            <#if scroll.scrollWidth?? && scroll.scrollHeight??>
                                        style="width: ${scroll.scrollWidth}; height: ${scroll.scrollHeight};"
                                            </#if>>
                                        <iframe class="mobile-tab-contianer-frame" src="${tab.outLink}"></iframe>
                                    </div>
                                </#if>
                            </#list>
                        <#else>
                        <#--outLink与url均无，显示画布上的组件-->
                            <div style="height: 100%">
                                <#list slotCodes?keys as key>
                                    <#assign slotVue=slotCodes[key]>
                                    <#if key=tab.slotName>
                                        <#list scrolls as scroll>
                                            <#if scroll.slotName = tab.slotName>
                                                <div class="mobile-tab-container"
                                                        <#if scroll.scrollWidth?? && scroll.scrollHeight??>
                                                    style="width: ${scroll.scrollWidth}; height: ${scroll.scrollHeight};"
                                                        </#if>>
                                                    ${slotVue}
                                                </div>
                                            </#if>
                                        </#list>
                                    </#if>
                                </#list>
                            </div>
                        </#if>
                    </#if>
                </template>
            </van-tab>
        </#list>
    </template>
</mobile-base-tabs>