/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.CodePublishTool;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.VueCodeGenerateService;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.result.VueCodeResult;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.result.VueGenerateResult;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.file.impl.h5.H5PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatResult;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatter;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.common.visitor.CodePublisher;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.StyleScheme;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeBaseConfig;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeVars;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.model.MergeResult;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.theme.config.service.IHussarThemeConfigService;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@ClientKind(kind="com.jxdinfo.MobilePage.publish")
@Component(value="com.jxdinfo.MobilePage.publish")
public class H5CodePublishImpl
implements CodePublisher {
    public static final String KIND = "com.jxdinfo.MobilePage.publish";
    public static final String JS = ".js";

    public void publish(PublishCtx<CodeResult> publishCtx, ThemeVars themeVars) throws LcdpException, IOException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        PageInfo pageInfo = (PageInfo)publishCtx.getBaseFile();
        String id = pageInfo.getId();
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String moduleRelatePath = fileMappingService.getFormatParentPath(pageInfo.getId());
        String pageName = pageInfo.getName();
        String pageInfoDataJson = pageInfo.getData();
        JSONObject pageInfoDataJsonObject = JSON.parseObject((String)pageInfoDataJson);
        IHussarThemeConfigService iHussarThemeConfigService = (IHussarThemeConfigService)SpringContextUtil.getBean(IHussarThemeConfigService.class);
        StyleScheme styleScheme = iHussarThemeConfigService.getCurrentSysThemeInfo();
        ThemeBaseConfig themeBaseConfig = styleScheme.getThemeBase().getMobilePage();
        Map scssVars = styleScheme.getScssVars().getMobilePage();
        VueCodeGenerateService vueCodeGenerateService = (VueCodeGenerateService)SpringContextUtil.getBean(VueCodeGenerateService.class);
        VueGenerateResult codeFormatResult = vueCodeGenerateService.vueGenerate(publishCtx, pageInfoDataJsonObject, pageName, pageInfo, themeVars.getMobilePage(), strategy, themeBaseConfig, scssVars);
        String newContent = codeFormatResult.getCodeFormatCode();
        String projectPagePath = this.mobileProjectVue(fileMappingService.getFormatPath(id) + formDesignProperties.getPageSuffix()).getLocalPath();
        if (!codeFormatResult.isSucceed()) {
            VueCodeResult codeResult = new VueCodeResult();
            codeResult.setId(id);
            codeResult.setNewCode(newContent);
            codeResult.setFilePath(projectPagePath);
            codeResult.setCodeFormatSucceed(codeFormatResult.isSucceed());
            codeResult.setCodeFormatMessages(codeFormatResult.getMessages());
            codeResult.setMsg(codeFormatResult.getMsg());
            publishCtx.addCodeResult((CodeResult)codeResult);
            return;
        }
        newContent = CodeSplitUtil.removeEmptyLines((String)newContent);
        FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
        filePublishService.writePublishSourceToCache(id, "mobile");
        if (ToolUtil.isNotEmpty((Object)strategy)) {
            this.finallyWrite(publishCtx, newContent);
            this.compile(moduleRelatePath, pageName);
            return;
        }
        String ifEnvIp = (String)BaseSecurityUtil.getUser().getExtendUserMap().get("ifEnvIp");
        if (VfgModeTool.isRemote() && ("0".equals(ifEnvIp) || "1".equals(ifEnvIp))) {
            this.finallyWrite(publishCtx, newContent);
            return;
        }
        this.merge(publishCtx, newContent);
    }

    public void deleteExtend(JSONObject jsonObject, PageInfo pageInfo) throws LcdpException, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge(PublishCtx<CodeResult> publishCtx, String newContent) throws LcdpException, IOException {
        PageInfo pageInfo = (PageInfo)publishCtx.getBaseFile();
        String id = pageInfo.getId();
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String moduleRelatePath = fileMappingService.getFormatParentPath(pageInfo.getId());
        VersionManageService versionManageService = (VersionManageService)SpringContextUtil.getBean(VersionManageService.class);
        Optional<String> ancestorContent = Optional.ofNullable(versionManageService.getAncestorCodeById(id));
        Optional<String> lastFileContent = Optional.ofNullable(versionManageService.getLastFileCode(id));
        String pageName = pageInfo.getName();
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        String pagePath = this.mobileProjectVue(moduleRelatePath, pageName + formDesignProperties.getPageSuffix()).getLocalPath();
        FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
        Optional<String> currentContent = Optional.ofNullable(filePublishService.readCurrentPublishedFile(pagePath));
        if (ancestorContent.isPresent() && currentContent.isPresent()) {
            CodeMergeService codeMergeService;
            MergeResult mergeResult;
            boolean isConflict;
            String lastPulishCode = ancestorContent.get();
            String currentFileCode = currentContent.get();
            if (formDesignProperties.isLocalCodeFormatter()) {
                CodeFormatResult lastPublishResult = CodeFormatter.formatterHtml((String)ancestorContent.get(), (String)"vue");
                lastPulishCode = lastPublishResult.getCodeFormatCode();
                CodeFormatResult currentFileResult = CodeFormatter.formatterHtml((String)currentContent.get(), (String)"vue");
                currentFileCode = currentFileResult.getCodeFormatCode();
            }
            String lastFile = "";
            if (lastFileContent.isPresent()) {
                lastFile = lastFileContent.get();
            }
            if (!(isConflict = (mergeResult = (codeMergeService = (CodeMergeService)SpringContextUtil.getBean(CodeMergeService.class)).structuralMerge(pagePath, ExtractFileType.VUE, lastPulishCode, currentFileCode, newContent, lastFile, true)).isConflict())) {
                try {
                    this.genMobileCode(id, moduleRelatePath, pageName, pageInfo, mergeResult.getMergedCode(), null);
                }
                finally {
                    versionManageService.saveLastPublishCode(id, newContent);
                    versionManageService.saveLastFileCode(id, mergeResult.getMergedCode());
                }
            } else {
                String projectPagePath = this.mobileProjectVue(fileMappingService.getFormatPath(id) + formDesignProperties.getPageSuffix()).getLocalPath();
                CodePublishTool codePublishTool = (CodePublishTool)SpringContextUtil.getBean(CodePublishTool.class);
                codePublishTool.assembleCode(id, publishCtx, newContent, currentContent, mergeResult, projectPagePath);
            }
        } else {
            this.finallyWrite(publishCtx, newContent);
        }
    }

    private void finallyWrite(PublishCtx<CodeResult> publishCtx, String newContent) throws IOException, LcdpException {
        PageInfo pageInfo = (PageInfo)publishCtx.getBaseFile();
        String id = pageInfo.getId();
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String moduleRelatePath = fileMappingService.getFormatParentPath(pageInfo.getId());
        String pageName = pageInfo.getName();
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        this.genMobileCode(id, moduleRelatePath, pageName, pageInfo, newContent, strategy);
        VersionManageService versionManageService = (VersionManageService)SpringContextUtil.getBean(VersionManageService.class);
        versionManageService.saveLastPublishCode(id, newContent);
        versionManageService.saveLastFileCode(id, newContent);
    }

    private void genMobileCode(String id, String moduleRelatePath, String pageName, PageInfo pageInfo, String fileContent, Integer strategy) throws LcdpException, IOException {
        this.writeMobileCode(fileContent, moduleRelatePath, pageName, id);
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        if (!formDesignProperties.isLocalUnReset()) {
            FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
            String path = FileUtil.posixPath((String[])new String[]{fileMappingService.getFormatPath(id)});
            PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
            String component = FileUtil.posixPath((String[])new String[]{"@/views", pathStrategy.vuePathService().prefix(), moduleRelatePath, pageName});
            String desc = pageInfo.getDesc();
            String routerExport = "export default {\n   path: '" + FileUtil.posixPath((String[])new String[]{"/", pathStrategy.vuePathService().prefix(), path}) + "',\n   component: require('" + component + "').default,\n   name: '" + pageName + "',\n   meta: {title: '" + desc + "'}\n}";
            this.writeMobileRouterCode(routerExport, moduleRelatePath, pageName, id);
        }
        this.getApiCommon(pageInfo);
        this.getViewCommon(pageInfo);
    }

    private void getApiCommon(PageInfo pageInfo) throws LcdpException, IOException {
        String pageId = pageInfo.getId();
        HashMap<String, String> map = new HashMap<String, String>(2);
        String prefix = AppContextUtil.getUnionPrefix();
        prefix = ToolUtil.isNotEmpty((Object)prefix) ? FileUtil.posixPath((String[])new String[]{prefix}) : prefix;
        H5PathStrategyService h5pathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        map.put("name", h5pathStrategy.h5PathService().getName());
        map.put("pathName", h5pathStrategy.h5PathService().getPathName());
        String newCode = RenderUtil.renderTemplate((String)"prefixCommon/prefixCommon.ftl", map);
        String filePath = this.mobileProject(h5pathStrategy.h5PathService().getFrontApiPath(), "prefixCommon.js").getLocalPath();
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
        filePublishService.writeStringToFile(newCode, filePath, pageId);
    }

    private void getViewCommon(PageInfo pageInfo) throws LcdpException, IOException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String pageId = pageInfo.getId();
        HashMap<String, String> map = new HashMap<String, String>(2);
        String prefix = AppContextUtil.getUnionPrefix();
        prefix = ToolUtil.isNotEmpty((Object)prefix) ? FileUtil.posixPath((String[])new String[]{prefix}) : prefix;
        H5PathStrategyService h5pathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        map.put("name", h5pathStrategy.h5PathService().getName());
        map.put("pathName", h5pathStrategy.h5PathService().getPathName());
        String newCode = RenderUtil.renderTemplate((String)"prefixCommon/prefixCommon.ftl", map);
        String filePath = this.mobileProject(h5pathStrategy.h5PathService().getMobileVueCodePath(strategy), "prefixCommon.js").getLocalPath();
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
        filePublishService.writeStringToFile(newCode, filePath, pageId);
    }

    private void writeMobileRouterCode(String fileContent, String modulePath, String pageName, String pageId) throws IOException {
        H5PathStrategyService h5pathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        String filePath = FileUtil.systemPath((String[])new String[]{h5pathStrategy.h5PathService().getMobileFrontProjectPath(), h5pathStrategy.h5PathService().getMobileRouterPath(), modulePath, pageName + JS});
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
        filePublishService.writeStringToFile(fileContent, filePath, pageId);
    }

    private void writeMobileCode(String fileContent, String modulePath, String pageName, String pageId) {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        H5PathStrategyService h5pathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String vueRootPath = h5pathStrategy.h5PathService().getMobileVueCodePath(strategy);
        String filePath = FileUtil.systemPath((String[])new String[]{h5pathStrategy.h5PathService().getMobileFrontProjectPath(), vueRootPath, modulePath, pageName + formDesignProperties.getPageSuffix()});
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
        filePublishService.writeStringToFile(fileContent, filePath, pageId);
    }

    private void compile(String moduleRelatePath, String pageName) throws LcdpException {
        HashMap<String, String> compileParams = new HashMap<String, String>();
        String pageJSName = "__" + pageName;
        String tmpCompileJsPath = this.mobileProjectVue(moduleRelatePath, pageJSName + JS).getLocalPath();
        String pageType = "pages";
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        String publishVueRelativePath = pathStrategy.vuePathService().posixFilePathPrefix("@/" + pageType, new String[]{moduleRelatePath, pageName});
        if (ToolUtil.isNotEmpty((Object)moduleRelatePath)) {
            moduleRelatePath = moduleRelatePath.substring(0, 1).equals("/") ? moduleRelatePath.substring(1) : moduleRelatePath;
        }
        String tmpCompileJs = ToolUtil.loadResource(this.getClass(), (String)"/template/mobileTemplate.js");
        tmpCompileJs = tmpCompileJs.replace("${vuePath}", publishVueRelativePath);
        FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        filePublishService.writeStringToFile(tmpCompileJs, tmpCompileJsPath);
        compileParams.put("entry", tmpCompileJsPath);
        compileParams.put("template", this.mobileProject(formDesignProperties.getMobileCompileHtmlPath()).getLocalPath());
        compileParams.put("output", FileUtil.posixPath((String[])new String[]{formDesignProperties.getMobileCompilePath(), AppContextUtil.getUnionPrefix(), moduleRelatePath, pageName, File.separator}));
        compileParams.put("name", pageName);
        compileParams.put("path", moduleRelatePath);
        CodePublishTool codePublishTool = (CodePublishTool)SpringContextUtil.getBean(CodePublishTool.class);
        codePublishTool.compile(publishVueRelativePath, compileParams, formDesignProperties.getMobileCompileServer());
    }

    private ResourcePath mobileProject(String ... pathSegments) {
        H5PathStrategyService h5pathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        String localPrefix = h5pathStrategy.h5PathService().getMobileFrontProjectPath();
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }

    private ResourcePath mobileProjectVue(String ... pathSegments) {
        H5PathStrategyService h5pathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String localPrefix = FileUtil.systemPath((String[])new String[]{h5pathStrategy.h5PathService().getMobileFrontProjectPath(), h5pathStrategy.h5PathService().getMobileVueCodePath(strategy)});
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }
}

