/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mobileui.vant;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.mobileui.vistor.HorizontalContainerVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class VantHorizontalContainer
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.mobileui.JXDMobileHorizontalContainer";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_mobileHorizontalContainer");
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("padding", "${prefix}{padding: ${val};}");
        map.put("itemDisplay", "${prefix}{display: ${val}; display: -webkit-flex; flex-flow: row wrap; -webkit-flex-flow: row wrap;}");
        map.put("itemHorizontalAlign", "${prefix}{justify-content: ${val}; -webkit-justify-content: ${val};}");
        map.put("itemVerticalAlign", "${prefix}{align-content: ${val}; -webkit-align-content: ${val};}");
        map.put("itemLineAlign", "${prefix}{align-items: ${val}; -webkit-align-items: ${val};}");
        map.put("borderTop", "${prefix}{border-top: ${val};}");
        map.put("borderLeft", "${prefix}{border-left: ${val};}");
        map.put("borderRight", "${prefix}{border-right: ${val};}");
        map.put("borderBottom", "${prefix}{border-bottom: ${val};}");
        map.put("borderTopColor", "${prefix}{border-top-color: ${val};}");
        map.put("borderLeftColor", "${prefix}{border-left-color: ${val};}");
        map.put("borderRightColor", "${prefix}{border-right-color: ${val};}");
        map.put("borderBottomColor", "${prefix}{border-bottom-color: ${val};}");
        map.put("borderRadius", "${prefix}{border-radius: ${val};}");
        map.put("backgroundColor", "${prefix}{background-color: ${val};}");
        map.put("backgroundImage", "${prefix}{background-image: ${val};}");
        map.put("backgroundPosition", "${prefix}{background-position: ${val};}");
        map.put("backgroundSize", "${prefix}{background-size: ${val};}");
        map.put("backgroundRepeat", "${prefix}{background-repeat: ${val};}");
        map.put("boxShadow", "${prefix}{box-shadow:${val};}");
        map.put("virtualHeight", "${prefix}>.virtual-div-for-rows{height: ${val}; width: 100%;}");
        map.put("overflow", "dynamicStyleTemplate");
        return map;
    }

    public Map<String, String> propsTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isBorderRadius", "dynamicStyleTemplate");
        map.put("isShadow", "dynamicStyleTemplate");
        map.put("isBorder", "dynamicStyleTemplate");
        return map;
    }

    public static Function<Object, Object> dynamicStyleTemplate(String key) {
        HashMap<String, Function<Object, Object>> map = new HashMap<String, Function<Object, Object>>();
        map.put("isShadow", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix}{box-shadow: none}";
            }
            return "";
        });
        map.put("isBorderRadius", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix}{border-radius: unset}";
            }
            return "";
        });
        map.put("isBorder", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix}{border: none}";
            }
            return "";
        });
        map.put("overflow", value -> {
            if ("scroll".equals(value)) {
                return "${prefix}.jxd-horizontal-container-mobile{overflow: auto;}";
            }
            return "${prefix}.jxd-horizontal-container-mobile{height: fit-content;}";
        });
        return (Function)map.get(key);
    }

    public VoidVisitor visitor() {
        return new HorizontalContainerVisitor();
    }

    public static VantHorizontalContainer newComponent(JSONObject jsonObject) {
        VantHorizontalContainer vantHorizontalContainer = (VantHorizontalContainer)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)VantHorizontalContainer.class.getName()));
        Object backgroundImg = vantHorizontalContainer.getInnerStyles().get("backgroundImageBack");
        vantHorizontalContainer.getInnerStyles().remove("backgroundImageBack");
        vantHorizontalContainer.getInnerStyles().put("backgroundImage", backgroundImg);
        String minHeight = vantHorizontalContainer.getHeight().toString() + "px";
        vantHorizontalContainer.getStyles().put("min-height", minHeight);
        vantHorizontalContainer.setDisplay("flex");
        vantHorizontalContainer.getInnerStyles().put("virtualHeight", "0");
        return vantHorizontalContainer;
    }
}

