/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mobileui.vant;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.mobileui.vistor.GridContainerVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class MobileGridContainer
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.mobileui.JXDMobileGridContainer";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_mobileGridContainer");
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("itemGapColor", "${prefix} .jxd-grid-item:not(:nth-last-of-type(1)){border-right-color:${val};border-right-style: solid;}");
        map.put("itemStyle", "${prefix} .jxd-grid-item{position: ${val};box-sizing: border-box;}");
        map.put("display", "${prefix}.jxd_ins_mobileGridContainer{display: ${val};}");
        map.put("flexDirection", "${prefix}.jxd_ins_mobileGridContainer{flex-direction: ${val};}${prefix}.jxd_ins_mobileGridContainer .jxd-grid-item{flex: none; width: 100%;}");
        map.put("itemGap", "${prefix} .jxd-grid-item{border-right-width: ${val};}");
        map.put("vItemGap", "${prefix} .jxd-grid-item:not(:last-child){margin-bottom: ${val};}");
        map.put("col1", "${prefix} .col1{width: ${val};}");
        map.put("col2", "${prefix} .col2{width: ${val};}");
        map.put("col3", "${prefix} .col3{width: ${val};}");
        map.put("col4", "${prefix} .col4{width: ${val};}");
        map.put("col5", "${prefix} .col5{width: ${val};}");
        map.put("col6", "${prefix} .col6{width: ${val};}");
        map.put("col7", "${prefix} .col7{width: ${val};}");
        map.put("col8", "${prefix} .col8{width: ${val};}");
        map.put("col9", "${prefix} .col9{width: ${val};}");
        map.put("col10", "${prefix} .col10{width: ${val};}");
        map.put("col11", "${prefix} .col11{width: ${val};}");
        map.put("col12", "${prefix} .col12{width: ${val};}");
        return map;
    }

    public Map<String, String> propsTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isBorderNew", "dynamicStyleTemplate");
        map.put("isBorderRadiusNew", "dynamicStyleTemplate");
        map.put("isShadowNew", "dynamicStyleTemplate");
        return map;
    }

    public static Function<Object, Object> dynamicStyleTemplate(String key) {
        HashMap<String, Function<Object, Object>> map = new HashMap<String, Function<Object, Object>>();
        map.put("isBorderNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {border: none}";
            }
            return "";
        });
        map.put("isBorderRadiusNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {border-radius: unset}";
            }
            return "";
        });
        map.put("isShadowNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {box-shadow: none}";
            }
            return "";
        });
        return (Function)map.get(key);
    }

    public VoidVisitor visitor() {
        return new GridContainerVisitor();
    }

    public static MobileGridContainer newComponent(JSONObject jsonObject) {
        MobileGridContainer GridContainer = (MobileGridContainer)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)MobileGridContainer.class.getName()));
        GridContainer.getInnerStyles().put("itemStyle", "relative");
        GridContainer.getInnerStyles().put("display", "flex");
        Object isVertical = GridContainer.getProps().get("isVertical");
        if (ToolUtil.isNotEmpty(isVertical) && "true".equals(isVertical.toString())) {
            GridContainer.getInnerStyles().put("flexDirection", "column");
            GridContainer.getInnerStyles().put("vItemGap", GridContainer.getProps().get("itemGap") + "px");
        } else {
            JSONObject columnConfig = (JSONObject)GridContainer.getProps().get("columnConfig");
            Integer itemGap = (Integer)GridContainer.getProps().get("itemGap");
            GridContainer.getInnerStyles().put("itemGap", itemGap + "px");
            if (ToolUtil.isNotEmpty((Object)columnConfig) && ToolUtil.isNotEmpty((Object)itemGap) && ToolUtil.isNotEmpty((Object)columnConfig.get((Object)"totalRatio"))) {
                Integer totalRatio = (Integer)columnConfig.get((Object)"totalRatio");
                GridContainer.getInnerStyles().put("col1", "calc((100% - " + itemGap * (totalRatio - 1) + "px) * " + 1.0f / (float)totalRatio.intValue() + " + " + itemGap + "px)");
                GridContainer.getInnerStyles().put("col2", "calc((100% - " + itemGap * (totalRatio - 1) + "px) * " + 2.0f / (float)totalRatio.intValue() + " + " + itemGap * 2 + "px)");
                GridContainer.getInnerStyles().put("col3", "calc((100% - " + itemGap * (totalRatio - 1) + "px) * " + 3.0f / (float)totalRatio.intValue() + " + " + itemGap * 3 + "px)");
                GridContainer.getInnerStyles().put("col4", "calc((100% - " + itemGap * (totalRatio - 1) + "px) * " + 4.0f / (float)totalRatio.intValue() + " + " + itemGap * 4 + "px)");
                GridContainer.getInnerStyles().put("col5", "calc((100% - " + itemGap * (totalRatio - 1) + "px) * " + 5.0f / (float)totalRatio.intValue() + " + " + itemGap * 5 + "px)");
                GridContainer.getInnerStyles().put("col6", "calc((100% - " + itemGap * (totalRatio - 1) + "px) * " + 6.0f / (float)totalRatio.intValue() + " + " + itemGap * 6 + "px)");
                GridContainer.getInnerStyles().put("col7", "calc((100% - " + itemGap * (totalRatio - 1) + "px) * " + 7.0f / (float)totalRatio.intValue() + " + " + itemGap * 7 + "px)");
                GridContainer.getInnerStyles().put("col8", "calc((100% - " + itemGap * (totalRatio - 1) + "px) * " + 8.0f / (float)totalRatio.intValue() + " + " + itemGap * 8 + "px)");
                GridContainer.getInnerStyles().put("col9", "calc((100% - " + itemGap * (totalRatio - 1) + "px) * " + 9.0f / (float)totalRatio.intValue() + " + " + itemGap * 9 + "px)");
                GridContainer.getInnerStyles().put("col10", "calc((100% - " + itemGap * (totalRatio - 1) + "px) * " + 10.0f / (float)totalRatio.intValue() + " + " + itemGap * 10 + "px)");
                GridContainer.getInnerStyles().put("col11", "calc((100% - " + itemGap * (totalRatio - 1) + "px) * " + 11.0f / (float)totalRatio.intValue() + " + " + itemGap * 11 + "px)");
                GridContainer.getInnerStyles().put("col12", "calc((100% - " + itemGap * (totalRatio - 1) + "px) + " + itemGap * 12 + "px)");
            }
        }
        return GridContainer;
    }
}

