/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.publish;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.ScriptCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.impl.h5.H5PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ScriptPublisher;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendMobileWJsScript;
import com.jxdinfo.hussar.formdesign.extend.result.MobileJsScriptCodeResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;

@ClientKind(kind="com.jxdinfo.MobileJsScript.extend.publish")
public class MobileJsScriptPublishImpl
implements ScriptPublisher {
    public static final String KIND = "com.jxdinfo.MobileJsScript.extend.publish";
    private static FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
    private static final String JS_SUFFIX = ".js";

    public void publish(ScriptCtx<CodeResult> scriptCtx) throws LcdpException {
        BaseFile baseFile = scriptCtx.getBaseFile();
        ExtendMobileWJsScript extendWJsScript = (ExtendMobileWJsScript)((Object)JSON.parseObject((String)baseFile.getData(), ExtendMobileWJsScript.class));
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String modelPath = fileMappingService.getFormatParentPath(baseFile.getId());
        H5PathStrategyService h5PathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        String rootPath = FileUtil.systemPath((String[])new String[]{h5PathStrategy.h5PathService().getMobileFrontProjectPath(), h5PathStrategy.h5PathService().getExtendScriptPath()});
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        String path = FileUtil.systemPath((String[])new String[]{rootPath, formDesignProperties.getExtendJavaScriptPath(), modelPath, baseFile.getName() + JS_SUFFIX});
        if (HussarUtils.isNotEmpty((Object)extendWJsScript.getEditorNote())) {
            filePublishService.writeStringToFile(extendWJsScript.getEditorNote(), path, baseFile.getId());
        }
        MobileJsScriptCodeResult jsScriptCodeResult = new MobileJsScriptCodeResult();
        jsScriptCodeResult.setFilePath(path);
        jsScriptCodeResult.setResultType(ResultBeanEnum.JS_SCRIPT);
        jsScriptCodeResult.setId(baseFile.getId());
        scriptCtx.addGenCodeResults((CodeResult)jsScriptCodeResult);
    }
}

