/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.publish;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.ScriptCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.impl.h5.H5PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ScriptPublisher;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendMobileWVue;
import com.jxdinfo.hussar.formdesign.extend.result.MobileJsScriptCodeResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;

@ClientKind(kind="com.jxdinfo.MobileVueScript.extend.publish")
public class CustomMobileVuePublishImpl
implements ScriptPublisher {
    public static final String KIND = "com.jxdinfo.MobileVueScript.extend.publish";
    private static FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
    private static final String VUE_SUFFIX = ".vue";

    public void publish(ScriptCtx<CodeResult> scriptCtx) throws LcdpException {
        BaseFile baseFile = scriptCtx.getBaseFile();
        ExtendMobileWVue extendMobileWVue = (ExtendMobileWVue)((Object)JSON.parseObject((String)baseFile.getData(), ExtendMobileWVue.class));
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String modelPath = fileMappingService.getFormatParentPath(baseFile.getId());
        H5PathStrategyService h5PathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        String rootPath = FileUtil.systemPath((String[])new String[]{h5PathStrategy.h5PathService().getMobileFrontProjectPath(), h5PathStrategy.h5PathService().getExtendScriptPath()});
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        String path = FileUtil.systemPath((String[])new String[]{rootPath, formDesignProperties.getExtendVuePath(), modelPath, baseFile.getName() + VUE_SUFFIX});
        if (HussarUtils.isNotEmpty((Object)extendMobileWVue.getEditorNote())) {
            filePublishService.writeStringToFile(extendMobileWVue.getEditorNote(), path, baseFile.getId());
        }
        MobileJsScriptCodeResult mobileJsScriptCod = new MobileJsScriptCodeResult();
        mobileJsScriptCod.setFilePath(path);
        mobileJsScriptCod.setResultType(ResultBeanEnum.VUE_RESULT);
        mobileJsScriptCod.setId(baseFile.getId());
        scriptCtx.addGenCodeResults((CodeResult)mobileJsScriptCod);
    }
}

