/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.cascade;

import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.file.impl.h5.H5PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.ResourceCascadeService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.io.IOException;

@ClientKind(kind="com.jxdinfo.MobilePage.cascade")
public class MobileVueCascadeImpl
implements ResourceCascadeVisitor {
    public static final String KIND = "com.jxdinfo.MobilePage.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldfilePath = this.getOldVuePath(baseFile.getId(), strategy);
        String newFilePath = this.getNeWVuePath(baseFile.getId(), baseFile.getName(), strategy);
        File newFile = new File(newFilePath);
        File oldFile = new File(oldfilePath);
        if (FileUtils.exists((File)oldFile) && !FileUtils.exists((File)newFile)) {
            this.fixName(oldFile, newFile);
        }
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        H5PathStrategyService h5pathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        String path = fileMappingService.getFormatPath(baseFile.getId());
        String parentPath = fileMappingService.getFormatParentPath(baseFile.getId());
        String oldFileJsPath = h5pathStrategy.h5PathService().getMobileFrontProjectPath() + "/src/router/" + path + ".js";
        String newFileJsPath = h5pathStrategy.h5PathService().getMobileFrontProjectPath() + "/src/router/" + parentPath + File.separator + baseFile.getName() + ".js";
        oldFileJsPath = ToolUtil.pathFomatterByOS((String)oldFileJsPath);
        newFileJsPath = ToolUtil.pathFomatterByOS((String)newFileJsPath);
        File oldFileJs = new File(oldFileJsPath);
        File newFileJs = new File(newFileJsPath);
        if (FileUtils.exists((File)oldFileJs) && !FileUtils.exists((File)newFileJs)) {
            this.fixName(oldFileJs, newFileJs);
        }
    }

    public void cascadeCopy(String id, String newId, String newName, String parentId) throws LcdpException, IOException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String parentPath = this.getMetaPath(parentId);
        String oldVueFilePath = this.getOldVuePath(id, strategy);
        File vueFrom = new File(oldVueFilePath);
        H5PathStrategyService h5pathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        String rootPath = FileUtil.systemPath((String[])new String[]{h5pathStrategy.h5PathService().getMobileFrontProjectPath(), h5pathStrategy.h5PathService().getMobileVueCodePath(strategy)});
        File vueTo = new File(this.relativeToAbsolute(parentPath, rootPath));
        if (FileUtils.exists((File)vueFrom)) {
            if (!FileUtils.exists((File)vueTo)) {
                FileUtils.forceMkdir((File)vueTo);
            }
            if (newName != null && !newName.isEmpty()) {
                vueTo = new File(this.relativeToAbsolute(parentPath + File.separator + newName + formDesignProperties.getPageSuffix(), rootPath));
                if (!FileUtils.exists((File)vueTo)) {
                    try {
                        FileUtils.copyFile((File)vueFrom, (File)vueTo, (boolean)false);
                    }
                    catch (IOException e) {
                        throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, vueFrom.getAbsolutePath());
                    }
                }
            } else {
                try {
                    FileUtils.copyFileToDirectory((File)vueFrom, (File)vueTo, (boolean)false);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, vueFrom.getAbsolutePath());
                }
            }
        }
        this.copyAncestor(id, newId);
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String parentPath = this.getMetaPath(parentId);
        String oldVueFilePath = this.getOldVuePath(id, strategy);
        File vueFrom = new File(oldVueFilePath);
        H5PathStrategyService h5pathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        String rootPath = FileUtil.systemPath((String[])new String[]{h5pathStrategy.h5PathService().getMobileFrontProjectPath(), h5pathStrategy.h5PathService().getMobileVueCodePath(strategy)});
        File vueTo = new File(this.relativeToAbsolute(parentPath, rootPath));
        if (FileUtils.exists((File)vueFrom)) {
            if (!FileUtils.exists((File)vueTo)) {
                FileUtils.forceMkdir((File)vueTo);
            }
            if (newName != null && !newName.isEmpty()) {
                vueTo = new File(this.relativeToAbsolute(parentPath + File.separator + newName + formDesignProperties.getPageSuffix(), rootPath));
                if (!FileUtils.exists((File)vueTo)) {
                    try {
                        FileUtils.moveFile((File)vueFrom, (File)vueTo);
                    }
                    catch (IOException e) {
                        throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, vueFrom.getAbsolutePath());
                    }
                }
            } else {
                try {
                    FileUtils.moveFileToDirectory((File)vueFrom, (File)vueTo, (boolean)false);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, vueFrom.getAbsolutePath());
                }
            }
        }
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String path = fileMappingService.getFormatPath(id);
        String oldFileJsPath = h5pathStrategy.h5PathService().getMobileFrontProjectPath() + "/src/router/" + path + ".js";
        String newFileJsPath = h5pathStrategy.h5PathService().getMobileFrontProjectPath() + "/src/router/" + parentPath;
        oldFileJsPath = ToolUtil.pathFomatterByOS((String)oldFileJsPath);
        newFileJsPath = ToolUtil.pathFomatterByOS((String)newFileJsPath);
        File oldFileJs = new File(oldFileJsPath);
        File newFileJs = new File(newFileJsPath);
        if (FileUtils.exists((File)oldFileJs)) {
            if (!FileUtils.exists((File)newFileJs)) {
                FileUtils.forceMkdir((File)newFileJs);
            }
            if (newName != null && !newName.isEmpty()) {
                newFileJs = new File(ToolUtil.pathFomatterByOS((String)(newFileJsPath + File.separator + newName + ".js")));
                if (!FileUtils.exists((File)newFileJs)) {
                    try {
                        FileUtils.moveFile((File)oldFileJs, (File)newFileJs);
                    }
                    catch (IOException e) {
                        throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, oldFileJs.getAbsolutePath());
                    }
                }
            } else {
                try {
                    FileUtils.moveFileToDirectory((File)oldFileJs, (File)newFileJs, (boolean)false);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, oldFileJs.getAbsolutePath());
                }
            }
        }
    }

    void move() {
    }

    public void cascadeDelete(String id) throws LcdpException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldVueFilePath = this.getOldVuePath(id, strategy);
        File file = new File(oldVueFilePath);
        if (FileUtils.exists((File)file)) {
            try {
                FileUtils.forceDelete((File)file);
                ResourceCascadeService resourceCascadeService = (ResourceCascadeService)SpringContextUtil.getBean(ResourceCascadeService.class);
                resourceCascadeService.deleteVuePublishFile(id);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, oldVueFilePath);
            }
        }
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        H5PathStrategyService h5pathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        String path = fileMappingService.getFormatPath(id);
        String oldFileJsPath = h5pathStrategy.h5PathService().getMobileFrontProjectPath() + "/src/router/" + path + ".js";
        File oldFileJs = new File(oldFileJsPath = ToolUtil.pathFomatterByOS((String)oldFileJsPath));
        if (FileUtils.exists((File)oldFileJs)) {
            try {
                FileUtils.forceDelete((File)oldFileJs);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, oldFileJsPath);
            }
        }
    }

    String getOldVuePath(String id, Integer strategy) throws LcdpException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        H5PathStrategyService h5pathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        String oldVuePath = fileMappingService.getFormatPath(id);
        String localPrefix = FileUtil.systemPath((String[])new String[]{h5pathStrategy.h5PathService().getMobileFrontProjectPath(), h5pathStrategy.h5PathService().getMobileVueCodePath(strategy)});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{oldVuePath + formDesignProperties.getPageSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    String getNeWVuePath(String id, String pageName, Integer strategy) throws LcdpException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        H5PathStrategyService h5pathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        String localPrefix = FileUtil.systemPath((String[])new String[]{h5pathStrategy.h5PathService().getMobileFrontProjectPath(), h5pathStrategy.h5PathService().getMobileVueCodePath(strategy)});
        String newVuePath = FileUtil.systemPath((String[])new String[]{fileMappingService.getFormatParentPath(id), pageName});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{newVuePath + formDesignProperties.getPageSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    void copyAncestor(String oidId, String newId) throws IOException {
        String oldPublishPath = this.getPublishVersionFilePathById(oidId);
        String oldFilePath = this.getLastFileVersionFilePathById(oidId);
        File oldPublish = new File(oldPublishPath);
        File oldFile = new File(oldFilePath);
        File toPublish = new File(this.getPublishVersionFilePathById(newId));
        File toFile = new File(this.getLastFileVersionFilePathById(newId));
        if (FileUtils.exists((File)oldPublish) && FileUtils.exists((File)oldFile)) {
            FileUtils.copyFile((File)oldPublish, (File)toPublish, (boolean)false);
            FileUtils.copyFile((File)oldFile, (File)toFile, (boolean)false);
        }
    }

    String getPublishVersionFilePathById(String id) {
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        return FileUtil.posixPath((String[])new String[]{pathStrategy.resourcePathService().getProjectAndCodePath(), "/publish/version/ancestor", id.replace("_", "/"), "/last_publish.version"});
    }

    String getLastFileVersionFilePathById(String id) {
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        return FileUtil.posixPath((String[])new String[]{pathStrategy.resourcePathService().getProjectAndCodePath(), "/publish/version/ancestor", id.replace("_", "/"), "/last_file.version"});
    }

    protected boolean fixName(File oldFile, File newFile) {
        return FileUtils.fixName((File)oldFile, (File)newFile);
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String parentPath = (String)fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }
}

