/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.cascade;

import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.impl.h5.H5PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.io.IOException;

@ClientKind(kind="com.jxdinfo.MobileDataModelJs.cascade")
public class MobileModelJsCascadeImpl
implements ResourceCascadeVisitor {
    public static final String KIND = "com.jxdinfo.MobileDataModelJs.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException, IOException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldMobilefilePath = this.getOldMobileJSPath(baseFile.getId(), strategy);
        String newMobileFilePath = this.getNewMobileJSPath(baseFile.getId(), baseFile.getName(), strategy);
        File newMobileFile = new File(newMobileFilePath);
        File oldMobileFile = new File(oldMobilefilePath);
        if (FileUtils.exists((File)oldMobileFile) && !FileUtils.exists((File)newMobileFile)) {
            this.fixName(oldMobileFile, newMobileFile);
        }
    }

    public void cascadeCopy(String id, String newId, String newName, String parentPath) throws LcdpException, IOException {
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String parentPath = this.getMetaPath(parentId);
        String oldmobilefilePath = this.getOldMobileJSPath(id, strategy);
        File mobileJsFrom = new File(oldmobilefilePath);
        H5PathStrategyService h5PathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        String mobileRootPath = FileUtil.systemPath((String[])new String[]{h5PathStrategy.h5PathService().getMobileFrontProjectPath(), h5PathStrategy.h5PathService().getFrontApiPath()});
        File mobileJsTo = new File(this.relativeToAbsolute(parentPath, mobileRootPath));
        this.modelMove(mobileJsFrom, mobileJsTo, newName, parentPath, mobileRootPath);
    }

    public void modelMove(File jsFrom, File jsTo, String newName, String parentPath, String rootPath) throws IOException, LcdpException {
        if (FileUtils.exists((File)jsFrom)) {
            if (!FileUtils.exists((File)jsTo)) {
                FileUtils.forceMkdir((File)jsTo);
            }
            if (newName != null && !newName.isEmpty()) {
                jsTo = new File(this.relativeToAbsolute(parentPath + File.separator + newName + ".js", rootPath));
                if (!FileUtils.exists((File)jsTo)) {
                    try {
                        FileUtils.moveFile((File)jsFrom, (File)jsTo);
                    }
                    catch (IOException e) {
                        throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, jsFrom.getAbsolutePath());
                    }
                }
            } else {
                try {
                    FileUtils.moveFileToDirectory((File)jsFrom, (File)jsTo, (boolean)false);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, jsFrom.getAbsolutePath());
                }
            }
        }
    }

    public void cascadeDelete(String id) throws LcdpException {
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        Integer strategy = formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldmobileJSFilePath = this.getOldMobileJSPath(id, strategy);
        File mobilefile = new File(oldmobileJSFilePath);
        this.modelJsDel(mobilefile, oldmobileJSFilePath);
    }

    public void modelJsDel(File file, String oldJSFilePath) throws LcdpException {
        if (FileUtils.exists((File)file)) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, oldJSFilePath);
            }
        }
    }

    String getOldMobileJSPath(String id, Integer strategy) throws LcdpException {
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        H5PathStrategyService h5PathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        String oldJsPath = fileMappingService.getFormatPath(id);
        String localPrefix = FileUtil.systemPath((String[])new String[]{h5PathStrategy.h5PathService().getMobileFrontProjectPath(), h5PathStrategy.h5PathService().getFrontApiPath()});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{oldJsPath + formDesignProperties.getJsSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    String getNewMobileJSPath(String id, String pageName, Integer strategy) throws LcdpException {
        H5PathStrategyService h5PathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        String localPrefix = FileUtil.systemPath((String[])new String[]{h5PathStrategy.h5PathService().getMobileFrontProjectPath(), h5PathStrategy.h5PathService().getFrontApiPath()});
        String newJsPath = FileUtil.systemPath((String[])new String[]{fileMappingService.getFormatParentPath(id), pageName});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{newJsPath + formDesignProperties.getJsSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    protected boolean fixName(File oldFile, File newFile) {
        return FileUtils.fixName((File)oldFile, (File)newFile);
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String parentPath = (String)fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }
}

