/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mobileui.vistor;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PieEchartsVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        lcdpComponent.registerTemplatePath("/template/mobileui/vant/pieEcharts/pie_echarts.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String instanceKey = lcdpComponent.getInstanceKey();
        Integer height = lcdpComponent.getHeight();
        Integer width = lcdpComponent.getWidth();
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderTop"))) {
            String borderTop = String.valueOf(lcdpComponent.getStyles().get("borderTop"));
            ctx.addData(instanceKey + "BorderTop: " + borderTop.substring(0, borderTop.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderBottom"))) {
            String borderBottom = String.valueOf(lcdpComponent.getStyles().get("borderBottom"));
            ctx.addData(instanceKey + "BorderBottom: " + borderBottom.substring(0, borderBottom.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderLeft"))) {
            String borderLeft = String.valueOf(lcdpComponent.getStyles().get("borderLeft"));
            ctx.addData(instanceKey + "BorderLeft: " + borderLeft.substring(0, borderLeft.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderRight"))) {
            String borderRight = String.valueOf(lcdpComponent.getStyles().get("borderRight"));
            ctx.addData(instanceKey + "BorderRight: " + borderRight.substring(0, borderRight.indexOf("px")));
        }
        ctx.addData(instanceKey + "Height: " + height);
        ctx.addData(instanceKey + "Width: " + width);
        ctx.addData(instanceKey + "Data: null");
        lcdpComponent.addRenderParam("labelData", (Object)RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._X_AXIS_DATA.getType(), Collections.singletonList("label"), (String)"[]"));
        lcdpComponent.addRenderParam("valueData", (Object)RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix.SERIES_DATA.getType(), Collections.singletonList("value"), (String)"[]"));
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        Map echartsMaps;
        HashMap<String, CharSequence> echartsParams = new HashMap<String, CharSequence>();
        echartsParams.put("instanceKey", lcdpComponent.getInstanceKey());
        echartsParams.put("labelData", CodePrefix._SELF.getType() + lcdpComponent.getRenderParams().get("labelData"));
        echartsParams.put("valueData", CodePrefix._SELF.getType() + lcdpComponent.getRenderParams().get("valueData"));
        if (!ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("data")))) {
            echartsParams.put("isQuoteOrGetValue", "true");
        }
        if (ToolUtil.isNotEmpty((Object)(echartsMaps = lcdpComponent.getProps()))) {
            echartsParams.put("titleText", (CharSequence)echartsMaps.get("title"));
            echartsParams.put("titleColor", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("titleColor")) ? echartsMaps.get("titleColor") : "#000"));
            echartsParams.put("titleFontSize", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("titleFontSize")) ? echartsMaps.get("titleFontSize") : "18"));
            echartsParams.put("fontFamily", (CharSequence)echartsMaps.get("fontFamily"));
            echartsParams.put("fontStyle", (CharSequence)echartsMaps.get("fontStyle"));
            echartsParams.put("fontWeight", (CharSequence)echartsMaps.get("fontWeight"));
            echartsParams.put("titleAlign", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("titleAlign")) ? echartsMaps.get("titleAlign") : "center"));
            echartsParams.put("numberOfRow", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("numberOfRow")) ? echartsMaps.get("numberOfRow") : "10"));
            echartsParams.put("tooltipBgColor", (CharSequence)echartsMaps.get("tooltipBgColor"));
            echartsParams.put("toolColor", (CharSequence)echartsMaps.get("toolColor"));
            echartsParams.put("toolFontSize", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("toolFontSize")) ? echartsMaps.get("toolFontSize") : "18"));
            echartsParams.put("toolFontFamily", (CharSequence)echartsMaps.get("toolFontFamily"));
            echartsParams.put("toolFontWeight", (CharSequence)echartsMaps.get("toolFontWeight"));
            echartsParams.put("toolFontStyle", (CharSequence)echartsMaps.get("toolFontStyle"));
            echartsParams.put("isShowFlag", (CharSequence)echartsMaps.get("isShowFlag"));
            echartsParams.put("legendLocation", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("legendLocation")) ? echartsMaps.get("legendLocation") : "center"));
            echartsParams.put("legendIcon", (CharSequence)echartsMaps.get("legendIcon"));
            echartsParams.put("legendColor", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("legendColor")) ? echartsMaps.get("legendColor") : "#000000"));
            echartsParams.put("legendFontSize", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("legendFontSize")) ? echartsMaps.get("legendFontSize") : "14"));
            echartsParams.put("legendFontFamily", (CharSequence)echartsMaps.get("legendFontFamily"));
            echartsParams.put("legendFontWeight", (CharSequence)echartsMaps.get("legendFontWeight"));
            echartsParams.put("legendFontStyle", (CharSequence)echartsMaps.get("legendFontStyle"));
            DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
            DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
            if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
                DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
                Map dataSFieldAnalysisMap = dataSModelAnalysis.getFields();
                String labelField = "";
                String valueField = "";
                if (ToolUtil.isNotEmpty((Object)dataSFieldAnalysisMap)) {
                    for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                        List fieldAnalyses = (List)fieldList.getValue();
                        for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                            List dataItemPath = dataSFieldAnalysis.getDataItemPath();
                            if (ToolUtil.isNotEmpty((Object)dataItemPath) && "label".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                                labelField = dataSFieldAnalysis.getFieldName();
                            }
                            if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"value".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                            valueField = dataSFieldAnalysis.getFieldName();
                        }
                    }
                }
                if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)valueField)) {
                    String sortConditionName;
                    DataSortConditionAnalysis dataSortConditionAnalysis;
                    String querySelectionName;
                    List conditionList;
                    String operationName = "hussarQuery";
                    String apiFileName = "";
                    String apiFilePath = "";
                    String dataModelId = dataSModelAnalysis.getDataModelId();
                    if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                        apiFileName = this.fileMappingService.getFileName(dataModelId);
                        apiFilePath = this.fileMappingService.getMobileImportPath(dataModelId);
                    }
                    if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataSConditionAnalysis.getQueryConditionModelList()))) {
                        echartsParams.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                        echartsParams.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                    }
                    if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataSConditionAnalysis.getSelectCondition()))) {
                        operationName = operationName + querySelectionName;
                    }
                    if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                        operationName = operationName + sortConditionName;
                    }
                    if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                        EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                    }
                    echartsParams.put("importName", apiFileName);
                    echartsParams.put("importMethod", operationName);
                    echartsParams.put("xAxisCols", labelField);
                    echartsParams.put("seriesCols", valueField);
                }
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("n");
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderBottom", args, RenderUtil.renderTemplate((String)"/template/mobileui/vant/pieEcharts/pie_echarts_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderRight", args, RenderUtil.renderTemplate((String)"/template/mobileui/vant/pieEcharts/pie_echarts_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderLeft", args, RenderUtil.renderTemplate((String)"/template/mobileui/vant/pieEcharts/pie_echarts_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderTop", args, RenderUtil.renderTemplate((String)"/template/mobileui/vant/pieEcharts/pie_echarts_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "Height", args, RenderUtil.renderTemplate((String)"/template/mobileui/vant/pieEcharts/pie_echarts_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "Width", args, RenderUtil.renderTemplate((String)"/template/mobileui/vant/pieEcharts/pie_echarts_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "OptionData", args, RenderUtil.renderTemplate((String)"/template/mobileui/vant/pieEcharts/pie_echarts_watch.ftl", echartsParams));
            ctx.addComputed(lcdpComponent.getInstanceKey() + CodeSuffix._ECHARTS_DATA.getType(), RenderUtil.renderTemplate((String)"/template/mobileui/vant/pieEcharts/pie_echarts_computed.ftl", echartsParams), false, "");
            ctx.addWatch(lcdpComponent.getInstanceKey() + "EchartsData", args, RenderUtil.renderTemplate((String)"/template/mobileui/vant/pieEcharts/pie_echarts_watch.ftl", echartsParams));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "OptionItem", RenderUtil.renderTemplate((String)"/template/mobileui/vant/pieEcharts/pie_echarts_success.ftl", echartsParams));
            ctx.addMounted("this." + lcdpComponent.getInstanceKey() + "OptionItem();");
        }
    }
}

