/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.extend.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.file.impl.h5.H5PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVueInfo;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVuePathVO;
import com.jxdinfo.hussar.formdesign.extend.model.vue.ExtendCustomVueVO;
import com.jxdinfo.hussar.formdesign.extend.service.ExtendCustomVueService;
import com.jxdinfo.hussar.formdesign.extend.service.common.ExtendCustomVueCommonImpl;
import com.jxdinfo.hussar.formdesign.extend.util.ParsingUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl.BaseFileServiceImpl;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.IResultCode;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

@ClientKind(kind="com.jxdinfo.MobilePage.extend.vue")
public class ExtendMobileCustomVueServiceImpl
extends BaseFileServiceImpl<ExtendCustomVueInfo>
implements ExtendCustomVueService {
    private H5PathStrategyService h5PathStrategy = (H5PathStrategyService)SpringContextUtil.getBean(H5PathStrategyService.class);
    private PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
    private FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);

    public ApiResponse<List<ExtendCustomVuePathVO>> listVue() throws LcdpException, IOException {
        return ApiResponse.success((Object)ExtendCustomVueCommonImpl.listVue((String)this.pathStrategy.resourcePathService().getProjectAndCodePath(), (String)this.h5PathStrategy.h5PathService().getMobileFrontProjectPath(), (String)"MobilePage"));
    }

    public ApiResponse<Boolean> saveCustomVue(ExtendCustomVueInfo fileInfo) throws IOException, LcdpException {
        if (StringUtil.isNotBlank((CharSequence)fileInfo.getId()) && this.fileMappingService.isFileExist(fileInfo.getId())) {
            this.updateFile((BaseFile)fileInfo);
        } else if (StringUtil.isNotBlank((CharSequence)fileInfo.getFilePath())) {
            if (this.checkExists(fileInfo.getFilePath())) {
                return ApiResponse.fail((String)"\u8be5\u6587\u4ef6\u5df2\u6ce8\u518c");
            }
            this.create((BaseFile)fileInfo);
        } else {
            return ApiResponse.fail((String)"\u53c2\u6570\u7f3a\u5931");
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<ExtendCustomVueVO> getDetailById(String id) throws IOException, LcdpException {
        if (StringUtil.isBlank((CharSequence)id)) {
            return ApiResponse.fail((String)"\u53c2\u6570\u7f3a\u5931");
        }
        if (!this.fileMappingService.isFileExist(id)) {
            return ApiResponse.fail((String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return ApiResponse.success((Object)ExtendCustomVueCommonImpl.getCustomVueDetail((String)this.h5PathStrategy.h5PathService().getMobileFrontProjectPath(), (ExtendCustomVueInfo)((ExtendCustomVueInfo)this.get(id)), (String)"MobilePage"));
    }

    public ApiResponse<String> getVueContentByPath(String filePath) throws LcdpException {
        if (StringUtil.isEmpty((Object)filePath)) {
            return ApiResponse.fail((IResultCode)ResultCode.NO_EXIST_RESOURCE);
        }
        return ApiResponse.success((String)ExtendCustomVueCommonImpl.getVueContentByPath((String)this.h5PathStrategy.h5PathService().getMobileFrontProjectPath(), (String)filePath, (String)"MobilePage"));
    }

    private boolean checkExists(String filePath) throws LcdpException, IOException {
        String metaPath = this.pathStrategy.resourcePathService().getProjectAndCodePath();
        List metaList = ParsingUtil.getFilePath((String)metaPath, (String)".mcpd.meta");
        try {
            for (String path : metaList) {
                String content = FileUtils.readFileToString((File)new File(path), (String)"UTF-8");
                ExtendCustomVueInfo fileInfo = (ExtendCustomVueInfo)JSON.parseObject((String)content, ExtendCustomVueInfo.class);
                if (!filePath.replaceAll("\\\\", "/").equals(fileInfo.getFilePath().replaceAll("\\\\", "/")) || !fileInfo.getType().equals("MobileCustomPage")) continue;
                return true;
            }
        }
        catch (IOException e) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, filePath);
        }
        return false;
    }
}

