/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mobileui.vistor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.RootComponent;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.style.DefaultStyleCacheServiceImpl;
import com.jxdinfo.hussar.formdesign.codegenerator.core.model.CssFileModel;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.ExtendCommonUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.ExtendFormulaUtil;
import com.jxdinfo.hussar.formdesign.common.constant.SectionConstants;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.params.ComponentPageParams;
import com.jxdinfo.hussar.formdesign.common.model.variables.PageVariables;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.service.DefaultStyleCacheService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaCompileReferMethod;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.DefaultStyle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FrameworkVoidVisitor
implements VoidVisitor {
    private static DefaultStyleCacheService defaultStyleCacheService = (DefaultStyleCacheService)SpringUtil.getBean(DefaultStyleCacheServiceImpl.class);
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        this.renderState(lcdpComponent, ctx);
        RootComponent rootComponent = (RootComponent)lcdpComponent;
        rootComponent.initPageState();
        this.renderExtendScopedStyles(lcdpComponent, ctx);
        lcdpComponent.registerTemplatePath("/template/mobileui/vant/framework/framework.ftl");
        lcdpComponent.addRenderParam("datas", (Object)ctx.getDatas());
        lcdpComponent.addRenderParam("methods", (Object)ctx.getMethods());
        lcdpComponent.addRenderParam("watches", (Object)ctx.getWatches());
        lcdpComponent.addRenderParam("computeds", (Object)ctx.getComputeds());
        lcdpComponent.addRenderParam("computedWithGetSets", (Object)ctx.getComputedWithGetSets());
        lcdpComponent.addRenderParam("createds", (Object)ctx.getCreateds());
        lcdpComponent.addRenderParam("mounteds", (Object)ctx.getMounteds());
        lcdpComponent.addRenderParam("customMounteds", (Object)ctx.getCustomMountedStr());
        lcdpComponent.addRenderParam("destroyeds", (Object)ctx.getDestroyeds());
        lcdpComponent.addRenderParam("pageName", (Object)ctx.getPageName());
        lcdpComponent.addRenderParam("importScripts", (Object)ctx.getImports());
        lcdpComponent.addRenderParam("styles", (Object)ctx.getStyles());
        lcdpComponent.addRenderParam("extendScopedStyles", (Object)ctx.getExtendScopedStyles());
        lcdpComponent.addRenderParam("filters", (Object)ctx.getFilter());
        lcdpComponent.addRenderParam("components", (Object)ctx.getComponents());
        lcdpComponent.addRenderParam("rootInstanceKey", (Object)lcdpComponent.getInstanceKey());
        lcdpComponent.addRenderParam("directives", (Object)SectionConstants.VUE_DEFAULT_DIRECTIVES);
        lcdpComponent.addRenderParam("dicts", (Object)ctx.getDictInfo().getDicts());
        lcdpComponent.addRenderParam("optionLoads", (Object)ctx.getDictInfo().getOptionLoads());
        lcdpComponent.addRenderParam("levelDicts", (Object)ctx.getDictInfo().getLevelDicts());
        lcdpComponent.addRenderParam("treeLoads", (Object)ctx.getDictInfo().getTreeLoads());
        lcdpComponent.addRenderParam("dictMethod", (Object)"GET_DICT_BY_TYPES");
        lcdpComponent.addRenderParam("treeMethod", (Object)"GET_LEVEL_DICT_BY_TYPES");
        lcdpComponent.addRenderParam("customMethods", lcdpComponent.getProps().get("customMethods"));
        this.renderPageProps(lcdpComponent, ctx);
        this.renderImport(lcdpComponent, ctx);
        this.renderFlowData(lcdpComponent, ctx);
        this.renderOnload(lcdpComponent, ctx);
        this.renderPoll(lcdpComponent, ctx);
        this.renderRouter(ctx);
        this.renderPageVariables(ctx);
    }

    private void renderState(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String rootKey = ctx.getRootLcdpComponent().getInstanceKey();
        String commonStateMeName = ctx.getRootLcdpComponent().getInstanceKey() + "PageCommonStateMe";
        StringBuilder allState = new StringBuilder();
        allState.append(this.unsureMethod(commonStateMeName));
        ctx.addMethod(ctx.getRootLcdpComponent().getInstanceKey() + "PageAllStateMe", ToolUtil.isNotEmpty((Object)allState) ? allState.toString() : "", false, "\u9875\u9762\u72b6\u6001\u65b9\u6cd5");
        String bpmStateName = this.unsureMethod(rootKey + "BpmStateHandler");
        ctx.addMethod(ctx.getRootLcdpComponent().getInstanceKey() + "PageAllStateMe", ToolUtil.isNotEmpty((Object)bpmStateName) ? bpmStateName : "", false, "\u9875\u9762\u72b6\u6001\u65b9\u6cd5");
        StringBuilder stringBuilder = new StringBuilder();
        RootComponent rootComponent = (RootComponent)lcdpComponent;
        stringBuilder.append("const failButContinue = true;\n");
        stringBuilder.append("flowAuth.getOnlineConfig().then((res) => {\nif (res && res.msg === 'true') {\n");
        this.renderFlowAuth(lcdpComponent, ctx, stringBuilder);
        stringBuilder.append("} else {\n");
        Map states = rootComponent.getPageState();
        rootComponent.initPageState();
        if (ToolUtil.isNotEmpty((Object)states)) {
            stringBuilder.append(this.unsureMethod(ctx.getRootLcdpComponent().getInstanceKey() + "PageAllStateMe"));
        }
        stringBuilder.append(CodePrefix._SELF.getType() + "alreadyLoad = true;\n");
        stringBuilder.append("if(callBack && typeof callBack === 'function') {callBack();}");
        stringBuilder.append("}\n");
        if (ToolUtil.isNotEmpty((Object)states)) {
            for (Map.Entry state : states.entrySet()) {
                if (!((String)state.getKey()).equals("common")) continue;
                stringBuilder.append(this.unsureMethod(ctx.getRootLcdpComponent().getInstanceKey() + "PageAllStateMe"));
            }
        }
        stringBuilder.append("}).catch(() => {HussarRouterMobile.mobileFailMessage(self, '\u6570\u636e\u8bf7\u6c42\u5f02\u5e38');});");
        ArrayList<String> args = new ArrayList<String>(1);
        args.add("callBack");
        ctx.addMethod(ctx.getRootLcdpComponent().getInstanceKey() + "PageRenderAllState", args, ToolUtil.isNotEmpty((Object)stringBuilder) ? stringBuilder.toString() : "", false, "\u5de5\u4f5c\u6d41\u8868\u5355\u6743\u9650\u65b9\u6cd5");
        ctx.addCreated(CodePrefix._SELF.getType() + ctx.getRootLcdpComponent().getInstanceKey() + "PageRenderAllState" + "();");
    }

    private void renderExtendScopedStyles(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        if (lcdpComponent.getProps().get("cssFiles") != null) {
            List cssFileModels = JSON.parseArray((String)lcdpComponent.getProps().get("cssFiles").toString(), CssFileModel.class);
            for (CssFileModel cssFileModel : cssFileModels) {
                if (ToolUtil.isEmpty((Object)cssFileModel.getFileId())) continue;
                String path = FileUtil.posixPath((String[])new String[]{this.fileMappingService.getFormatPath(cssFileModel.getFileId())});
                ctx.addExtendScopedStyles("<style scoped src=\"" + ExtendCommonUtil.addExtendCSSImport((Ctx)ctx, (String)path) + "\"></style>");
            }
        }
    }

    private String unsureMethod(String methodName) {
        return "if(self." + methodName + "){self." + methodName + "();}";
    }

    private void renderFlowAuth(LcdpComponent lcdpComponent, Ctx ctx, StringBuilder stringBuilder) throws LcdpException {
        HashMap<String, Object> moduleMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)ctx.getStrategy())) {
            moduleMap.put("strategy", true);
        }
        ctx.addData("alreadyLoad: false", MultilineExegesisUtil.dealDataExegesis((String)"\u9875\u9762", (String)"alreadyLoad\u5c5e\u6027"));
        lcdpComponent.addRenderParam("isProduce", (Object)true);
        Map componentMap = ctx.getComponentMap();
        StringBuilder disableInstance = new StringBuilder();
        for (Map.Entry component : componentMap.entrySet()) {
            LcdpComponent value = (LcdpComponent)component.getValue();
            if (!ToolUtil.isNotEmpty((Object)value) || !"com.jxdinfo.mobileui.JXDMobileForm".equals(value.getName())) continue;
            String data = value.getInstanceKey() + "Disabled";
            disableInstance.append("self." + data + " = true;");
        }
        moduleMap.put("disableInstanceKey", disableInstance.toString());
        ctx.addImports("*", "flowAuth", "@/api/bpm/flowAuth");
        String dataArrayStr = RenderUtil.renderTemplate((String)"template/mobileui/vant/framework/FlowAuthConfig.ftl", moduleMap);
        stringBuilder.append(dataArrayStr);
    }

    private void renderFlowData(LcdpComponent lcdpComponent, Ctx ctx) {
        Map renderMap = lcdpComponent.getRenderParams();
        for (String key : renderMap.keySet()) {
            if (!ToolUtil.isNotEmpty((Object)key) || !key.contains("addFlowFileData")) continue;
            ctx.addData(lcdpComponent.getInstanceKey() + "ShowFlowFile: false,", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u6d41\u7a0b\u56feShowFlowFile\u5c5e\u6027"));
            ctx.addData(lcdpComponent.getInstanceKey() + "ShowPicProcessKey: '',", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u6d41\u7a0b\u56feshowPicProcessKey\u5c5e\u6027"));
            ctx.addImports("import { flowfile } from 'BpmShowWorkflow'");
            ctx.addComponent("flowfile");
            break;
        }
        for (String key : renderMap.keySet()) {
            if (!ToolUtil.isNotEmpty((Object)key) || !key.contains("addFlowFileDataDialog")) continue;
            ctx.addData(lcdpComponent.getInstanceKey() + "ShowFlowFileDialog: false,", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u6d41\u7a0b\u56feshowPicProcessKey\u5c5e\u6027"));
            ctx.addData(lcdpComponent.getInstanceKey() + "ShowPicProcessKey: '',", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u6d41\u7a0b\u56feshowPicProcessKey\u5c5e\u6027"));
            ctx.addImports("import { flowfile } from 'BpmShowWorkflow'");
            ctx.addComponent("flowfile");
            break;
        }
    }

    private void renderImport(LcdpComponent lcdpComponent, Ctx ctx) {
        List formulaReferJsList;
        List customFunctionList = (List)lcdpComponent.getProps().get("customFunction");
        if (ToolUtil.isNotEmpty((Object)customFunctionList)) {
            for (Map stringObjectMap : customFunctionList) {
                Boolean exportDefault = stringObjectMap.get("exportDefault") == null ? false : (Boolean)stringObjectMap.get("exportDefault");
                Object importStr = "import ";
                if (!exportDefault.booleanValue()) {
                    importStr = "import * as ";
                }
                String fileIdentify = String.valueOf(stringObjectMap.get("fileIdentify"));
                importStr = (String)importStr + fileIdentify + " from '";
                String filePath = String.valueOf(stringObjectMap.get("functionPath"));
                importStr = (String)importStr + filePath + "'";
                ctx.addImports((String)importStr);
            }
        }
        if (ToolUtil.isNotEmpty((Object)(formulaReferJsList = ExtendFormulaUtil.getFormulaCompileReferJs((Ctx)ctx))) && ToolUtil.isNotEmpty((Object)formulaReferJsList)) {
            for (ExtendFormulaCompileReferMethod referMethod : formulaReferJsList) {
                if (!ToolUtil.isNotEmpty((Object)referMethod.getMethods())) continue;
                for (String method : referMethod.getMethods()) {
                    ctx.addImports(method, referMethod.getPath());
                }
            }
        }
        for (LcdpComponent component : ctx.getComponentMap().values()) {
            DefaultStyle defaultStyles = defaultStyleCacheService.get(component.getName());
            if (!ToolUtil.isNotEmpty((Object)defaultStyles.getProps()) || !ToolUtil.isNotEmpty(defaultStyles.getProps().get("isEChart")) || !((Boolean)defaultStyles.getProps().get("isEChart")).booleanValue()) continue;
            ctx.addImports("*", "elementResizeDetectorMaker", "element-resize-detector");
            String mountedStr = "const ERD = elementResizeDetectorMaker();";
            if (!component.isVerticalFill() && !component.isHorizontalFill()) continue;
            ctx.addMounted(mountedStr);
            return;
        }
    }

    private void renderOnload(LcdpComponent lcdpComponent, Ctx ctx) {
        Map mountedMap = ctx.getMethods();
        for (String key : mountedMap.keySet()) {
            if (!ToolUtil.isNotEmpty((Object)key) || !key.contains(lcdpComponent.getInstanceKey() + "Onload")) continue;
            lcdpComponent.addRenderParam("isOnload", (Object)true);
            break;
        }
    }

    private void renderPageProps(LcdpComponent lcdpComponent, Ctx ctx) {
        boolean hasPageInfo = ToolUtil.isNotEmpty((Object)ctx.getPageInfo());
        ArrayList paramList = new ArrayList();
        if (hasPageInfo && ToolUtil.isNotEmpty((Object)ctx.getPageInfo().getComponentParams())) {
            List params = ctx.getPageInfo().getComponentParams();
            for (ComponentPageParams entry : params) {
                String paramName = entry.getParamName();
                String paramDataType = entry.getParamDataType();
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("paramName", paramName);
                paramMap.put("paramDataType", paramDataType);
                paramList.add(paramMap);
            }
        }
        lcdpComponent.addRenderParam("props", paramList);
    }

    private void renderPoll(LcdpComponent lcdpComponent, Ctx ctx) {
        Map mountedMap = ctx.getMethods();
        ArrayList<String> destroyPolls = new ArrayList<String>();
        boolean pollSwitchMethod = false;
        for (String key : mountedMap.keySet()) {
            if (!ToolUtil.isNotEmpty((Object)key) || !key.contains(lcdpComponent.getInstanceKey() + "PollName")) continue;
            pollSwitchMethod = true;
            ctx.addData(key + "Destroy: null", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"destroy\u5c5e\u6027"));
            destroyPolls.add(key + "Destroy");
        }
        lcdpComponent.addRenderParam("destroyPolls", destroyPolls);
        lcdpComponent.addRenderParam("pollSwitchMethod", (Object)pollSwitchMethod);
        lcdpComponent.addRenderParam("pollSwitch", lcdpComponent.getProps().get("pollSwitch"));
        lcdpComponent.addRenderParam("polls", lcdpComponent.getProps().get("polls"));
    }

    private void renderRouter(Ctx ctx) {
        ctx.addImports("import * as HussarRouterMobile from '@/utils/HussarRouterMobile'");
        ctx.addImports("import * as HussarRouter from '@/utils/HussarRouter'");
    }

    private void renderPageVariables(Ctx ctx) {
        if (ToolUtil.isNotEmpty((Object)ctx.getPageInfo().getPageVariables())) {
            List pageVariables = ctx.getPageInfo().getPageVariables();
            for (PageVariables pageVariable : pageVariables) {
                if (!ToolUtil.isNotEmpty((Object)pageVariable) || !ToolUtil.isNotEmpty((Object)pageVariable.getVariablesName()) || !ToolUtil.isNotEmpty((Object)pageVariable.getVariablesDataType())) continue;
                String variablesDataType = pageVariable.getVariablesDataType();
                String dataName = pageVariable.getVariablesName() + ":";
                if (ToolUtil.isNotEmpty((Object)pageVariable.getDefaultValue())) {
                    JSONObject defaultValueAnalysis = (JSONObject)pageVariable.getDefaultValue();
                    String configData1 = defaultValueAnalysis.getJSONObject("from").toString();
                    ComponentReference reference = (ComponentReference)JSON.parseObject((String)configData1, ComponentReference.class);
                    String result = "''";
                    if (DataFromEnum.INPUT.getValue().equals(reference.getType()) && ToolUtil.isEmpty((Object)reference.getDataType())) {
                        reference.setDataType("string");
                    }
                    try {
                        ComponentData fromComponentData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)reference);
                        if (ToolUtil.isNotEmpty((Object)fromComponentData)) {
                            result = fromComponentData.getRenderValue();
                        }
                    }
                    catch (LcdpException e) {
                        e.printStackTrace();
                    }
                    dataName = dataName + result;
                } else {
                    dataName = variablesDataType.equals("string") || variablesDataType.equals("date") ? dataName + "''" : (variablesDataType.equals("double") || variablesDataType.equals("int") ? dataName + 0 : (variablesDataType.equals("boolean") ? dataName + "false" : (variablesDataType.equals("object") ? dataName + "{}" : dataName + "[]")));
                }
                String desc = "\u9875\u9762\u53d8\u91cf";
                desc = ToolUtil.isNotEmpty((Object)pageVariable.getVariablesDesc()) ? pageVariable.getVariablesDesc() + "\uff08\u9875\u9762\u53d8\u91cf\uff09" : pageVariable.getVariablesName() + "\uff08\u9875\u9762\u53d8\u91cf\uff09";
                ctx.addData(dataName, desc);
            }
        }
    }
}

