/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.cascade;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.file.impl.h5.H5PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import java.io.File;
import java.io.IOException;

@ClientKind(kind="com.jxdinfo.MobileModule.cascade")
public class MobileModuleCascadeImpl
implements ResourceCascadeVisitor {
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    private final H5PathStrategyService h5pathStrategy = (H5PathStrategyService)SpringContextHolder.getBean(H5PathStrategyService.class);
    private final PathStrategyService pathStrategy = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);
    public static final String KIND = "com.jxdinfo.MobileModule.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String mobilerootPath = FileUtil.systemPath((String[])new String[]{this.h5pathStrategy.h5PathService().getMobileFrontProjectPath(), this.h5pathStrategy.h5PathService().getMobileVueCodePath(strategy)});
        String mobilepath = this.getMetaPath(baseFile.getId());
        String mobileparentPath = this.getMetaPath(baseFile.getParentId());
        File mobilenewFile = new File(this.relativeToAbsolute(mobileparentPath + File.separator + baseFile.getName(), mobilerootPath));
        File mobileoldFile = new File(FileUtil.systemPath((String[])new String[]{mobilerootPath, mobilepath}));
        this.moduleEdit(mobileoldFile, mobilenewFile);
        File code = new File(FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().getProjectAndCodePath(), mobilepath}));
        this.iteratorMobileFile(code);
        String mobileapiRootPath = FileUtil.systemPath((String[])new String[]{this.h5pathStrategy.h5PathService().getMobileFrontProjectPath(), this.h5pathStrategy.h5PathService().getFrontApiPath()});
        String mobileapiPath = this.getMetaPath(baseFile.getId());
        String mobileapiParentPath = this.getMetaPath(baseFile.getParentId());
        File mobileapiNewFile = new File(this.relativeToAbsolute(mobileapiParentPath + File.separator + baseFile.getName(), mobileapiRootPath));
        File mobileapiOldFile = new File(FileUtil.systemPath((String[])new String[]{mobileapiRootPath, mobileapiPath}));
        this.moduleEdit(mobileapiOldFile, mobileapiNewFile);
        String mobileextendRootPath = FileUtil.systemPath((String[])new String[]{this.h5pathStrategy.h5PathService().getMobileFrontProjectPath(), this.h5pathStrategy.h5PathService().getExtendScriptPath()});
        File mobileextendnewFile = new File(mobileextendRootPath);
        this.iteratorDirectory(mobileextendnewFile, baseFile, this.fileMappingService.getFileName(baseFile.getId()));
    }

    public void iteratorDirectory(File extendnewFile, BaseFile baseFile, String oldName) {
        if (ToolUtil.isNotEmpty((Object)extendnewFile) && ToolUtil.isNotEmpty((Object)FileUtils.listFiles((File)extendnewFile))) {
            for (File file : FileUtils.listFiles((File)extendnewFile)) {
                if (!FileUtils.isDirectory((File)file)) continue;
                if (file.getName().equals(oldName)) {
                    File newFile = new File(file.getParent() + File.separator + baseFile.getName());
                    if (FileUtils.exists((File)newFile)) continue;
                    this.fixName(file, newFile);
                    continue;
                }
                this.iteratorDirectory(file, baseFile, oldName);
            }
        }
    }

    public void moduleEdit(File oldFile, File newFile) {
        if (FileUtils.exists((File)oldFile) && !FileUtils.exists((File)newFile)) {
            this.fixName(oldFile, newFile);
        }
    }

    public void cascadeCopy(String id, String newId, String newName, String parentId) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String mobilerootPath = FileUtil.systemPath((String[])new String[]{this.h5pathStrategy.h5PathService().getMobileFrontProjectPath(), this.h5pathStrategy.h5PathService().getMobileVueCodePath(strategy)});
        String path = this.getMetaPath(id);
        String parentPath = this.getMetaPath(parentId);
        File from = new File(FileUtil.systemPath((String[])new String[]{mobilerootPath, path}));
        File to = new File(this.relativeToAbsolute(parentPath + File.separator + newName, mobilerootPath));
        if (parentPath.contains(path) && parentPath.length() > path.length()) {
            throw new LcdpException(LcdpExceptionEnum.BAN_FOLDER, path);
        }
        if (FileUtils.exists((File)from)) {
            if (!FileUtils.exists((File)to)) {
                FileUtils.forceMkdir((File)to);
            }
            FileUtils.copyDirectoryToDirectory((File)from, (File)to);
        }
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String mobilerootPath = FileUtil.systemPath((String[])new String[]{this.h5pathStrategy.h5PathService().getMobileFrontProjectPath(), this.h5pathStrategy.h5PathService().getMobileVueCodePath(strategy)});
        String mobileparentPath = this.getMetaPath(parentId);
        this.moveFrontFile(id, mobileparentPath, mobilerootPath, newName, parentId);
        File code = new File(FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().getProjectAndCodePath(), this.getMetaPath(id)}));
        this.iteratorMobileFile(code);
        String mobileapiRootPath = FileUtil.systemPath((String[])new String[]{this.h5pathStrategy.h5PathService().getMobileFrontProjectPath(), this.h5pathStrategy.h5PathService().getFrontApiPath()});
        String mobileapiParentPath = this.getMetaPath(parentId);
        this.moveFrontFile(id, mobileapiParentPath, mobileapiRootPath, newName, parentId);
    }

    public void moveFrontFile(String id, String parentPath, String rootPath, String newName, String parentId) throws LcdpException, IOException {
        String path = this.getMetaPath(id);
        File from = new File(FileUtil.systemPath((String[])new String[]{rootPath, path}));
        File to = new File(this.relativeToAbsolute(parentPath + File.separator + newName, rootPath));
        if (parentPath.contains(path) && (id.equals(parentId) || this.copyCheck(id, parentId))) {
            throw new LcdpException(LcdpExceptionEnum.BAN_FOLDER, path);
        }
        if (FileUtils.exists((File)from)) {
            if (!FileUtils.exists((File)to)) {
                FileUtils.moveDirectory((File)from, (File)to);
            } else {
                FileUtils.moveDirectoryToDirectory((File)from, (File)to, (boolean)false);
            }
        }
    }

    private boolean copyCheck(String id, String parentId) throws IOException, LcdpException {
        BaseFile baseFile = this.fileMappingService.getPageInfoById(parentId);
        if (ToolUtil.isNotEmpty((Object)baseFile) && !"#".equals(baseFile.getParentId())) {
            if (id.equals(baseFile.getId())) {
                return true;
            }
            return this.copyCheck(id, baseFile.getParentId());
        }
        return false;
    }

    public void cascadeDelete(String id) throws LcdpException, IOException {
        Integer strategy;
        Integer n = strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        if (ToolUtil.isEmpty((Object)id)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        String path = this.getMetaPath(id);
        String mobilerootPath = FileUtil.systemPath((String[])new String[]{this.h5pathStrategy.h5PathService().getMobileFrontProjectPath(), this.h5pathStrategy.h5PathService().getMobileVueCodePath(strategy)});
        File mobilef = new File(this.relativeToAbsolute(path, mobilerootPath));
        this.moduleDelete(mobilef);
        String mobileapiRootPath = FileUtil.systemPath((String[])new String[]{this.h5pathStrategy.h5PathService().getMobileFrontProjectPath(), this.h5pathStrategy.h5PathService().getFrontApiPath()});
        File mobileapif = new File(this.relativeToAbsolute(path, mobileapiRootPath));
        this.moduleDelete(mobileapif);
        String mobileextendRootPath = FileUtil.systemPath((String[])new String[]{this.h5pathStrategy.h5PathService().getMobileFrontProjectPath(), this.h5pathStrategy.h5PathService().getExtendScriptPath()});
        this.extendModuleDelete(mobileextendRootPath, path);
        File code = new File(FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().getProjectAndCodePath(), path}));
        this.iteratorMobileFile(code);
    }

    private void moduleDelete(File f) throws LcdpException {
        if (FileUtils.exists((File)f)) {
            try {
                FileUtils.forceDelete((File)f);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.DIRECTORY_DELETE_FAIL, f.getAbsolutePath());
            }
        }
    }

    private void extendModuleDelete(String rootPath, String path) throws LcdpException {
        String jsPath = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendJavaScriptPath(), path});
        this.moduleDelete(new File(jsPath));
        String vuePath = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendVuePath(), path});
        this.moduleDelete(new File(vuePath));
        String cssPath = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendCssScriptPath(), path});
        this.moduleDelete(new File(cssPath));
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }

    private void iteratorMobileFile(File file) throws IOException, LcdpException {
        block6: {
            block7: {
                if (!FileUtils.exists((File)file)) break block6;
                if (!FileUtils.isDirectory((File)file)) break block7;
                File[] files = file.listFiles();
                if (files == null) break block6;
                for (File childFile : files) {
                    this.iteratorMobileFile(childFile);
                }
                break block6;
            }
            if (file.getName().endsWith(".meta")) {
                JSONObject jsonObject = null;
                jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"));
                String id = jsonObject.get((Object)"id").toString();
                String type = jsonObject.get((Object)"type").toString();
                String parentId = jsonObject.get((Object)"parentId").toString();
                if ("MobilePage".equals(type)) {
                    String path = this.fileMappingService.getFormatParentPath(id);
                    String oldFileJsPath = this.h5pathStrategy.h5PathService().getMobileFrontProjectPath() + "/src/router/" + path;
                    File oldFileJs = new File(oldFileJsPath = ToolUtil.pathFomatterByOS((String)oldFileJsPath));
                    if (FileUtils.exists((File)oldFileJs)) {
                        try {
                            FileUtils.forceDelete((File)oldFileJs);
                        }
                        catch (IOException e) {
                            throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, oldFileJsPath);
                        }
                    }
                }
            }
        }
    }

    protected boolean fixName(File oldFile, File newFile) {
        return FileUtils.fixName((File)oldFile, (File)newFile);
    }
}

