/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.CodePublishTool;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.VueCodeGenerateService;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.result.VueCodeResult;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatResult;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatter;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.CodePublisher;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.StyleScheme;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeBaseConfig;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeVars;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.model.MergeResult;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.theme.config.service.IHussarThemeConfigService;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@ClientKind(kind="com.jxdinfo.MobilePage.publish")
public class H5CodePublishImpl
implements CodePublisher {
    public static final String KIND = "com.jxdinfo.MobilePage.publish";
    private final VersionManageService versionManageService = (VersionManageService)SpringContextHolder.getBean(VersionManageService.class);
    private final FilePublishService filePublishService = (FilePublishService)SpringContextHolder.getBean(FilePublishService.class);
    private final CodeMergeService codeMergeService = (CodeMergeService)SpringContextHolder.getBean(CodeMergeService.class);
    private final VueCodeGenerateService vueCodeGenerateService = (VueCodeGenerateService)SpringContextHolder.getBean(VueCodeGenerateService.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    private final ResourcePathService resourcePathService = (ResourcePathService)SpringContextHolder.getBean(ResourcePathService.class);
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final IHussarThemeConfigService iHussarThemeConfigService = (IHussarThemeConfigService)SpringContextHolder.getBean(IHussarThemeConfigService.class);
    private final CodePublishTool codePublishTool = (CodePublishTool)SpringContextHolder.getBean(CodePublishTool.class);
    public static final String JS = ".js";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void publish(PublishCtx<CodeResult> publishCtx, ThemeVars themeVars) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        Boolean isPublishInPages = this.formDesignProperties.isPublishInPages();
        PageInfo pageInfo = (PageInfo)publishCtx.getBaseFile();
        String projectPath = this.formDesignProperties.getMobProjectPath();
        String id = pageInfo.getId();
        String moduleRelatePath = this.fileMappingService.getFormatParentPath(pageInfo.getId());
        moduleRelatePath = moduleRelatePath.startsWith("/") ? moduleRelatePath : "/" + moduleRelatePath;
        moduleRelatePath = moduleRelatePath.endsWith("/") ? moduleRelatePath : moduleRelatePath + "/";
        String pageName = pageInfo.getName();
        String pageInfoDataJson = pageInfo.getData();
        JSONObject pageInfoDataJsonObject = JSON.parseObject((String)pageInfoDataJson);
        StyleScheme styleScheme = this.iHussarThemeConfigService.getCurrentSysThemeInfo();
        ThemeBaseConfig themeBaseConfig = styleScheme.getThemeBase().getMobilePage();
        Map scssVars = styleScheme.getScssVars().getMobilePage();
        CodeFormatResult codeFormatResult = this.vueCodeGenerateService.vueGenerate(pageInfoDataJsonObject, pageName, pageInfo, themeVars.getMobilePage(), strategy, themeBaseConfig, scssVars);
        String newContent = codeFormatResult.getCodeFormatCode();
        String projectPagePath = this.mobileProjectVue(this.formDesignProperties.getMobProjectPath(), this.fileMappingService.getFormatPath(id) + this.formDesignProperties.getPageSuffix()).getLocalPath();
        if (!codeFormatResult.isSucceed()) {
            VueCodeResult codeResult = new VueCodeResult();
            codeResult.setId(id);
            codeResult.setNewCode(newContent);
            codeResult.setFilePath(projectPagePath);
            codeResult.setCodeFormatSucceed(codeFormatResult.isSucceed());
            codeResult.setCodeFormatMessages(codeFormatResult.getMessages());
            codeResult.setMsg(codeFormatResult.getMsg());
            publishCtx.addCodeResult((CodeResult)codeResult);
            return;
        }
        newContent = CodeSplitUtil.removeEmptyLines((String)newContent);
        this.filePublishService.writePublishSourceToCache(id, "mobile");
        Optional<String> ancestorContent = Optional.ofNullable(this.versionManageService.getAncestorCodeById(id));
        Optional<String> lastFileContent = Optional.ofNullable(this.versionManageService.getLastFileCode(id));
        String pagePath = this.mobileProjectVue(projectPath, moduleRelatePath, pageName + this.formDesignProperties.getPageSuffix()).getLocalPath();
        Optional<String> currentContent = Optional.ofNullable(this.filePublishService.readCurrentPublishedFile(pagePath));
        if (ancestorContent.isPresent() && currentContent.isPresent()) {
            MergeResult mergeResult;
            boolean isConflict;
            String lastPulishCode = ancestorContent.get();
            String currentFileCode = currentContent.get();
            if (this.formDesignProperties.isLocalCodeFormatter()) {
                CodeFormatResult lastPublishResult = CodeFormatter.formatterHtml((String)ancestorContent.get(), (String)"vue");
                lastPulishCode = lastPublishResult.getCodeFormatCode();
                CodeFormatResult currentFileResult = CodeFormatter.formatterHtml((String)currentContent.get(), (String)"vue");
                currentFileCode = currentFileResult.getCodeFormatCode();
            }
            String lastFile = "";
            if (lastFileContent.isPresent()) {
                lastFile = lastFileContent.get();
            }
            if (!(isConflict = (mergeResult = this.codeMergeService.structuralMerge(pagePath, ExtractFileType.VUE, lastPulishCode, currentFileCode, newContent, lastFile, true)).isConflict())) {
                try {
                    this.genMobileCode(id, moduleRelatePath, pageName, pageInfo, mergeResult.getMergedCode(), projectPath, strategy, isPublishInPages);
                    this.codePublishTool.delayWrite(id);
                    if (strategy == null && !isPublishInPages.booleanValue()) return;
                    this.compile(projectPath, moduleRelatePath, pageName);
                    return;
                }
                finally {
                    this.versionManageService.saveLastPublishCode(id, newContent);
                    this.versionManageService.saveLastFileCode(id, mergeResult.getMergedCode());
                }
            } else {
                this.codePublishTool.assembleCode(id, publishCtx, newContent, currentContent, mergeResult, projectPagePath);
            }
            return;
        }
        try {
            newContent = CodeSplitUtil.removeEmptyLines((String)newContent);
            this.genMobileCode(id, moduleRelatePath, pageName, pageInfo, newContent, projectPath, strategy, isPublishInPages);
            return;
        }
        finally {
            this.versionManageService.saveLastPublishCode(id, newContent);
            this.versionManageService.saveLastFileCode(id, newContent);
            this.codePublishTool.delayWrite(id);
            if (strategy != null || isPublishInPages.booleanValue()) {
                this.compile(projectPath, moduleRelatePath, pageName);
            }
        }
    }

    private void genMobileCode(String id, String moduleRelatePath, String pageName, PageInfo pageInfo, String fileContent, String mobilePath, Integer strategy, Boolean isPublishInPages) throws LcdpException, IOException {
        String projectPath = this.mobileProject(mobilePath, new String[0]).getLocalPath();
        String vueRootPath = projectPath + File.separator + "src" + File.separator + "views";
        this.writeMobileCode(fileContent, moduleRelatePath, pageName, vueRootPath, id);
        if (this.formDesignProperties.isLocalUnReset() || isPublishInPages.booleanValue()) {
            vueRootPath = projectPath + File.separator + "src" + File.separator + "pages";
            this.writeMobileCode(fileContent, moduleRelatePath, pageName, vueRootPath, id);
        }
        if (!this.formDesignProperties.isLocalUnReset()) {
            String path = FileUtil.posixPath((String[])new String[]{this.fileMappingService.getFormatPath(id)});
            String component = FileUtil.posixPath((String[])new String[]{"@/views", moduleRelatePath, pageName});
            String desc = pageInfo.getDesc();
            String routerExport = "export default {\n   path: '" + path + "',\n   component: () => import('" + component + "'),\n   name: '" + pageName + "',\n   meta: {title: '" + desc + "'}\n}";
            this.writeMobileRouterCode(routerExport, moduleRelatePath, pageName, projectPath, id);
        }
    }

    private void writeMobileRouterCode(String fileContent, String modulePath, String pageName, String vueRootPath, String pageId) throws IOException {
        vueRootPath = FileUtil.complementFilePath((String)vueRootPath);
        modulePath = FileUtil.complementFilePath((String)modulePath);
        String filePath = vueRootPath + "/src/router/" + modulePath + pageName + JS;
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        this.filePublishService.writeStringToFile(fileContent, filePath, pageId);
    }

    private void writeMobileCode(String fileContent, String modulePath, String pageName, String vueRootPath, String pageId) throws IOException {
        vueRootPath = FileUtil.complementFilePath((String)vueRootPath);
        modulePath = FileUtil.complementFilePath((String)modulePath);
        String filePath = vueRootPath + modulePath + pageName + this.formDesignProperties.getPageSuffix();
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        this.filePublishService.writeStringToFile(fileContent, filePath, pageId);
    }

    private void compile(String projectPath, String moduleRelatePath, String pageName) throws LcdpException {
        HashMap<String, String> compileParams = new HashMap<String, String>();
        String pageJSName = "__" + pageName;
        String tmpCompileJsPath = this.mobileProject(projectPath, File.separator + "src" + File.separator + "pages", moduleRelatePath, pageJSName + JS).getLocalPath();
        String pageType = "pages";
        String publishVueRelativePath = FileUtil.posixPath((String[])new String[]{"@/" + pageType, AppContextUtil.posixFilePathPrefix(), moduleRelatePath, pageName});
        if (ToolUtil.isNotEmpty((Object)moduleRelatePath)) {
            moduleRelatePath = moduleRelatePath.substring(0, 1).equals("/") ? moduleRelatePath.substring(1) : moduleRelatePath;
        }
        String tmpCompileJs = ToolUtil.loadResource(this.getClass(), (String)"/template/mobileTemplate.js");
        tmpCompileJs = tmpCompileJs.replace("${vuePath}", publishVueRelativePath);
        this.filePublishService.writeStringToFile(tmpCompileJs, tmpCompileJsPath);
        if (this.formDesignProperties.isLocalUnReset()) {
            compileParams.put("entry", tmpCompileJsPath);
            compileParams.put("template", this.mobileProject(projectPath, this.formDesignProperties.getMobileCompileHtmlPath()).getLocalPath());
            compileParams.put("output", FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getMobileCompilePath(), AppContextUtil.posixFilePathPrefix(), moduleRelatePath, pageName, File.separator}));
            compileParams.put("name", pageName);
            compileParams.put("path", moduleRelatePath);
            this.codePublishTool.compile(publishVueRelativePath, compileParams, this.formDesignProperties.getMobileCompileServer());
        }
    }

    private ResourcePath mobileProject(String name, String ... pathSegments) {
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getWorkspace(), name});
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }

    private ResourcePath mobileProjectVue(String name, String ... pathSegments) {
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getWorkspace(), name, this.formDesignProperties.getMobileVueCodePath()});
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }
}

