/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mobileui.vistor;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.constant.DataConfigConstant;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Trigger;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RadioGroupVoidVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        lcdpComponent.registerTemplatePath("/template/mobileui/vant/radioGroup/vant_radioGroup.ftl");
        lcdpComponent.addRenderParam("id", (Object)lcdpComponent.getInstanceKey());
        this.renderAttrs(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderOptionLoad(lcdpComponent, ctx);
        this.renderEvent(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String valueData = RenderVModelUtil.renderDataItem((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), null, null).getRenderValue();
        lcdpComponent.addRenderParam("bindData", (Object)valueData);
        String componentAttr = RenderVModelUtil.getComponentAttr((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("value"));
        lcdpComponent.addAttr(componentAttr, valueData);
        ComponentData componentData = RenderVModelUtil.renderDataItem((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._OPTION.getType(), Collections.singletonList("data"), (String)lcdpComponent.getProps().get("options").toString());
        String optionValue = componentData.getRenderValue();
        if (ToolUtil.isNotEmpty((Object)lcdpComponent.getListParentKeyChain()) && componentData.getComponentValueStatusEnum().equals("NONE")) {
            optionValue = lcdpComponent.getInstanceKey() + CodeSuffix._OPTION.getType();
            ctx.addData(optionValue + ": " + (ToolUtil.isNotEmpty((Object)componentData.getRenderValue()) ? componentData.getRenderValue() : "[]"), MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u9009\u9879"));
        }
        lcdpComponent.addAttr(":options", optionValue);
        lcdpComponent.addRenderParam("optionData", (Object)optionValue);
        String display = (String)lcdpComponent.getProps().get("display");
        lcdpComponent.addRenderParam("display", (Object)display);
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("labelDisabled"))) {
            Boolean labelDisabled = (Boolean)lcdpComponent.getProps().get("labelDisabled");
            ctx.addData(lcdpComponent.getInstanceKey() + "labelDisabled:" + labelDisabled, MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u6587\u672c\u5185\u5bb9\u70b9\u51fb\u7981\u7528"));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("labelPosition"))) {
            String labelPosition = lcdpComponent.getProps().get("labelPosition").toString();
            ctx.addData(lcdpComponent.getInstanceKey() + "labelPosition:'" + labelPosition + "'", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u6587\u672c\u4f4d\u7f6e"));
        }
    }

    private void renderOptionLoad(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSONObject.parseObject((String)JSONObject.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        boolean isBindData = false;
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
            if (dataSModelAnalysis.getType().equals("DataModel")) {
                DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
                Map dataSFieldAnalysisMap = dataSModelAnalysis.getFields();
                String labelField = "";
                String valueField = "";
                if (ToolUtil.isNotEmpty((Object)dataSFieldAnalysisMap)) {
                    for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                        List fieldAnalyses = (List)fieldList.getValue();
                        for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                            List dataItemPath = dataSFieldAnalysis.getDataItemPath();
                            if (ToolUtil.isNotEmpty((Object)dataItemPath) && "label".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                                labelField = dataSFieldAnalysis.getFieldName();
                            }
                            if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"value".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                            valueField = dataSFieldAnalysis.getFieldName();
                        }
                    }
                }
                if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)valueField)) {
                    String querySelectionName;
                    List conditionList;
                    isBindData = true;
                    HashMap<String, Object> selectMap = new HashMap<String, Object>();
                    String operationName = "hussarQuery";
                    String dataSelectId = lcdpComponent.getInstanceKey();
                    String apiFileName = "";
                    String apiFilePath = "";
                    String dataModelId = dataSModelAnalysis.getDataModelId();
                    if (ToolUtil.isNotEmpty((Object)dataModelId)) {
                        apiFileName = this.fileMappingService.getFileName(dataModelId);
                        apiFilePath = this.fileMappingService.getMobileImportPath(dataModelId);
                    }
                    if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataSConditionAnalysis.getQueryConditionModelList()))) {
                        selectMap.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                        selectMap.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                    }
                    if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataSConditionAnalysis.getSelectCondition()))) {
                        operationName = operationName + querySelectionName;
                    }
                    if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                        EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                    }
                    selectMap.put("importName", apiFileName);
                    selectMap.put("importMethod", operationName);
                    selectMap.put("insOption", dataSelectId + "Options");
                    selectMap.put("label", labelField);
                    selectMap.put("value", valueField);
                    selectMap.putAll(lcdpComponent.getRenderParamsToBind());
                    Map<String, String> relativeDataParams = this.setRelativeDataParams(lcdpComponent, dataSFieldAnalysisMap);
                    selectMap.put("relativeDataParams", relativeDataParams);
                    ctx.addMethod(lcdpComponent.getInstanceKey() + "OptionLoad", RenderUtil.renderTemplate((String)"/template/mobileui/vant/radioGroup/vant_optionLoad.ftl", selectMap));
                    ctx.addMounted(CodePrefix._THIS.getType() + lcdpComponent.getInstanceKey() + "OptionLoad();");
                }
            } else if (dataSModelAnalysis.getType().equals("CommonModel")) {
                isBindData = true;
                String apiFileName = "";
                String apiFilePath = "";
                String dataModelId = dataSModelAnalysis.getDataModelId();
                if (ToolUtil.isNotEmpty((Object)dataModelId)) {
                    apiFileName = this.fileMappingService.getFileName(dataModelId);
                    apiFilePath = this.fileMappingService.getMobileImportPath(dataModelId);
                }
                if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                    EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                }
                HashMap<String, String> selectMap = new HashMap<String, String>();
                selectMap.put("importName", apiFileName);
                selectMap.put("importMethod", DataConfigConstant.CommonModelCategory.DICT.getImportMethod());
                selectMap.put("instanceKey", lcdpComponent.getInstanceKey());
                selectMap.put("dictType", dataSModelAnalysis.getDictType());
                ctx.addMethod(lcdpComponent.getInstanceKey() + "OptionLoad", RenderUtil.renderTemplate((String)"/template/mobileui/vant/radioGroup/option_load_from_dict.ftl", selectMap), false);
                ctx.getDictInfo().addOptionLoads(CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + "OptionLoad();");
                ctx.getDictInfo().addDicts(dataSAnalysis.getDatamodel().getDictType());
            }
        }
        if (!isBindData) {
            ctx.addMethod(lcdpComponent.getInstanceKey() + "OptionLoad", "");
        }
    }

    private Map<String, String> setRelativeDataParams(LcdpComponent lcdpComponent, Map<String, List<DataSFieldAnalysis>> dataSFieldAnalysisMap) {
        HashMap<String, String> relativeParams = new HashMap<String, String>();
        JSONArray array = (JSONArray)lcdpComponent.getProps().get("relativeData");
        if (HussarUtils.isNotEmpty((Object)array) && HussarUtils.isNotEmpty(dataSFieldAnalysisMap)) {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = array.getJSONObject(i);
                String relativeField = String.valueOf(obj.get((Object)"field"));
                String relativeId = String.valueOf(obj.get((Object)"id"));
                block1: for (Map.Entry<String, List<DataSFieldAnalysis>> entry : dataSFieldAnalysisMap.entrySet()) {
                    if (!HussarUtils.isNotEmpty(entry.getValue())) continue;
                    for (DataSFieldAnalysis analysis : entry.getValue()) {
                        if (!relativeId.equals(analysis.getDataItemPath().get(1))) continue;
                        relativeParams.put(relativeField, entry.getKey());
                        continue block1;
                    }
                }
            }
        }
        return relativeParams;
    }

    private void renderEvent(LcdpComponent lcdpComponent, Ctx ctx) {
        List eventConfigs = lcdpComponent.getEvents();
        ArrayList events = new ArrayList();
        String clickFunctionName = "";
        for (int i = 0; i < eventConfigs.size(); ++i) {
            EventConfig eventConfig = (EventConfig)eventConfigs.get(i);
            if (!"click".equals(eventConfig.getTrigger())) continue;
            clickFunctionName = lcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)eventConfig.getTrigger());
            break;
        }
        if (ToolUtil.isNotEmpty((Object)clickFunctionName)) {
            lcdpComponent.addRenderParam("clickEvent", (Object)clickFunctionName);
        }
        int index = -1;
        List triggers = lcdpComponent.getTrigger();
        for (int i = 0; i < triggers.size(); ++i) {
            Trigger trigger = (Trigger)triggers.get(i);
            if (!"click".equals(trigger.getName())) continue;
            index = i;
            break;
        }
        if (index != -1) {
            triggers.remove(index);
        }
    }
}

