/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mobileui.provide;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.form.FormColsAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventParamConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.mobileui.JXDMobileSteps.value")
@Scope(value="prototype")
public class StepsValueProvide
implements ValueVisitor<LcdpComponent, Ctx> {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public Map<String, String> getComponentColMapping() {
        JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("component_cols");
        List formColsList = cols.toJavaList(FormColsAnalysis.class);
        HashMap<String, String> map = new HashMap<String, String>(16);
        formColsList.forEach(col -> map.put(col.getId(), col.getField()));
        return map;
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        ComponentData data = new ComponentData();
        if (ToolUtil.isNotEmpty(dataItems)) {
            String dataItem;
            switch (dataItem = dataItems.get(0)) {
                case "value": {
                    this.getValueData();
                    break;
                }
                case "item": {
                    this.getSelectAndTableData(dataItems, data, dataItem);
                    break;
                }
            }
        } else {
            this.getValueData();
        }
        return data;
    }

    private ComponentData getValueData() throws LcdpException {
        ComponentData optionData = new ComponentData();
        ArrayList<String> optionDataItem = new ArrayList<String>();
        optionDataItem.add("value");
        optionData.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
        optionData.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"StepsActiveIndex", optionDataItem));
        return optionData;
    }

    public ComponentData getDefaultValueByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    public ComponentData getDataSourceByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    public String getDefaultValue() {
        return "''";
    }

    public List<ComponentData> getClearValue(List<String> list) throws LcdpException {
        return null;
    }

    public ComponentData getEventParam(EventParamConfig eventParamConfig) throws LcdpException {
        return null;
    }

    public String setValue(List<String> list) throws LcdpException {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._LIST_ITEM_DATA.getType();
    }

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> map) throws LcdpException {
        this.lcdpComponent = lcdpComponent;
        this.params = this.params;
        this.ctx = ctx;
    }

    private void getSelectAndTableData(List<String> dataItems, ComponentData data, String dataItem) throws LcdpException {
        String dataValue;
        data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        ArrayList<String> currDataItem = new ArrayList<String>();
        if (dataItem.equals("item")) {
            currDataItem.add("item");
            dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"item", currDataItem);
        } else {
            currDataItem.add("value");
            dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"StepsData", currDataItem);
        }
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
            JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("component_cols");
            for (Object col : cols) {
                JSONObject colObj = (JSONObject)col;
                if (!colObj.getString("id").equals(dataItems.get(1))) continue;
                data.setRenderValue(dataValue + "." + colObj.getString("field"));
                data.setDataType(((JSONObject)col).getString("dataType"));
            }
        } else {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            data.setRenderValue(dataValue);
        }
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }
}

