/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mobileui.provide;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.form.FormColsAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventParamConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.mobileui.JXDMobileCheckedList.value")
@Scope(value="prototype")
public class CheckedListValueProvide
implements ValueVisitor<LcdpComponent, Ctx> {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) throws LcdpException {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        ComponentData data = new ComponentData();
        if (ToolUtil.isNotEmpty(dataItems)) {
            String dataItem;
            switch (dataItem = dataItems.get(0)) {
                case "page": {
                    this.getPageData(dataItems, data);
                    break;
                }
                case "total": {
                    data.setDataType(ComponentData.DataTypeEnum.INTEGER);
                    data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"ListTotal", dataItems));
                    break;
                }
                default: {
                    this.getListValueOrCheckedData(dataItems, data);
                    break;
                }
            }
        } else {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            ArrayList<String> currDataItem = new ArrayList<String>();
            currDataItem.add("item");
            data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"ListData", currDataItem));
        }
        return data;
    }

    public ComponentData getDefaultValueByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    public ComponentData getDataSourceByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    public List<ComponentData> getClearValue(List<String> list) throws LcdpException {
        return null;
    }

    public ComponentData getEventParam(EventParamConfig eventParamConfig) throws LcdpException {
        return null;
    }

    private void getPageData(List<String> dataItems, ComponentData data) throws LcdpException {
        ArrayList<String> pageDataItem = new ArrayList<String>();
        pageDataItem.add("page");
        String pageValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"page", pageDataItem);
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.INTEGER);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
            if ("current".equals(dataItems.get(1))) {
                data.setRenderValue(pageValue + ".current");
            } else if ("size".equals(dataItems.get(1))) {
                data.setRenderValue(pageValue + ".size");
            } else if ("total".equals(dataItems.get(1))) {
                data.setRenderValue(pageValue + ".total");
            }
        } else {
            data.setDataType(ComponentData.DataTypeEnum.OBJECT);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
            data.setRenderValue(pageValue);
        }
    }

    private void getListValueOrCheckedData(List<String> dataItems, ComponentData data) throws LcdpException {
        data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        ArrayList<String> currDataItem = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dataItems) && dataItems.size() == 1) {
            String dataValue = "";
            if (dataItems.get(0).equals("checked")) {
                currDataItem.add("v");
                dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"Checked", currDataItem);
                data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
                data.setRenderValue(dataValue);
            } else if (dataItems.get(0).equals("value")) {
                currDataItem.add("value");
                dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"ListData", currDataItem);
                data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
                data.setRenderValue(dataValue);
            } else {
                this.getListItemData(dataItems, data);
            }
        } else {
            this.getListItemData(dataItems, data);
        }
    }

    private void getListItemData(List<String> dataItem, ComponentData data) throws LcdpException {
        data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        if (dataItem.size() == 2 && "checked".equals(dataItem.get(0))) {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
            ArrayList<String> currDataItem = new ArrayList<String>();
            currDataItem.add("checked");
            String dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"Checked", currDataItem);
            String checkDataType = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)"CheckDataType", currDataItem);
            JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("component_cols");
            for (Object col : cols) {
                JSONObject colObj = (JSONObject)col;
                if (!colObj.getString("id").equals(dataItem.get(1))) continue;
                data.setRenderValue("function(){\nlet result = [];\nif(" + dataValue + ".length){\nif(" + checkDataType + "==='list'){" + dataValue + ".forEach((item) => result.push(item." + colObj.getString("field") + "));}else{" + dataValue + ".forEach((item,index) => {result += item." + colObj.getString("field") + ";\nif(index !== " + dataValue + ".length - 1){result += ','}});}}else{\nresult = " + dataValue + "." + colObj.getString("field") + "}return result;}()");
                data.setDataType(((JSONObject)col).getString("dataType"));
            }
        } else {
            String id = "";
            id = dataItem.size() == 1 ? dataItem.get(0) : dataItem.get(1);
            JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("component_cols");
            for (Object col : cols) {
                JSONObject colObj = (JSONObject)col;
                if (!colObj.getString("id").equals(id)) continue;
                data.setRenderValue(this.lcdpComponent.getInstanceKey() + "Item." + colObj.getString("field"));
                data.setDataType(((JSONObject)col).getString("dataType"));
                break;
            }
        }
    }

    public String setValue(List<String> dataItems) {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._LIST_ITEM_DATA.getType();
    }

    public Map<String, String> getComponentColMapping() {
        JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("component_cols");
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (ToolUtil.isNotEmpty((Object)cols)) {
            List formColsList = cols.toJavaList(FormColsAnalysis.class);
            formColsList.forEach(col -> map.put(col.getId(), col.getField()));
        }
        return map;
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public String getDefaultValue() {
        return "''";
    }
}

