/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.util.stream.Collectors;

public class TableLayoutVoidVisitor
implements VoidVisitor {
    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/elementui/element/tableLayout/el_tableLayout.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderGridTemplateStyles(lcdpComponent, ctx);
        this.renderCellStylesAndClass(lcdpComponent);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealHiddenAttr(lcdpComponent, ctx);
    }

    private void renderGridTemplateStyles(LcdpComponent lcdpComponent, Ctx ctx) {
        JSONObject tableConfigs = (JSONObject)lcdpComponent.getProps().get("tableConfigs");
        if (ToolUtil.isNotEmpty((Object)tableConfigs)) {
            JSONArray gridRows = tableConfigs.getJSONArray("gridRows");
            StringBuilder gridTemplateRows = new StringBuilder(lcdpComponent.getInstanceKey() + "AutoRows:'");
            gridRows.forEach(o -> {
                JSONObject row = (JSONObject)o;
                if (ToolUtil.isNotEmpty((Object)lcdpComponent.isAutoHeight()) && lcdpComponent.isAutoHeight()) {
                    if (ToolUtil.isNotEmpty((Object)row.getString("auto"))) {
                        gridTemplateRows.append("minmax(").append(row.getString("auto")).append(", auto) ");
                    } else {
                        gridTemplateRows.append("minmax(").append(row.getString("default")).append(", auto) ");
                    }
                } else if (ToolUtil.isNotEmpty((Object)row.getString("auto"))) {
                    gridTemplateRows.append(row.getString("auto")).append(" ");
                } else {
                    gridTemplateRows.append(row.getString("default")).append(" ");
                }
            });
            ctx.addDataCommon(gridTemplateRows.deleteCharAt(gridTemplateRows.length() - 1).append("'").toString());
            JSONArray gridCols = tableConfigs.getJSONArray("gridCols");
            StringBuilder gridTemplateCols = new StringBuilder(lcdpComponent.getInstanceKey() + "Columns:'");
            gridCols.forEach(col -> gridTemplateCols.append(col.toString()).append(" "));
            ctx.addDataCommon(gridTemplateCols.deleteCharAt(gridTemplateCols.length() - 1).append("'").toString());
            JSONArray gridAreas = tableConfigs.getJSONArray("gridAreas");
            StringBuilder gridTemplateAreas = new StringBuilder(lcdpComponent.getInstanceKey() + "Areas:\"");
            for (Object o2 : gridAreas) {
                JSONArray area = (JSONArray)o2;
                StringBuilder cellTemp = new StringBuilder();
                area.forEach(cell -> cellTemp.append(cell.toString()).append(" "));
                gridTemplateAreas.append("'").append(cellTemp.deleteCharAt(cellTemp.length() - 1).toString()).append("'").append(" ");
            }
            lcdpComponent.addRenderParam("gridAreas", (Object)gridAreas);
            ctx.addDataCommon(gridTemplateAreas.deleteCharAt(gridTemplateAreas.length() - 1).append("\"").toString());
        }
    }

    private void renderCellStylesAndClass(LcdpComponent lcdpComponent) {
        JSONObject tableConfigs = (JSONObject)lcdpComponent.getProps().get("tableConfigs");
        JSONArray gridAreas = tableConfigs.getJSONArray("gridAreas");
        JSONArray tableCells = tableConfigs.getJSONArray("tableCells");
        for (Object o : tableCells) {
            JSONObject cell = (JSONObject)o;
            String name = cell.getString("slotName");
            StringBuilder cellClass = new StringBuilder("table-grid-container-cell ");
            StringBuilder cellStyles = new StringBuilder();
            if (ToolUtil.isNotEmpty((Object)cell.getString("background"))) {
                cellStyles.append("background:").append(cell.getString("background")).append(";");
            }
            if (ToolUtil.isNotEmpty((Object)cell.getString("alignItems"))) {
                cellStyles.append("justify-content:").append(cell.getString("alignItems")).append(";");
            }
            for (int i = 0; i < gridAreas.size(); ++i) {
                JSONArray area = (JSONArray)gridAreas.get(i);
                int cellIndex = area.indexOf((Object)name);
                if (cellIndex != -1 && i == 0) {
                    cellClass.append("table-layout-top-side ");
                    if (ToolUtil.isNotEmpty((Object)cell.getString("borderTop"))) {
                        cellStyles.append("border-top:").append(cell.getString("borderTop")).append(";");
                    }
                }
                if (cellIndex != -1 && i == gridAreas.size() - 1) {
                    cellClass.append("table-layout-bottom-side ");
                }
                if (cellIndex != -1 && ToolUtil.isNotEmpty((Object)cell.getString("borderBottom"))) {
                    cellStyles.append("border-bottom:").append(cell.getString("borderBottom")).append(";");
                } else if (cellIndex != -1 && i != gridAreas.size() - 1) {
                    JSONArray nextRow = (JSONArray)gridAreas.get(i + 1);
                    String bottomCellName = nextRow.get(cellIndex).toString();
                    JSONObject bottomCell = (JSONObject)tableCells.stream().filter(tableCell -> JSON.parseObject((String)JSON.toJSONString((Object)tableCell)).getString("slotName").equals(bottomCellName)).collect(Collectors.toList()).get(0);
                    if (ToolUtil.isNotEmpty((Object)bottomCell.getString("borderTop"))) {
                        cellStyles.append("border-bottom:").append(bottomCell.getString("borderTop")).append(";");
                    }
                }
                if (cellIndex == 0) {
                    cellClass.append("table-layout-left-side ");
                }
                if (cellIndex != -1 && ToolUtil.isNotEmpty((Object)cell.getString("borderLeft"))) {
                    cellStyles.append("border-left:").append(cell.getString("borderLeft")).append(";");
                } else if (cellIndex > 0) {
                    String leftCellName = area.get(cellIndex - 1).toString();
                    JSONObject leftCell = (JSONObject)tableCells.stream().filter(tableCell -> JSON.parseObject((String)JSON.toJSONString((Object)tableCell)).getString("slotName").equals(leftCellName)).collect(Collectors.toList()).get(0);
                    if (ToolUtil.isNotEmpty((Object)leftCell.getString("borderRight"))) {
                        cellStyles.append("border-left:").append(leftCell.getString("borderRight")).append(";");
                    }
                }
                if (area.lastIndexOf((Object)name) != area.size() - 1) continue;
                cellClass.append("table-layout-right-side ");
                if (!ToolUtil.isNotEmpty((Object)cell.getString("borderRight"))) continue;
                cellStyles.append("border-right:").append(cell.getString("borderRight")).append(";");
            }
            cell.put("cellClass", (Object)cellClass.deleteCharAt(cellClass.length() - 1).toString());
            cell.put("cellStyles", (Object)cellStyles.toString());
        }
        lcdpComponent.addRenderParam("tableCells", (Object)tableCells);
    }
}

