/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.jgit.transport;

import com.jxdinfo.hussar.formdesign.jgit.lib.BatchingProgressMonitor;
import com.jxdinfo.hussar.formdesign.jgit.lib.Constants;
import java.io.IOException;
import java.io.OutputStream;

class SideBandProgressMonitor
extends BatchingProgressMonitor {
    private final OutputStream out;
    private boolean write;

    SideBandProgressMonitor(OutputStream os) {
        this.out = os;
        this.write = true;
    }

    @Override
    protected void onUpdate(String taskName, int workCurr) {
        StringBuilder s = new StringBuilder();
        this.format(s, taskName, workCurr);
        s.append("   \r");
        this.send(s);
    }

    @Override
    protected void onEndTask(String taskName, int workCurr) {
        StringBuilder s = new StringBuilder();
        this.format(s, taskName, workCurr);
        s.append(", done\n");
        this.send(s);
    }

    private void format(StringBuilder s, String taskName, int workCurr) {
        s.append(taskName);
        s.append(": ");
        s.append(workCurr);
    }

    @Override
    protected void onUpdate(String taskName, int cmp, int totalWork, int pcnt) {
        StringBuilder s = new StringBuilder();
        this.format(s, taskName, cmp, totalWork, pcnt);
        s.append("   \r");
        this.send(s);
    }

    @Override
    protected void onEndTask(String taskName, int cmp, int totalWork, int pcnt) {
        StringBuilder s = new StringBuilder();
        this.format(s, taskName, cmp, totalWork, pcnt);
        s.append("\n");
        this.send(s);
    }

    private void format(StringBuilder s, String taskName, int cmp, int totalWork, int pcnt) {
        s.append(taskName);
        s.append(": ");
        if (pcnt < 100) {
            s.append(' ');
        }
        if (pcnt < 10) {
            s.append(' ');
        }
        s.append(pcnt);
        s.append("% (");
        s.append(cmp);
        s.append("/");
        s.append(totalWork);
        s.append(")");
    }

    private void send(StringBuilder s) {
        if (this.write) {
            try {
                this.out.write(Constants.encode(s.toString()));
                this.out.flush();
            }
            catch (IOException err) {
                this.write = false;
            }
        }
    }
}

